/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.metric;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.metric.MetricSpec;
import com.kingdee.bos.streamwork.metric.MetricUI;
import com.kingdee.bos.streamwork.metric.PercentMetric;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.model.DataModel2;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PercentMetricUI
extends MetricUI {
    private KDComboBox cbPrecision;
    private KDCheckBox cbShowPercent;
    private KDRadioButton rbForAll;
    private KDRadioButton rbForDimension;
    private KDComboBox cbDimension;
    private KDComboBox cbMeasure;

    @Override
    public Metric getMetric(String name, String caption) {
        Measure measure = (Measure)this.cbMeasure.getSelectedItem();
        MetricSpec spec = new MetricSpec();
        spec.put("measure", measure.getId());
        if (this.rbForDimension.isSelected()) {
            spec.put("dimension", (String)this.cbDimension.getSelectedItem());
        }
        spec.put("showPercent", this.cbShowPercent.isSelected() ? "true" : "false");
        return new PercentMetric(name, caption, spec);
    }

    @Override
    public boolean verify(Window parent) {
        if (this.cbMeasure.getSelectedIndex() == 0) {
            PivotUtils.alert("\u8bf7\u9009\u62e9\u7edf\u8ba1\u5b57\u6bb5", parent);
            return false;
        }
        if (this.rbForDimension.isSelected() && this.cbDimension.getSelectedIndex() == 0) {
            PivotUtils.alert("\u8bf7\u9009\u62e9\u6c42\u6bd4\u4f8b\u5b57\u6bb5", parent);
            return false;
        }
        return true;
    }

    @Override
    public void initUI() {
        this.cbPrecision = new KDComboBox(new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
        this.cbPrecision.setSize(40, 20);
        this.cbPrecision.setPreferredSize(new Dimension(60, 20));
        this.cbPrecision.setSelectedIndex(2);
        this.cbPrecision.setOpaque(true);
        KDLabelContainer lcPrecision = new KDLabelContainer("\u663e\u793a\u7cbe\u5ea6", (JComponent)this.cbPrecision);
        lcPrecision.setBoundLabelLength(100);
        this.cbShowPercent = new KDCheckBox();
        this.cbShowPercent.setSelected(true);
        KDLabelContainer lcShowPercent = new KDLabelContainer("\u662f\u5426\u663e\u793a\u767e\u5206\u6bd4", (JComponent)this.cbShowPercent);
        lcShowPercent.setBoundLabelLength(100);
        this.rbForAll = new KDRadioButton("\u5bf9\u5408\u8ba1\u884c\u6c42\u6bd4\u4f8b");
        this.rbForDimension = new KDRadioButton("\u5bf9\u67d0\u4e2a\u5b57\u6bb5\u7684\u5c0f\u8ba1\u884c\u6c42\u6bd4\u4f8b");
        KDButtonGroup group = new KDButtonGroup();
        group.add((AbstractButton)this.rbForAll);
        group.add((AbstractButton)this.rbForDimension);
        this.rbForAll.setSelected(true);
        this.cbDimension = new KDComboBox();
        KDLabelContainer lcForDimension = new KDLabelContainer("\u6c42\u6bd4\u4f8b\u5b57\u6bb5", (JComponent)this.cbDimension);
        lcForDimension.setBoundLabelLength(100);
        this.cbMeasure = new KDComboBox();
        this.cbMeasure.setPreferredSize(new Dimension(250, 20));
        KDLabelContainer lcForMeasure = new KDLabelContainer("\u7edf\u8ba1\u5b57\u6bb5", (JComponent)this.cbMeasure);
        lcForMeasure.setBoundLabelLength(100);
        lcForMeasure.setPreferredSize(new Dimension(400, 20));
        KDPanel topPanel = new KDPanel();
        TableLayout layout = new TableLayout(5, 1);
        topPanel.setLayout((LayoutManager)layout);
        topPanel.setPreferredSize(new Dimension(600, 120));
        int cellIndex = 0;
        topPanel.add((Component)lcForMeasure, (Object)layout.cell(cellIndex++));
        KDPanel rbPanel = new KDPanel();
        rbPanel.setLayout((LayoutManager)new FlowLayout());
        rbPanel.add((Component)this.rbForAll);
        rbPanel.add((Component)this.rbForDimension);
        topPanel.add((Component)lcShowPercent, (Object)layout.cell(cellIndex++));
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "Center");
        this.rbForAll.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PercentMetricUI.this.rbChanged();
            }
        });
        this.rbForDimension.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PercentMetricUI.this.rbChanged();
            }
        });
        this.rbChanged();
    }

    private void rbChanged() {
        this.cbDimension.setEnabled(this.rbForDimension.isSelected());
    }

    private void loadMeasure(Measure[] measures, KDComboBox cb) {
        Object o = cb.getSelectedItem();
        Measure oldMeasure = null;
        if (o != null) {
            cb.removeAllItems();
            if (o instanceof Measure) {
                oldMeasure = (Measure)o;
            }
        }
        cb.addItem((Object)"--\u9009\u62e9\u7edf\u8ba1\u5b57\u6bb5--");
        int index = -1;
        for (int i = 0; i < measures.length; ++i) {
            if (measures[i].isMetric) continue;
            cb.addItem((Object)measures[i]);
            if (oldMeasure == null || !measures[i].name.equals(oldMeasure.name)) continue;
            index = i + 1;
        }
    }

    private void loadDimension(String[] rows, KDComboBox cb) {
        String o = (String)cb.getSelectedItem();
        int index = cb.getSelectedIndex();
        cb.removeAllItems();
        cb.addItem((Object)"--\u8bf7\u9009\u62e9\u6c42\u6bd4\u4f8b\u5b57\u6bb5--");
        index = -1;
        for (int i = 0; i < rows.length; ++i) {
            cb.addItem((Object)rows[i]);
            if (o == null || !rows[i].equals(o)) continue;
            index = i + 1;
        }
    }

    @Override
    public void setDataModel(DataModel2 dataModel) {
        Measure[] measures = dataModel.getMeasures();
        this.loadMeasure(measures, this.cbMeasure);
        String[] rows = dataModel.getColumnsOnRows();
        this.loadDimension(rows, this.cbDimension);
    }

    @Override
    public void setInitMetric(Metric metric) {
        MetricSpec spec = metric.getSpec();
        String measureId = spec.get("measure");
        this.initMeasure(this.cbMeasure, measureId);
        String dimension = spec.get("dimension");
        if (dimension != null) {
            this.rbForDimension.setSelected(true);
            this.initCBByObject(this.cbDimension, dimension);
        }
        this.cbShowPercent.setSelected("true".equals(spec.get("showPercent")));
    }

    private void initCBByObject(KDComboBox cb, Object o) {
        for (int i = 1; i < cb.getItemCount(); ++i) {
            if (!cb.getItemAt(i).equals(o)) continue;
            cb.setSelectedIndex(i);
            return;
        }
    }

    private void initMeasure(KDComboBox cb, String measureId) {
        for (int i = 1; i < cb.getItemCount(); ++i) {
            Measure measure = (Measure)cb.getItemAt(i);
            if (!measure.getId().equals(measureId)) continue;
            cb.setSelectedIndex(i);
            return;
        }
    }
}

