/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.streamwork.DataSourceTimeoutException;
import com.kingdee.bos.streamwork.calculator.CalculatedField;
import com.kingdee.bos.streamwork.calculator.Expr;
import com.kingdee.bos.streamwork.calculator.ExprParser;
import com.kingdee.bos.streamwork.calculator.MapExecuteContext;
import com.kingdee.bos.streamwork.calculator.VerifyVisitor;
import com.kingdee.bos.streamwork.client.EASQuerySchemaStorage;
import com.kingdee.bos.streamwork.client.UIDesc;
import com.kingdee.bos.streamwork.cuba.MdxResult;
import com.kingdee.bos.streamwork.cuba.ResultOverflowInfo;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.datasource.DataSourceBuilder;
import com.kingdee.bos.streamwork.datasource.DataSourceWithCalculate;
import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.pivot.AboutDialog;
import com.kingdee.bos.streamwork.pivot.ChartFrame;
import com.kingdee.bos.streamwork.pivot.DebugDialog;
import com.kingdee.bos.streamwork.pivot.DetailListListener;
import com.kingdee.bos.streamwork.pivot.DetailListUI;
import com.kingdee.bos.streamwork.pivot.EASPivotFrame;
import com.kingdee.bos.streamwork.pivot.Executor;
import com.kingdee.bos.streamwork.pivot.ExecutorFactory;
import com.kingdee.bos.streamwork.pivot.Location;
import com.kingdee.bos.streamwork.pivot.PivotException;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.easui.BillConfigDialog;
import com.kingdee.bos.streamwork.pivot.easui.ColumnItem;
import com.kingdee.bos.streamwork.pivot.easui.ColumnItemContainer;
import com.kingdee.bos.streamwork.pivot.easui.ComponentOption;
import com.kingdee.bos.streamwork.pivot.easui.ConditionChangeCallback;
import com.kingdee.bos.streamwork.pivot.easui.RemoveCalculatedItemCallback;
import com.kingdee.bos.streamwork.pivot.easui.ValueSelectContainer;
import com.kingdee.bos.streamwork.pivot.easui.dnd.PanelDropTarget;
import com.kingdee.bos.streamwork.pivot.execute.OrderedMdxResult;
import com.kingdee.bos.streamwork.pivot.model.ColumnValues;
import com.kingdee.bos.streamwork.pivot.model.DataModel2;
import com.kingdee.bos.streamwork.pivot.model.DataModelListener;
import com.kingdee.bos.streamwork.pivot.model.Dimension;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import com.kingdee.bos.streamwork.pivot.model.Member;
import com.kingdee.bos.streamwork.pivot.model.MemberSelection;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import com.kingdee.bos.streamwork.pivot.model.ResultModel;
import com.kingdee.bos.streamwork.pivot.schema.IQuerySchemaStorage;
import com.kingdee.bos.streamwork.pivot.schema.LocalFileStorage;
import com.kingdee.bos.streamwork.pivot.schema.QuerySchema;
import com.kingdee.bos.streamwork.pivot.worksheet.Config;
import com.kingdee.bos.streamwork.pivot.worksheet.FileChooserUtil;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotDataCellItem;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotMemberCellItem;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotWorksheetComponent;
import com.kingdee.bos.streamwork.xls.POIReader;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class EASPivotComponent
extends KDPanel {
    private static final Logger logger = Logger.getLogger(EASPivotComponent.class);
    private DataSourceWithCalculate dataSource;
    DataModel2 dataModel = null;
    PivotWorksheetComponent wc = null;
    KDCheckBoxMenuItem item;
    KDTable table = null;
    KDPanel tablePanel = null;
    KDPanel overflowPanel;
    ColumnItemContainer allColumnItemContainer;
    ColumnItemContainer rowItemContainer;
    ColumnItemContainer columnItemContainer;
    ColumnItemContainer metricItemContainer;
    KDCheckBox cbShowSubTotalOnRow;
    KDCheckBox cbShowTotalOnRow;
    KDCheckBox cbShowSubTotalOnColumn;
    KDCheckBox cbShowTotalOnColumn;
    KDComboBox cbColumnModel;
    KDComboBox cbScale;
    KDCheckBox cbShowChart;
    KDButton btnAddMetric;
    ValueSelectContainer valueSelectContainer = null;
    KDSplitPane splitPane;
    private KDToolBar toolBar;
    private QuerySchema querySchema;
    private UIDesc uiDesc;
    private ChartFrame chartFrame;
    AboutDialog aboutDialog;
    private IQuerySchemaStorage storage;
    private IQuerySchemaStorage localStorage;
    private FileChooserUtil chooser;
    private KDTSelectListener selectListener = new KDTSelectListener(){

        public void tableSelectChanged(KDTSelectEvent e) {
            KDTSelectBlock block = e.getSelectBlock();
            int left = block.getLeft();
            int top = block.getTop();
            int right = block.getRight();
            int bottom = block.getBottom();
            EASPivotComponent.this.showChart(top, left, bottom, right);
        }
    };
    private boolean showChart = true;
    KDTMouseListener mouseListener = new KDTMouseListener(){

        public void tableClicked(KDTMouseEvent e) {
            int row = e.getRowIndex();
            int column = e.getColIndex();
            if (row >= 0 && column >= 0 && SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                EASPivotComponent.this.cellClicked(EASPivotComponent.this.table, e.getClickCount() == 2, row, column, e.getOriginView(), e.getX(), e.getY(), e.getType() == 0);
            }
        }
    };
    DetailListListener detailListener = new DetailListListener(){

        @Override
        public void call(Map memberContext) {
            EASPivotComponent.this.showDetail(memberContext);
        }
    };
    private com.kingdee.bos.streamwork.cuba.Member orderMeasure;
    private boolean orderDesc;
    QueryModel queryModel;
    Executor executor;
    boolean lastOnColumn = false;
    ResultModel<MdxResult> resultModel;
    MdxResult mdxResult;

    public EASPivotComponent(DataSource dataSource) {
        this(dataSource, null);
    }

    public EASPivotComponent(DataSource dataSource, QuerySchema querySchema) {
        if (!(dataSource instanceof DataSourceWithCalculate)) {
            dataSource = new DataSourceWithCalculate(dataSource);
        }
        this.dataSource = (DataSourceWithCalculate)dataSource;
        this.uiDesc = (UIDesc)dataSource.getProperty("uiDesc");
        this.storage = (IQuerySchemaStorage)this.dataSource.getProperty("querySchemaStorage");
        if (this.storage == null && this.uiDesc != null) {
            this.storage = new EASQuerySchemaStorage((JComponent)((Object)this));
        }
        this.localStorage = new LocalFileStorage();
        this.dataModel = new DataModel2(dataSource);
        if (querySchema == null) {
            querySchema = this.createDefaultQuerySchema();
        }
        this.querySchema = querySchema;
        ArrayList errorCollector = new ArrayList();
        this.applyQuerySchema1(querySchema, errorCollector);
        this.initUI();
        this.applyQuerySchema2(querySchema, errorCollector);
        this.initListener();
        this.changeUIStyleWhenConditionChanged();
        this.modelChangedImpl(true);
        String content = (String)dataSource.getProperty("defaultQuerySchema");
        if (content != null) {
            QuerySchema q = QuerySchema.newQuerySchema(content);
            this.applyQuerySchemaLater(q, 1000);
        }
    }

    private QuerySchema createDefaultQuerySchema() {
        QuerySchema querySchema = new QuerySchema();
        querySchema.number = "001";
        querySchema.name = "\u9ed8\u8ba4\u65b9\u6848";
        ArrayList<Measure> list = new ArrayList<Measure>();
        String[] measures = this.dataModel.getColumnsCanbeMeasure();
        for (int i = 0; i < measures.length && i < 2; ++i) {
            Measure m = this.dataModel.createMeasure(measures[i], 0);
            list.add(m);
        }
        list.add(this.dataModel.createMeasure("\u884c\u8ba1\u6570", -1));
        querySchema.measures = list.toArray(new Measure[0]);
        String[] columns = new String[this.dataModel.getColumnsCanbeDimension().length];
        System.arraycopy(this.dataModel.getColumnsCanbeDimension(), 0, columns, 0, columns.length);
        Arrays.sort(columns, new Comparator(){

            public int compare(Object o1, Object o2) {
                String c1 = (String)o1;
                String c2 = (String)o2;
                int size1 = EASPivotComponent.this.dataModel.getColumnValues(c1).getValues().size();
                int size2 = EASPivotComponent.this.dataModel.getColumnValues(c2).getValues().size();
                if (size1 == 1) {
                    size1 = Integer.MAX_VALUE;
                }
                if (size2 == 1) {
                    size2 = Integer.MAX_VALUE;
                }
                return size1 - size2;
            }
        });
        ArrayList<String> list2 = new ArrayList<String>();
        for (int i = 0; i < columns.length && i < 4; ++i) {
            list2.add(columns[i]);
        }
        querySchema.dimensionOnFilters = list2.toArray(new String[0]);
        querySchema.columnModel = 0;
        querySchema.showSubTotalOnColumn = false;
        querySchema.showSubTotalOnRow = false;
        querySchema.showTotalOnColumn = false;
        querySchema.showTotalOnRow = true;
        return querySchema;
    }

    private void applyQuerySchemaLater(final QuerySchema q, final int timeout) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EASPivotComponent.this.applyQuerySchema(q);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public void applyQuerySchema(QuerySchema querySchema) {
        try {
            this.dataModel.disableListeners();
            ArrayList errorCollector = new ArrayList();
            this.applyQuerySchema1(querySchema, errorCollector);
            this.applyQuerySchema2(querySchema, errorCollector);
            this.dataModel.enableListeners();
            this.dataModel.modelChanged(true);
        }
        finally {
            this.dataModel.enableListeners();
        }
    }

    private void applyQuerySchema1(QuerySchema querySchema, List errorCollector) {
        this.dataModel.clearCalculatedFields();
        if (querySchema.calculatedFields != null) {
            for (int i = 0; i < querySchema.calculatedFields.length; ++i) {
                CalculatedField field1 = querySchema.calculatedFields[i];
                if (!this.checkCalculatedField(this.dataModel.getAllColumns(), field1, errorCollector)) continue;
                CalculatedField field2 = new CalculatedField(field1.name, field1.type, field1.text, ExprParser.parse(field1.text));
                this.dataModel.addCalculatedField(field2);
            }
        }
        this.dataModel.clearMetric();
        if (querySchema.metrics != null) {
            for (Metric metric : querySchema.metrics) {
                this.dataModel.addMetric(metric);
            }
        }
    }

    private void applyQuerySchema2(QuerySchema querySchema, List errorCollector) {
        String[] columns;
        this.initAllColumns();
        this.dataModel.columnModel = querySchema.columnModel;
        this.dataModel.showSubTotalOnColumn = querySchema.showSubTotalOnColumn;
        this.dataModel.showSubTotalOnRow = querySchema.showSubTotalOnRow;
        this.dataModel.showTotalOnColumn = querySchema.showTotalOnColumn;
        this.dataModel.showTotalOnRow = querySchema.showTotalOnRow;
        if (querySchema.billHeaderFields != null) {
            this.dataModel.getDataSource().setProperty("billHeaderFields", querySchema.billHeaderFields);
            this.dataModel.getDataSource().setProperty("billNumberField", querySchema.billNumberField);
        }
        List<String> allColumns = Arrays.asList(this.dataModel.getAllColumns());
        this.metricItemContainer.removeAllComponents();
        Measure[] measures = this.checkMeasures(allColumns, querySchema.measures, errorCollector);
        if (measures != null && measures.length > 0) {
            int i;
            columns = new String[measures.length];
            int[] aggTypes = new int[measures.length];
            for (i = 0; i < measures.length; ++i) {
                columns[i] = measures[i].name;
                aggTypes[i] = measures[i].aggType;
            }
            for (i = 0; i < measures.length; ++i) {
                this.metricItemContainer.addItemComponent(measures[i].name);
            }
            this.dataModel.setColumnsOnMeasure(columns, aggTypes);
            this.metricItemContainer.setAggTypes(aggTypes);
        } else {
            this.dataModel.setColumnsOnMeasure(null, null);
        }
        this.metricItemContainer.layoutUI();
        this.rowItemContainer.removeAllComponents();
        columns = this.checkColumns(allColumns, querySchema.dimensionOnRows, errorCollector);
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                this.rowItemContainer.addItemComponent(column);
            }
        }
        this.dataModel.setColumnsOnRows(columns);
        this.rowItemContainer.layoutUI();
        this.columnItemContainer.removeAllComponents();
        columns = this.checkColumns(allColumns, querySchema.dimensionOnColumns, errorCollector);
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                this.columnItemContainer.addItemComponent(column);
            }
        }
        this.dataModel.setColumnsOnColumns(columns);
        this.columnItemContainer.layoutUI();
        this.valueSelectContainer.removeAllWidgets();
        columns = this.checkColumns(allColumns, querySchema.dimensionOnFilters, errorCollector);
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                this.valueSelectContainer.addWidget(columns[i]);
            }
        }
        this.valueSelectContainer.layoutUI();
        if (querySchema.memberSelectionMap != null) {
            for (Map.Entry<String, List<String>> entry : querySchema.memberSelectionMap.entrySet()) {
                Object[] values = this.toObjectValues(entry.getKey(), entry.getValue(), errorCollector);
                this.dataModel.setSelectedValues(entry.getKey(), values);
                this.valueSelectContainer.setSelectedValues(entry.getKey(), values);
            }
        } else {
            this.dataModel.clearSelectedValues();
        }
        this.cbShowSubTotalOnColumn.setSelected(querySchema.showSubTotalOnColumn);
        this.cbShowSubTotalOnRow.setSelected(querySchema.showSubTotalOnRow);
        this.cbShowTotalOnColumn.setSelected(querySchema.showTotalOnColumn);
        this.cbShowTotalOnRow.setSelected(querySchema.showTotalOnRow);
        this.cbColumnModel.setSelectedIndex(querySchema.columnModel);
        this.cbScale.setSelectedIndex(querySchema.scale);
        this.cbShowSubTotalOnColumn.setEnabled(this.dataModel.columnModel == 0);
        if (errorCollector.size() > 0) {
            Iterator<Map.Entry<String, List<String>>> iter = errorCollector.iterator();
            while (iter.hasNext()) {
                System.out.println((String)((Object)iter.next()));
            }
        }
    }

    private boolean checkCalculatedField(String[] allFields, CalculatedField field, List errorCollector) {
        try {
            Expr expr = ExprParser.parse(field.text);
            MapExecuteContext ctx = new MapExecuteContext();
            for (int i = 0; i < allFields.length; ++i) {
                ctx.putValue(allFields[i], null);
            }
            VerifyVisitor visitor = new VerifyVisitor(ctx);
            expr.accept(visitor);
            List<String> list = visitor.getInvalidSymboList();
            if (list.size() > 0) {
                String message = "\u516c\u5f0f\u9519\u8bef: ";
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        message = message + ",";
                    }
                    message = message + list.get(i);
                }
                errorCollector.add("\u8ba1\u7b97\u5b57\u6bb5" + field.name + message + ",\u5ffd\u7565.");
                return false;
            }
        }
        catch (Exception e) {
            errorCollector.add("\u8ba1\u7b97\u5b57\u6bb5" + field.name + "\u9519\u8bef,\u5ffd\u7565.");
            return false;
        }
        return true;
    }

    private String[] checkColumns(List allColumns, String[] columns, List errorCollector) {
        if (columns == null || columns.length == 0) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        boolean b = true;
        for (int i = 0; i < columns.length; ++i) {
            if (allColumns.contains(columns[i])) {
                ret.add(columns[i]);
                continue;
            }
            b = false;
            errorCollector.add("\u5b57\u6bb5" + columns[i] + "\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565.");
        }
        if (b) {
            return columns;
        }
        return ret.toArray(new String[ret.size()]);
    }

    private Measure[] checkMeasures(List allColumns, Measure[] measures, List errorCollector) {
        if (measures == null || measures.length == 0) {
            return null;
        }
        ArrayList<Measure> ret = new ArrayList<Measure>();
        for (int i = 0; i < measures.length; ++i) {
            if (allColumns.contains(measures[i].name) || this.dataModel.getMetric(measures[i].name) != null) {
                ret.add(measures[i]);
                continue;
            }
            errorCollector.add("\u7edf\u8ba1\u5b57\u6bb5" + measures[i].name + "\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565.");
        }
        return ret.toArray(new Measure[ret.size()]);
    }

    private Object[] toObjectValues(String column, List<String> values, List errorCollector) {
        ColumnValues cv = this.dataModel.getColumnValues(column);
        ArrayList<Object> list = new ArrayList<Object>();
        StringBuffer notExist = new StringBuffer();
        for (String str : values) {
            Object v = cv.lookupByString(str);
            if (v != null) {
                list.add(v);
                continue;
            }
            notExist.append(str + ",");
        }
        if (notExist.length() > 0) {
            errorCollector.add("\u5b57\u6bb5" + column + "\u7684\u4ee5\u4e0b\u503c\u4e0d\u5b58\u5728:" + notExist + ",\u5ffd\u7565.");
        }
        return list.toArray();
    }

    private void initDefaultCondition() {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        String[] measures = this.dataModel.getColumnsCanbeMeasure();
        for (int i2 = 0; i2 < measures.length && i2 < 2; ++i2) {
            list.add(measures[i2]);
            this.metricItemContainer.addItemComponent(measures[i2]);
        }
        list.add("\u884c\u8ba1\u6570");
        this.metricItemContainer.addItemComponent("\u884c\u8ba1\u6570");
        this.metricItemContainer.layoutUI();
        String[] columns = list.toArray(new String[0]);
        int[] argTypes = new int[columns.length];
        for (i = 0; i < argTypes.length; ++i) {
            argTypes[i] = 0;
        }
        this.dataModel.setColumnsOnMeasure(columns, argTypes);
        columns = new String[this.dataModel.getColumnsCanbeDimension().length];
        System.arraycopy(this.dataModel.getColumnsCanbeDimension(), 0, columns, 0, columns.length);
        Arrays.sort(columns, new Comparator(){

            public int compare(Object o1, Object o2) {
                String c1 = (String)o1;
                String c2 = (String)o2;
                int size1 = EASPivotComponent.this.dataModel.getColumnValues(c1).getValues().size();
                int size2 = EASPivotComponent.this.dataModel.getColumnValues(c2).getValues().size();
                if (size1 == 1) {
                    size1 = Integer.MAX_VALUE;
                }
                if (size2 == 1) {
                    size2 = Integer.MAX_VALUE;
                }
                return size1 - size2;
            }
        });
        for (i = 0; i < columns.length && i < 4; ++i) {
            this.valueSelectContainer.addWidget(columns[i]);
        }
        this.valueSelectContainer.layoutUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.table = new KDTable();
        this.table.setAutoscrolls(true);
        this.table.checkParsed();
        Config cc = Config.getConfig();
        cc.showColumnDimensionHeader = false;
        cc.showColumnHeaderInTableHeader = true;
        cc.autoColumnWidth = true;
        cc.autoFreeze = false;
        this.wc = new PivotWorksheetComponent(this.table, cc);
        this.valueSelectContainer = new ValueSelectContainer(this.dataModel);
        ComponentOption option = new ComponentOption();
        option.canBeDropTarget = false;
        option.removeWhenDropOut = false;
        option.location = Location.FIELDLIST;
        option.scroll = true;
        option.vScroll = 20;
        this.allColumnItemContainer = new ColumnItemContainer(this.dataModel, "    \u6240\u6709\u5b57\u6bb5:", option);
        option = new ComponentOption();
        option.backgroundText = "\u5c06\u884c\u5b57\u6bb5\u62d6\u5230\u8fd9\u91cc";
        option.location = Location.ROWLABEL;
        option.hScroll = 30;
        this.rowItemContainer = new ColumnItemContainer(this.dataModel, "\u5206\u7c7b\u884c\u5b57\u6bb5:", option);
        option = new ComponentOption();
        option.backgroundText = "\u5c06\u5217\u5b57\u6bb5\u62d6\u5230\u8fd9\u91cc";
        option.hScroll = 30;
        option.location = Location.COLUMNLABEL;
        this.columnItemContainer = new ColumnItemContainer(this.dataModel, "\u5206\u7c7b\u5217\u5b57\u6bb5:", option);
        option = new ComponentOption();
        option.canBeDropDuplicate = true;
        option.location = Location.METRIC;
        option.hScroll = 30;
        this.metricItemContainer = new ColumnItemContainer(this.dataModel, "    \u7edf\u8ba1\u5b57\u6bb5:", option);
        this.cbShowSubTotalOnRow = new KDCheckBox("\u884c\u5c0f\u8ba1");
        this.cbShowTotalOnRow = new KDCheckBox("\u884c\u5408\u8ba1");
        this.cbShowSubTotalOnColumn = new KDCheckBox("\u5217\u5c0f\u8ba1");
        this.cbShowTotalOnColumn = new KDCheckBox("\u5217\u5408\u8ba1");
        this.cbShowChart = new KDCheckBox("\u663e\u793a\u56fe\u8868");
        this.cbShowChart.setToolTipText("\u4e0d\u652f\u6301\u591a\u4e2a\u5206\u7c7b\u884c\u548c\u5206\u7c7b\u5217\u5b57\u6bb5\uff0c\u4e0d\u652f\u6301\u5c0f\u8ba1");
        this.cbColumnModel = new KDComboBox(new Object[]{"\u4ea4\u53c9", "\u5e76\u5217"});
        this.cbColumnModel.setSize(40, 20);
        this.cbColumnModel.setPreferredSize(new java.awt.Dimension(60, 20));
        this.cbColumnModel.setSelectedIndex(0);
        this.cbColumnModel.setOpaque(true);
        this.cbScale = new KDComboBox(new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
        this.cbScale.setSize(40, 20);
        this.cbScale.setPreferredSize(new java.awt.Dimension(60, 20));
        this.cbScale.setSelectedIndex(2);
        this.cbScale.setOpaque(true);
        this.cbShowTotalOnRow.setSelected(true);
        this.dataModel.showTotalOnRow = true;
        this.cbShowChart.setSelected(false);
        this.showChart = this.cbShowChart.isSelected();
        JPanel optionPanel = new JPanel();
        this.tablePanel = new KDPanel();
        this.tablePanel.setLayout((LayoutManager)new BorderLayout());
        this.tablePanel.add((Component)this.table, (Object)"Center");
        this.overflowPanel = new KDPanel();
        this.tablePanel.add((Component)this.overflowPanel, (Object)"North");
        optionPanel.setLayout(new FlowLayout(2));
        optionPanel.add((Component)this.cbShowSubTotalOnRow);
        optionPanel.add((Component)this.cbShowTotalOnRow);
        optionPanel.add((Component)this.cbShowSubTotalOnColumn);
        optionPanel.add((Component)this.cbShowTotalOnColumn);
        optionPanel.add((Component)this.cbShowChart);
        KDLabelContainer lc = new KDLabelContainer("\u5217\u6a21\u5f0f:", (JComponent)this.cbColumnModel);
        String toolTip = "\u8bd5\u8bd5\u62d6\u4e24\u4e2a\u4ee5\u4e0a\u5b57\u6bb5\u5230\u5217\u533a\uff0c\u770b\u770b\u6709\u4ec0\u4e48\u4e0d\u540c\u3002\u591a\u4e2a\u5b57\u6bb5\u53ef\u4ea4\u53c9\u6216\u5e76\u5217\u663e\u793a\u3002";
        lc.getBoundLabel().setToolTipText(toolTip);
        this.cbColumnModel.setToolTipText(toolTip);
        lc.setMaximumSize(new java.awt.Dimension(40, 20));
        optionPanel.add((Component)lc);
        lc = new KDLabelContainer("\u5c0f\u6570\u7cbe\u5ea6:", (JComponent)this.cbScale);
        toolTip = "\u5c0f\u6570\u70b9\u4f4d\u6570\u7cbe\u5ea6\uff0c\u9ed8\u8ba4\u4e3a2\u4f4d\u3002";
        lc.getBoundLabel().setToolTipText(toolTip);
        this.cbScale.setToolTipText(toolTip);
        lc.setMaximumSize(new java.awt.Dimension(40, 20));
        optionPanel.add((Component)lc);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        int index = 0;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = index++;
        gc.gridx = 0;
        gc.weighty = 1.0;
        gc.insets = new Insets(1, 0, 1, 0);
        gc.fill = 1;
        gc.anchor = 18;
        panel1.add((Component)this.allColumnItemContainer, gc);
        gc = new GridBagConstraints();
        gc.gridy = index++;
        gc.gridx = 0;
        gc.insets = new Insets(1, 0, 1, 1);
        gc.fill = 1;
        gc.anchor = 18;
        panel1.add((Component)this.rowItemContainer, gc);
        gc = new GridBagConstraints();
        gc.gridy = index++;
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(1, 0, 1, 1);
        gc.fill = 1;
        gc.anchor = 18;
        panel1.add((Component)this.columnItemContainer, gc);
        gc = new GridBagConstraints();
        gc.gridy = index++;
        gc.gridx = 0;
        gc.insets = new Insets(1, 1, 1, 0);
        gc.fill = 1;
        gc.anchor = 18;
        panel1.add((Component)this.metricItemContainer, gc);
        panel1.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.valueSelectContainer.addToTopPanel(optionPanel, "East");
        KDSplitPane contentSplitPane = new KDSplitPane(0, (Component)this.valueSelectContainer, (Component)this.tablePanel);
        contentSplitPane.setDividerLocation(0.3);
        contentSplitPane.setResizeWeight(0.3);
        contentSplitPane.setDividerSize(5);
        this.splitPane = new KDSplitPane(0, (Component)panel1, (Component)contentSplitPane);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setDividerSize(5);
        this.add((Component)this.splitPane, "Center");
        this.toolBar = new KDToolBar();
        this.toolBar.setEnabled(true);
        this.toolBar.setRequestFocusEnabled(true);
        this.toolBar.setToolTipText("");
        this.toolBar.setBorderPainted(true);
        this.toolBar.setTextIconDisStyle((short)3);
        this.initToolBar();
        this.add((Component)this.toolBar, "North");
        this.clearTable();
    }

    private void checkTopSize() {
    }

    private void initToolBar() {
        KDWorkButton btn = new KDWorkButton();
        if (this.storage != null) {
            btn = new KDWorkButton();
            btn.setText("\u4fdd\u5b58\u65b9\u6848");
            btn.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EASPivotComponent.this.actionSaveSchema(EASPivotComponent.this.storage, "\u4fdd\u5b58");
                }
            });
            this.toolBar.add((Component)btn, null);
            btn = new KDWorkButton();
            btn.setText("\u6253\u5f00\u65b9\u6848");
            btn.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EASPivotComponent.this.actionOpenSchema(EASPivotComponent.this.storage, "\u6253\u5f00");
                }
            });
            this.toolBar.add((Component)btn, null);
        }
        if (this.localStorage != null) {
            btn = new KDWorkButton();
            btn.setText("\u5bfc\u51fa\u65b9\u6848");
            btn.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EASPivotComponent.this.actionSaveSchema(EASPivotComponent.this.localStorage, "\u5bfc\u51fa");
                }
            });
            this.toolBar.add((Component)btn, null);
            btn = new KDWorkButton();
            btn.setText("\u5bfc\u5165\u65b9\u6848");
            btn.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EASPivotComponent.this.actionOpenSchema(EASPivotComponent.this.localStorage, "\u5bfc\u5165");
                }
            });
            this.toolBar.add((Component)btn, null);
        }
        btn = new KDWorkButton();
        btn.setText("\u65b0\u5efa\u8ba1\u7b97\u5b57\u6bb5");
        btn.setIcon(EASResource.getIcon((String)"imgTbtn_addcourse"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EASPivotComponent.this.showCalculatedFieldDialog();
            }
        });
        this.toolBar.add((Component)btn, null);
        btn = new KDWorkButton();
        btn.setText("\u5bfc\u51faExcel");
        btn.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        KDPopupMenu popMenu = new KDPopupMenu();
        btn.setAssistPopup(popMenu);
        this.item = new KDCheckBoxMenuItem();
        this.item.setText("\u4fdd\u5b58\u5408\u5e76\u884c\u72b6\u6001");
        this.item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EASPivotComponent.this.wc.setMergerBolocks(EASPivotComponent.this.item.isSelected());
            }
        });
        popMenu.add((JMenuItem)this.item);
        KDMenuItem menuItem = new KDMenuItem();
        popMenu.add((JMenuItem)menuItem);
        menuItem.setText("\u5bfc\u51fa");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EASPivotComponent.this.wc.export2Excel(EASPivotComponent.this.item.isSelected());
            }
        });
        this.toolBar.add((Component)btn, null);
        btn = new KDWorkButton();
        btn.setText("\u663e\u793a\u660e\u7ec6");
        btn.setIcon(EASResource.getIcon((String)"imgTbtn_listfile"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EASPivotComponent.this.actionShowDetail();
            }
        });
        this.toolBar.add((Component)btn, null);
        btn = new KDWorkButton();
        btn.setText("\u5355\u636e\u8bbe\u7f6e");
        btn.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EASPivotComponent.this.actionBillConfig();
            }
        });
        this.toolBar.add((Component)btn, null);
        btn = new KDWorkButton();
        btn.setText("\u6253\u5f00Excel");
        btn.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
        btn.setToolTipText("\u6253\u5f00\u5916\u90e8Excel\u6587\u4ef6\u8fdb\u884c\u5206\u6790");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EASPivotComponent.this.openExcel();
            }
        });
        this.toolBar.add((Component)btn, null);
        this.toolBar.add((Component)new KDSeparator());
        btn = new KDWorkButton();
        btn.setText("\u8054\u7cfb\u6211\u4eec");
        btn.setIcon(EASResource.getIcon((String)"imgTbtn_contactus"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EASPivotComponent.this.about();
            }
        });
        this.toolBar.add((Component)btn, null);
        btn = new KDWorkButton();
        btn.setText("\u9000\u51fa");
        btn.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EASPivotComponent.this.exit();
            }
        });
        this.toolBar.add((Component)btn, null);
        this.btnAddMetric = new KDButton("+\u6307\u6807");
        this.btnAddMetric.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EASPivotComponent.this.metricItemContainer.showMetricDialog();
            }
        });
        this.metricItemContainer.addOtherComponent((JComponent)this.btnAddMetric);
    }

    private void about() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(PivotUtils.getParentFrame((JComponent)((Object)this)));
        }
        this.aboutDialog.setVisible(true);
    }

    protected void actionOpenSchema(IQuerySchemaStorage storage, String actionName) {
        try {
            IQuerySchemaStorage.Result result = storage.open(this.uiDesc);
            if (result == null) {
                return;
            }
            if (!result.success) {
                if (result.message != null) {
                    String message = actionName + "\u5931\u8d25" + result.message;
                    KDOptionPane.showMessageDialog((Component)((Object)this), (Object)message);
                }
                return;
            }
            String xml = result.xml;
            QuerySchema querySchema = new QuerySchema();
            querySchema.fromXML(xml);
            this.applyQuerySchema(querySchema);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void actionSaveSchema(IQuerySchemaStorage storage, String actionName) {
        QuerySchema querySchema = this.newQuerySchema();
        if (querySchema == null) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u754c\u9762\u4e0a\u6ca1\u6709\u5e03\u5c40\u5b57\u6bb5\uff0c\u65e0\u6cd5" + actionName + "."));
            return;
        }
        String xml = querySchema.toXML();
        try {
            IQuerySchemaStorage.Result result = storage.save(this.uiDesc, xml);
            if (result == null) {
                return;
            }
            if (result.message != null) {
                String message = actionName + (result.success ? "\u6210\u529f," : "\u5931\u8d25") + result.message;
                KDOptionPane.showMessageDialog((Component)((Object)this), (Object)message);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openExcel() {
        File f;
        if (this.chooser == null) {
            this.chooser = new FileChooserUtil(PivotUtils.getMainFrame());
        }
        if ((f = this.chooser.openFile("\u6253\u5f00Excel\u6587\u4ef6\u8fdb\u884c\u5206\u6790(\u7b2c\u4e00\u884c\u4e3a\u8868\u5934\u5b57\u6bb5)", "xls,xlsx", "Excel\u683c\u5f0f\u6587\u4ef6(xls|xlsx)")) == null) {
            return;
        }
        DataSource dataSource = null;
        try {
            dataSource = this.createExcelDataSource(f.getAbsolutePath());
            EASPivotFrame frame = new EASPivotFrame(dataSource);
            frame.setVisible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)this), "\u65e0\u6cd5\u6253\u5f00Excel\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
    }

    private DataSource createExcelDataSource(String absolutePath) {
        try {
            POIReader rs = new POIReader(absolutePath);
            DataSource dataSource = DataSourceBuilder.buildPagedDataSource(rs, true, 5000, true, 60000000);
            dataSource.setProperty("title", "EAS\u9ad8\u7ea7\u7edf\u8ba1-" + absolutePath);
            DataSource dataSource2 = dataSource;
            return dataSource2;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PivotException(e);
        }
    }

    private void actionShowDetail() {
        if (!this.wc.showDetail(false)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "\u8bf7\u5148\u9009\u4e2d\u884c,\u60a8\u4e5f\u53ef\u4ee5\u76f4\u63a5\u53cc\u51fb\u5355\u5143\u683c\u4ee5\u67e5\u770b\u660e\u7ec6.");
        }
    }

    private void exit() {
        JFrame frame = this.getParentFrame();
        if (frame != null) {
            frame.dispose();
        }
    }

    private void showCalculatedFieldDialog() {
        boolean changed = this.allColumnItemContainer.showCalculatedFieldDialog();
        if (changed) {
            this.updateUI();
            this.checkTopSize();
        }
    }

    private void actionBillConfig() {
        BillConfigDialog dialog = new BillConfigDialog(PivotUtils.getParentFrame((JComponent)((Object)this)));
        dialog.setDataSource(this.dataModel.getDataSource());
        dialog.setVisible(true);
        if (dialog.isOk()) {
            this.modelChangedImpl(true);
        }
    }

    private JFrame getParentFrame() {
        Window window = null;
        window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window == null) {
            return null;
        }
        Container parent = window;
        do {
            if (!(parent instanceof JFrame)) continue;
            return (JFrame)parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    private void initListener() {
        this.cbShowSubTotalOnRow.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (EASPivotComponent.this.dataModel.showSubTotalOnRow != EASPivotComponent.this.cbShowSubTotalOnRow.isSelected()) {
                    EASPivotComponent.this.dataModel.showSubTotalOnRow = EASPivotComponent.this.cbShowSubTotalOnRow.isSelected();
                    EASPivotComponent.this.dataModel.modelChanged(false);
                }
            }
        });
        this.cbShowTotalOnRow.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (EASPivotComponent.this.dataModel.showTotalOnRow != EASPivotComponent.this.cbShowTotalOnRow.isSelected()) {
                    EASPivotComponent.this.dataModel.showTotalOnRow = EASPivotComponent.this.cbShowTotalOnRow.isSelected();
                    EASPivotComponent.this.dataModel.modelChanged(false);
                }
            }
        });
        this.cbShowSubTotalOnColumn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (EASPivotComponent.this.dataModel.showSubTotalOnColumn != EASPivotComponent.this.cbShowSubTotalOnColumn.isSelected()) {
                    EASPivotComponent.this.dataModel.showSubTotalOnColumn = EASPivotComponent.this.cbShowSubTotalOnColumn.isSelected();
                    EASPivotComponent.this.dataModel.modelChanged(false);
                }
            }
        });
        this.cbShowTotalOnColumn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (EASPivotComponent.this.dataModel.showTotalOnColumn != EASPivotComponent.this.cbShowTotalOnColumn.isSelected()) {
                    EASPivotComponent.this.dataModel.showTotalOnColumn = EASPivotComponent.this.cbShowTotalOnColumn.isSelected();
                    EASPivotComponent.this.dataModel.modelChanged(false);
                }
            }
        });
        this.cbColumnModel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (EASPivotComponent.this.dataModel.columnModel != EASPivotComponent.this.cbColumnModel.getSelectedIndex()) {
                    EASPivotComponent.this.dataModel.columnModel = EASPivotComponent.this.cbColumnModel.getSelectedIndex();
                    EASPivotComponent.this.dataModel.modelChanged(true);
                }
                EASPivotComponent.this.table.requestFocus(true);
                EASPivotComponent.this.cbShowSubTotalOnColumn.setEnabled(EASPivotComponent.this.dataModel.columnModel == 0);
            }
        });
        this.cbScale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (EASPivotComponent.this.dataModel.scale != EASPivotComponent.this.cbScale.getSelectedIndex()) {
                    EASPivotComponent.this.dataModel.scale = EASPivotComponent.this.cbScale.getSelectedIndex();
                    EASPivotComponent.this.dataModel.modelChanged(true);
                }
                EASPivotComponent.this.table.requestFocus(true);
            }
        });
        this.rowItemContainer.setConditionChangeCallback(new ConditionChangeCallback(){

            @Override
            public void callback() {
                EASPivotComponent.this.dataModel.setColumnsOnRows(EASPivotComponent.this.rowItemContainer.getColumns());
                EASPivotComponent.this.changeUIStyleWhenConditionChanged();
            }
        });
        this.columnItemContainer.setConditionChangeCallback(new ConditionChangeCallback(){

            @Override
            public void callback() {
                EASPivotComponent.this.dataModel.setColumnsOnColumns(EASPivotComponent.this.columnItemContainer.getColumns());
                EASPivotComponent.this.changeUIStyleWhenConditionChanged();
            }
        });
        this.metricItemContainer.setConditionChangeCallback(new ConditionChangeCallback(){

            @Override
            public void callback() {
                EASPivotComponent.this.dataModel.setColumnsOnMeasure(EASPivotComponent.this.metricItemContainer.getColumns(), EASPivotComponent.this.metricItemContainer.getAggTypes());
                EASPivotComponent.this.changeUIStyleWhenConditionChanged();
            }
        });
        this.allColumnItemContainer.setConditionChangeCallback(new ConditionChangeCallback(){

            @Override
            public void callback() {
                EASPivotComponent.this.dataModel.modelChanged(true);
            }
        });
        this.allColumnItemContainer.setRemoveCalculatedItemCallback(new RemoveCalculatedItemCallback(){

            @Override
            public void itemRemoved(String[] fields) {
                EASPivotComponent.this.calculatedItemsRemoved(fields);
            }
        });
        new PanelDropTarget((JComponent)this.tablePanel, new PanelDropTarget.DropCallBack(){

            @Override
            public boolean drop(ColumnItem item, Point location) {
                return EASPivotComponent.this.dropInTable(item);
            }
        });
        this.dataModel.addListener(new DataModelListener(){

            @Override
            public void changed(boolean needbuildData) {
                EASPivotComponent.this.modelChangedImpl(needbuildData);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (EASPivotComponent.this.valueSelectContainer != null) {
                    EASPivotComponent.this.valueSelectContainer.doResizeComponent();
                    EASPivotComponent.this.valueSelectContainer.layoutUI();
                }
                EASPivotComponent.this.checkTopSize();
            }
        });
        this.cbShowChart.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EASPivotComponent.this.showChartChanged(EASPivotComponent.this.cbShowChart.isSelected());
            }
        });
        this.table.addKDTMouseListener(this.mouseListener);
        this.table.addKDTSelectListener(this.selectListener);
        this.wc.setDetailListListener(this.detailListener);
        this.installDebug();
    }

    public void showChartChanged(boolean show) {
        if (this.showChart == show) {
            return;
        }
        this.showChart = show;
        if (show) {
            this.showChart();
        } else if (this.chartFrame != null) {
            this.chartFrame.setVisible(false);
        }
    }

    public void showChart() {
        KDTSelectBlock block = this.table.getSelectManager().get();
        if (block == null) {
            this.showChart(0, 0, this.table.getRowCount() - 1, this.table.getColumnCount() - 1);
        } else {
            int left = block.getLeft();
            int top = block.getTop();
            int right = block.getRight();
            int bottom = block.getBottom();
            this.showChart(top, left, bottom, right);
        }
    }

    public void showChart(int top, int left, int bottom, int right) {
        if (!this.cbShowChart.isSelected()) {
            return;
        }
        if (this.queryModel.dimensionsOnRow.length == 0) {
            bottom = 0;
            left = 1;
        }
        String message = null;
        if (this.queryModel.dimensionsOnRow.length > 1) {
            message = "\u4eb2\uff0c\u8d85\u8fc71\u4e2a\u884c\u5b57\u6bb5\uff0c\u65e0\u6cd5\u663e\u793a\u54e6";
        } else if (this.queryModel.dimensionsOnColumn.length > 1) {
            message = "\u4eb2\uff0c\u8d85\u8fc71\u4e2a\u5217\u5b57\u6bb5\uff0c\u65e0\u6cd5\u663e\u793a\u54e6";
        } else if (this.queryModel.dimensionsOnColumn.length == 1 && this.queryModel.measures.length > 1) {
            message = "\u4eb2\uff0c2\u884c\u8868\u5934\uff0c\u65e0\u6cd5\u663e\u793a\u54e6\uff0c\u60a8\u53ef\u4ee5\u53ea\u8bbe1\u4e2a\u7edf\u8ba1\u5b57\u6bb5";
        }
        if (message != null) {
            ChartFrame chartFrame = this.getChartFrame();
            chartFrame.setMessage(message);
            chartFrame.setVisible(true);
            return;
        }
        if (left == 0 && this.queryModel.dimensionsOnRow.length > 0) {
            left = this.queryModel.dimensionsOnRow.length;
        }
        if (this.queryModel.showTotalOnRow && bottom == this.table.getRowCount() - 1 && bottom > top) {
            --bottom;
        }
        if (this.queryModel.showTotalOnColumn && this.queryModel.dimensionsOnColumn.length > 0 && right == this.table.getColumnCount() - 1 && right > left) {
            --right;
        }
        int rowCount = bottom - top + 1;
        int columnCount = right - left + 1;
        String[] groupKeys = new String[rowCount];
        String[] serialKeys = new String[columnCount];
        double[][] values = new double[columnCount][rowCount];
        int index = 0;
        for (int i = left; i <= right; ++i) {
            Object value = this.table.getHead().getRow(0).getCell(i).getValue();
            serialKeys[index++] = value.toString();
        }
        int rowIndex = 0;
        int i = top;
        while (i <= bottom) {
            groupKeys[rowIndex] = this.table.getCell(i, 0).getValue().toString();
            int columnIndex = 0;
            int j = left;
            while (j <= right) {
                Object value = this.table.getCell(i, j).getValue();
                PivotDataCellItem cellItem = (PivotDataCellItem)value;
                if ((value = cellItem.getValue()) != null && value instanceof Number) {
                    values[columnIndex][rowIndex] = ((Number)value).doubleValue();
                }
                ++j;
                ++columnIndex;
            }
            ++i;
            ++rowIndex;
        }
        ChartFrame chartFrame = this.getChartFrame();
        chartFrame.setChartData((Comparable[])groupKeys, (Comparable[])serialKeys, values);
        chartFrame.setVisible(true);
    }

    private ChartFrame getChartFrame() {
        if (this.chartFrame == null) {
            this.chartFrame = new ChartFrame();
            this.chartFrame.setTitle("\u56fe\u8868:" + this.uiDesc.title);
            PivotUtils.makeCenter((Window)((Object)this.chartFrame));
        }
        return this.chartFrame;
    }

    private void showDetail(Map memberContext) {
        ArrayList<Object> values;
        QueryModel queryModel = this.dataModel.getQueryModel();
        MemberSelection[] selections = queryModel.memberSelections;
        HashMap map2 = new HashMap();
        Iterator iter = memberContext.entrySet().iterator();
        while (iter.hasNext()) {
            values = new ArrayList<Object>(1);
            Map.Entry entry = iter.next();
            values.add(entry.getValue());
            map2.put(entry.getKey(), values);
        }
        if (selections != null) {
            for (int i = 0; i < selections.length; ++i) {
                if (map2.containsKey(selections[i].dimension.name)) continue;
                values = new ArrayList();
                Iterator<Member> iter2 = selections[i].getMemberList().iterator();
                while (iter2.hasNext()) {
                    values.add(iter2.next().value);
                }
                if (values.isEmpty()) continue;
                map2.put(selections[i].dimension.name, values);
            }
        }
        DetailListUI ui = new DetailListUI(this.dataSource, this.queryModel);
        ui.setMemberContext(map2);
        ui.refreshUI();
        JFrame frame = PivotUtils.getMainFrame();
        KDDialog dialog = new KDDialog((Frame)frame);
        dialog.setLayout((LayoutManager)new BorderLayout());
        dialog.add((Component)ui);
        dialog.setTitle("\u660e\u7ec6\u884c\u4fe1\u606f");
        int width = frame.getWidth() - 100;
        int height = frame.getHeight() - 100;
        dialog.setBounds(0, 0, width, height);
        dialog.setSize(new java.awt.Dimension(width, height));
        PivotUtils.makeCenter((Window)dialog);
        dialog.setVisible(true);
    }

    void cellClicked(KDTable table, boolean doubleClick, int row, int column, Component parent, int x, int y, boolean header) {
        ICell cell;
        if (header && (cell = table.getHeadRow(row).getCell(column)).getValue() instanceof PivotMemberCellItem) {
            PivotMemberCellItem cellItem = (PivotMemberCellItem)cell.getValue();
            if (cellItem.getMember().isMeasure()) {
                this.orderColumn(cellItem.getMember());
            } else {
                this.orderColumn(null);
            }
        }
    }

    private void orderColumn(com.kingdee.bos.streamwork.cuba.Member measure) {
        if (measure == null) {
            this.orderMeasure = null;
            this.orderDesc = false;
        } else if (measure.equals(this.orderMeasure)) {
            if (this.orderDesc) {
                this.orderMeasure = null;
                this.orderDesc = false;
            } else {
                this.orderDesc = true;
            }
        } else {
            this.orderMeasure = measure;
            this.orderDesc = false;
        }
        if (this.mdxResult != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean buildOrder = EASPivotComponent.this.buildOrderMdxResult();
                    EASPivotComponent.this.renderTable(buildOrder);
                }
            });
        } else {
            this.modelChangedImpl(false);
        }
    }

    protected void calculatedItemsRemoved(String[] fields) {
        this.rowItemContainer.removeItemComponent(fields);
        this.columnItemContainer.removeItemComponent(fields);
        this.metricItemContainer.removeItemComponent(fields);
        this.checkTopSize();
    }

    private void installDebug() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EASPivotComponent.this.openDebug();
            }
        };
        this.setKeyStroke(action, KeyStroke.getKeyStroke(72, 10), "Pivot Debug");
    }

    private void setKeyStroke(AbstractAction action, KeyStroke ks, String key) {
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        if (inputMap == null || actionMap == null) {
            return;
        }
        inputMap.put(ks, key);
        actionMap.remove(inputMap.get(ks));
        actionMap.put(inputMap.get(ks), action);
    }

    private void openDebug() {
        System.out.println("EAS Pivot DataSource row count = " + this.dataSource.getRowCount() + " , Sql: \n" + this.dataSource.getProperty("sql"));
        Object parent = this;
        while (((Component)parent).getParent() != null && !((parent = ((Component)parent).getParent()) instanceof KDFrame)) {
        }
        DebugDialog dialog = new DebugDialog((KDFrame)parent);
        dialog.setValues(this.dataSource.getRowCount(), (String)this.dataSource.getProperty("sql"));
        dialog.setVisible(true);
    }

    protected void changeUIStyleWhenConditionChanged() {
    }

    private void initAllColumns() {
        this.allColumnItemContainer.removeAllComponents();
        String[] columns = this.dataModel.getAllColumns();
        for (int i = 0; i < columns.length; ++i) {
            boolean isCalculated;
            boolean bl = isCalculated = this.dataSource.getCalculatedField(columns[i]) != null;
            if (isCalculated) {
                this.allColumnItemContainer.addCalculatedColumn(columns[i], isCalculated);
                continue;
            }
            this.allColumnItemContainer.addItemComponent(columns[i], isCalculated);
        }
        this.allColumnItemContainer.layoutUI();
    }

    public void validateTree() {
        int beforeHeight = -1;
        int afterHeight = -1;
        try {
            beforeHeight = this.allColumnItemContainer.getInnerHeight();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        super.validateTree();
        try {
            afterHeight = this.allColumnItemContainer.getInnerHeight();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        if (afterHeight > 0) {
            this.splitPane.setDividerLocation(afterHeight + 120);
        }
    }

    protected boolean dropInTable(ColumnItem item) {
        return true;
    }

    private void clearTable() {
        int i;
        this.table.removeColumns();
        this.table.removeRows();
        IRow headRow = this.table.addHeadRow();
        for (i = 0; i < 10; ++i) {
            IColumn col = this.table.addColumn();
            col.setKey("F" + i);
            headRow.getCell(i).setValue((Object)new Character((char)(65 + i)));
        }
        for (i = 0; i < 25; ++i) {
            this.table.addRow();
        }
        this.table.setEditable(false);
    }

    protected void modelChangedImpl(final boolean needbuildData) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    EASPivotComponent.this.setCursor(Cursor.getPredefinedCursor(3));
                    EASPivotComponent.this.doConditionChanged(needbuildData);
                    EASPivotComponent.this.showChart();
                }
                finally {
                    EASPivotComponent.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    protected void doConditionChanged(boolean needBuildData) {
        logger.setLevel(Level.DEBUG);
        long start = System.currentTimeMillis();
        this.queryModel = this.dataModel.getQueryModel();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doConditionChanged dataModel.getQueryModel cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        if (this.queryModel == null) {
            this.clearTable();
            this.updateUI();
            return;
        }
        start = System.currentTimeMillis();
        this.executor = ExecutorFactory.createExecutorForExcelPivot();
        try {
            this.resultModel = this.executor.execute(this.dataSource, this.queryModel);
        }
        catch (DataSourceTimeoutException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "\u67e5\u8be2\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u67e5\u8be2\u3002", "\u63d0\u793a", 1);
            return;
        }
        this.mdxResult = this.resultModel.getResult();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doConditionChanged executor.execute cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        boolean buildOrder = false;
        if (this.orderMeasure != null) {
            boolean found = false;
            Measure[] measures = this.dataModel.getMeasures();
            for (int i = 0; i < this.dataModel.getMeasures().length; ++i) {
                if (!measures[i].name.equals(this.orderMeasure.getName())) continue;
                found = true;
                break;
            }
            if (found && this.mdxResult.getOverflowInfo() == null) {
                buildOrder = this.buildOrderMdxResult();
            } else {
                this.orderMeasure = null;
            }
        }
        this.renderTable(buildOrder);
    }

    private boolean buildOrderMdxResult() {
        if (this.orderMeasure != null && this.dataModel.getColumnsOnRows().length > 0 && this.dataModel.getColumnsOnColumns().length == 0 && this.dataModel.getColumnsOnMeasure().length > 0) {
            if (this.mdxResult instanceof OrderedMdxResult) {
                MdxResult inner = ((OrderedMdxResult)this.mdxResult).getInner();
                this.mdxResult = new OrderedMdxResult(inner, this.orderMeasure, this.orderDesc);
            } else {
                this.mdxResult = new OrderedMdxResult(this.mdxResult, this.orderMeasure, this.orderDesc);
            }
            return true;
        }
        if (this.mdxResult instanceof OrderedMdxResult) {
            this.mdxResult = ((OrderedMdxResult)this.mdxResult).getInner();
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTable(boolean buildOrder) {
        long start = System.currentTimeMillis();
        boolean refresh = this.table.isRefresh();
        try {
            this.showOverflowInfo();
            this.table.setRefresh(false);
            this.wc.render(this.mdxResult);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doConditionChanged render cost " + (System.currentTimeMillis() - start) + "ms."));
            }
            this.mergeCell();
            this.setTableColor();
            int columnInset = 0;
            if (buildOrder) {
                IRow row = this.table.getHeadRow(0);
                int index = this.dataModel.getColumnsOnRows().length;
                for (int i = 0; i < this.dataModel.getColumnsOnMeasure().length; ++i) {
                    ICell cell;
                    PivotMemberCellItem cellItem;
                    com.kingdee.bos.streamwork.cuba.Member m;
                    boolean eq;
                    boolean bl = eq = (m = (cellItem = (PivotMemberCellItem)(cell = row.getCell(columnInset + index++)).getValue()).getMember()).getProperty("column") == null && this.orderMeasure.getProperty("column") == null || m.getProperty("column") != null && m.getProperty("column").equals(this.orderMeasure.getProperty("column"));
                    if (eq) {
                        boolean bl2 = eq = m.getProperty("aggregator") == null && this.orderMeasure.getProperty("aggregator") == null || m.getProperty("aggregator") != null && m.getProperty("aggregator").equals(this.orderMeasure.getProperty("aggregator"));
                    }
                    if (eq) {
                        cellItem.setCaptionMemo(this.orderDesc ? "\u2193" : "\u2191");
                        continue;
                    }
                    cellItem.setCaptionMemo(null);
                }
            }
        }
        finally {
            this.table.setRefresh(refresh);
            this.table.updateUI();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doConditionChanged render and updateUI cost " + (System.currentTimeMillis() - start) + "ms."));
            }
        }
    }

    private void setTableColor() {
        if (this.queryModel.measures.length == 0) {
            return;
        }
        if (this.queryModel.dimensionsOnRow.length == 0) {
            return;
        }
        if (!this.queryModel.showTotalOnRow) {
            return;
        }
        if (this.table.getRowCount() < 2) {
            return;
        }
        boolean showTotal = this.queryModel.showTotalOnRow;
        if (showTotal && this.mdxResult.getOverflowInfo() != null) {
            boolean bl = showTotal = this.mdxResult.getOverflowInfo().originRowCount == this.mdxResult.getOverflowInfo().cutRowCount;
        }
        if (showTotal) {
            Color color = Color.LIGHT_GRAY;
            IRow row = this.table.getRow(this.table.getRowCount() - 1);
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                ICell cell = row.getCell(i);
                if (cell.getValue() instanceof PivotMemberCellItem) {
                    ((PivotMemberCellItem)cell.getValue()).setBgColor(color);
                } else if (cell.getValue() instanceof PivotDataCellItem) {
                    ((PivotDataCellItem)cell.getValue()).setBgColor(color);
                }
                cell.getStyleAttributes().setBackground(color);
            }
        }
    }

    private void mergeCell() {
        if (this.queryModel.measures.length == 0) {
            return;
        }
        if (this.table.getRowCount() < 1) {
            return;
        }
        int count = this.queryModel.dimensionsOnRow.length;
        int columnCount = this.table.getColumnCount();
        Color color1 = new Color(225, 225, 225);
        block0: for (int rowIndex = 0; rowIndex < this.table.getRowCount() - 1; ++rowIndex) {
            IRow row = this.table.getRow(rowIndex);
            boolean hasTotal = false;
            for (int i = 0; i < count; ++i) {
                PivotMemberCellItem cellItem;
                ICell cell = row.getCell(i);
                if (!(cell.getValue() instanceof PivotMemberCellItem) || !(cellItem = (PivotMemberCellItem)cell.getValue()).getMember().isCalculated()) continue;
                hasTotal = true;
                if (i < count - 1) {
                    this.table.getMergeManager().mergeBlock(rowIndex, i, rowIndex, count - 1);
                    this.table.getCell(rowIndex, i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                }
                cellItem.setBgColor(color1);
                cell.getStyleAttributes().setBackground(color1);
                continue block0;
            }
        }
        boolean showTotal = this.queryModel.showTotalOnRow;
        if (showTotal && this.mdxResult.getOverflowInfo() != null) {
            boolean bl = showTotal = this.mdxResult.getOverflowInfo().originRowCount == this.mdxResult.getOverflowInfo().cutRowCount;
        }
        if (showTotal) {
            int rowIndex = this.table.getRowCount() - 1;
            this.table.getMergeManager().mergeBlock(rowIndex, 0, rowIndex, count - 1);
            this.table.getCell(rowIndex, 0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        }
    }

    public void showOverflowInfo() {
        this.overflowPanel.removeAll();
        if (this.mdxResult.getOverflowInfo() != null) {
            ResultOverflowInfo info = this.mdxResult.getOverflowInfo();
            String text = "\u67e5\u8be2\u7ed3\u679c\u592a\u5927,\u65e0\u6cd5\u5168\u90e8\u663e\u793a,\u8bf7\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4,\u5171" + info.originRowCount + "\u884c,";
            if (info.originColumnCount > 0) {
                text = text + info.originColumnCount + "\u5217,";
            }
            text = text + "\u53ea\u663e\u793a" + (info.cutRowCount > 0 ? info.cutRowCount : info.originRowCount) + "\u884c,";
            if (info.originColumnCount > 0) {
                text = text + (info.cutColumnCount > 0 ? info.cutColumnCount : info.originColumnCount) + "\u5217,";
            }
            text = text + "\u4e0d\u6392\u5e8f";
            this.overflowPanel.setLayout((LayoutManager)new FlowLayout(3));
            KDLabel label = new KDLabel();
            this.overflowPanel.add((Component)label);
            label.setForeground(Color.RED);
            label.setText(text);
        }
    }

    public QuerySchema newQuerySchema() {
        QueryModel queryModel = this.dataModel.getQueryModel();
        if (queryModel == null) {
            return null;
        }
        QuerySchema querySchema = new QuerySchema();
        querySchema.showSubTotalOnColumn = queryModel.showSubTotalOnColumn;
        querySchema.showSubTotalOnRow = queryModel.showSubTotalOnRow;
        querySchema.showTotalOnColumn = queryModel.showTotalOnColumn;
        querySchema.showTotalOnRow = queryModel.showTotalOnRow;
        querySchema.columnModel = queryModel.columnModel;
        querySchema.scale = queryModel.scale;
        if (queryModel.dimensionsOnRow != null && queryModel.dimensionsOnRow.length > 0) {
            querySchema.dimensionOnRows = new String[queryModel.dimensionsOnRow.length];
            this.copyNames(queryModel.dimensionsOnRow, querySchema.dimensionOnRows);
        }
        if (queryModel.dimensionsOnColumn != null && queryModel.dimensionsOnColumn.length > 0) {
            querySchema.dimensionOnColumns = new String[queryModel.dimensionsOnColumn.length];
            this.copyNames(queryModel.dimensionsOnColumn, querySchema.dimensionOnColumns);
        }
        querySchema.measures = queryModel.measures;
        if (queryModel.memberSelections != null) {
            querySchema.memberSelectionMap = new HashMap<String, List<String>>();
            for (int i = 0; i < queryModel.memberSelections.length; ++i) {
                MemberSelection ms = queryModel.memberSelections[i];
                String dim = ms.dimension.name;
                ArrayList<String> values = new ArrayList<String>();
                for (Member m : ms.getMemberList()) {
                    values.add(m.name);
                }
                querySchema.memberSelectionMap.put(dim, values);
            }
        }
        querySchema.dimensionOnFilters = this.valueSelectContainer.getColumns();
        List<CalculatedField> calculatedFields = this.dataSource.getAllCalculatedFields();
        if (calculatedFields != null && calculatedFields.size() > 0) {
            querySchema.calculatedFields = new CalculatedField[calculatedFields.size()];
            for (int i = 0; i < querySchema.calculatedFields.length; ++i) {
                CalculatedField field = calculatedFields.get(i);
                querySchema.calculatedFields[i] = new CalculatedField(field.name, field.type, field.text, field.expr);
            }
        }
        querySchema.metrics = queryModel.metrics;
        String billHeaderFields = (String)this.dataModel.getDataSource().getProperty("billHeaderFields");
        if (billHeaderFields != null) {
            querySchema.billHeaderFields = billHeaderFields;
            querySchema.billNumberField = (String)this.dataModel.getDataSource().getProperty("billNumberField");
        }
        return querySchema;
    }

    private void copyNames(Dimension[] dimensions, String[] dimensionNames) {
        for (int i = 0; i < dimensionNames.length; ++i) {
            dimensionNames[i] = dimensions[i].name;
        }
    }

    public void close() {
        if (this.chartFrame != null) {
            this.chartFrame.dispose();
        }
    }
}

