/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.streamwork.cuba.MdxResult;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.pivot.ExcelPivotConditionPanel;
import com.kingdee.bos.streamwork.pivot.Executor;
import com.kingdee.bos.streamwork.pivot.ExecutorFactory;
import com.kingdee.bos.streamwork.pivot.Location;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItem;
import com.kingdee.bos.streamwork.pivot.excelui.FilterItemWidget;
import com.kingdee.bos.streamwork.pivot.excelui.dnd.PanelDropTarget;
import com.kingdee.bos.streamwork.pivot.model.DataModel;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import com.kingdee.bos.streamwork.pivot.model.ResultModel;
import com.kingdee.bos.streamwork.pivot.worksheet.Config;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotWorksheetComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ExcelPivotComponent
extends KDPanel {
    private static final Logger logger = Logger.getLogger(ExcelPivotComponent.class);
    private DataSource dataSource;
    private Executor executor;
    DataModel dataModel = null;
    PivotWorksheetComponent wc = null;
    KDTable table = null;
    KDPanel tablePanel = null;
    ExcelPivotConditionPanel conditionPanel = null;
    FilterItemWidget filterItemWidget = null;

    public ExcelPivotComponent(DataSource dataSource) {
        this(dataSource, null);
    }

    public ExcelPivotComponent(DataSource dataSource, Executor executor) {
        this.dataSource = dataSource;
        this.executor = executor == null ? ExecutorFactory.createExecutorForExcelPivot() : executor;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.table = new KDTable();
        this.table.setAutoscrolls(true);
        this.table.checkParsed();
        Config cc = Config.getConfig();
        cc.showColumnDimensionHeader = true;
        cc.autoColumnWidth = true;
        cc.autoFreeze = false;
        this.wc = new PivotWorksheetComponent(this.table, cc);
        this.dataModel = new DataModel(this.dataSource);
        this.filterItemWidget = new FilterItemWidget(this.dataModel);
        this.conditionPanel = new ExcelPivotConditionPanel(this.dataModel, this.filterItemWidget, new ExcelPivotConditionPanel.ConditionListener(){

            @Override
            public void conditionChanged() {
                ExcelPivotComponent.this.conditionChangedImpl();
            }
        });
        this.tablePanel = new KDPanel();
        new PanelDropTarget((JComponent)this.tablePanel, new PanelDropTarget.DropCallBack(){

            @Override
            public boolean drop(CheckedItem item, Point location) {
                return ExcelPivotComponent.this.dropInTable(item);
            }
        });
        this.tablePanel.setLayout((LayoutManager)new BorderLayout());
        this.tablePanel.add((Component)this.table, (Object)"Center");
        KDSplitPane leftSplitPane = new KDSplitPane(0, (Component)this.filterItemWidget, (Component)this.tablePanel);
        leftSplitPane.setDividerLocation(100);
        leftSplitPane.setDividerSize(5);
        KDSplitPane splitPane = new KDSplitPane(1, (Component)leftSplitPane, (Component)((Object)this.conditionPanel));
        splitPane.setDividerLocation(0.7);
        splitPane.setResizeWeight(0.7);
        splitPane.setDividerSize(5);
        this.add((Component)splitPane, "Center");
        this.clearTable();
    }

    protected boolean dropInTable(CheckedItem item) {
        if (Location.FIELDLIST.equals(item.location) && !item.selected) {
            this.conditionPanel.getFieldListWidget().setSelected(item.name, true, true);
        }
        return true;
    }

    private void clearTable() {
        int i;
        this.table.removeColumns();
        this.table.removeRows();
        IRow headRow = this.table.addHeadRow();
        for (i = 0; i < 10; ++i) {
            IColumn col = this.table.addColumn();
            col.setKey("F" + i);
            headRow.getCell(i).setValue((Object)new Character((char)(65 + i)));
        }
        for (i = 0; i < 25; ++i) {
            this.table.addRow();
        }
    }

    protected void conditionChangedImpl() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ExcelPivotComponent.this.setCursor(Cursor.getPredefinedCursor(3));
                    ExcelPivotComponent.this.doConditionChanged();
                }
                finally {
                    ExcelPivotComponent.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConditionChanged() {
        QueryModel queryModel = this.conditionPanel.getQueryModel();
        if (queryModel == null) {
            this.clearTable();
            this.updateUI();
            return;
        }
        long start = System.currentTimeMillis();
        ResultModel resultModel = this.executor.execute(this.dataSource, queryModel);
        MdxResult mdxResult = (MdxResult)resultModel.getResult();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doConditionChanged executor.execute cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        start = System.currentTimeMillis();
        boolean refresh = this.table.isRefresh();
        try {
            this.table.setRefresh(false);
            this.wc.render(mdxResult);
            this.table.setRefresh(true);
            this.table.updateUI();
        }
        finally {
            this.table.setRefresh(refresh);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doConditionChanged render and updateUI cost " + (System.currentTimeMillis() - start) + "ms."));
            }
        }
        this.updateUI();
    }
}

