/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot;

import com.kingdee.bos.ctrl.swing.KDOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class PivotUtils {
    private static SimpleDateFormat mdf = new SimpleDateFormat("yyyy-MM-dd");

    public static boolean arrayContains(Object[] values, Object value) {
        if (values == null) {
            return false;
        }
        return Arrays.asList(values).contains(value);
    }

    public static void makeCenter(Window wnd) {
        Rectangle rc = new Rectangle(wnd.getBounds());
        Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
        rc.x = (sz.width - rc.width) / 2;
        rc.y = (sz.height - rc.height) / 2;
        wnd.setBounds(rc);
    }

    public static void alert(String message, Window parent) {
        KDOptionPane.showMessageDialog((Component)parent, (Object)message);
    }

    public static String readFileContent(InputStream in) throws IOException {
        String line;
        String content = "";
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            content = content + line + "\r\n";
        }
        return content;
    }

    public static String replace(String str, String r, String replacement, int n) {
        if (replacement == null) {
            replacement = "";
        }
        if (r == null && r.equals("")) {
            return str;
        }
        int len = r.length();
        int rlen = replacement.length();
        int from = 0;
        for (int num = 0; num < n; ++num) {
            int pos = str.indexOf(r, from);
            if (pos < 0) {
                return str;
            }
            str = str.substring(0, pos) + replacement + str.substring(pos + len);
            from = pos + rlen;
        }
        return str;
    }

    public static JFrame getMainFrame() {
        Window window = null;
        window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window == null) {
            return null;
        }
        Container parent = window;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return (JFrame)parent;
    }

    public static JFrame getParentFrame() {
        Window window = null;
        window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window == null) {
            return null;
        }
        Container parent = window;
        while (parent.getParent() != null) {
            if (!((parent = parent.getParent()) instanceof JFrame)) continue;
            return (JFrame)parent;
        }
        return (JFrame)parent;
    }

    public static JFrame getParentFrame(JComponent c) {
        Container parent = c;
        while (parent.getParent() != null) {
            if (!((parent = parent.getParent()) instanceof JFrame)) continue;
            return (JFrame)parent;
        }
        return (JFrame)parent;
    }

    public static String formatSimpleDate(Date date) {
        return mdf.format(date);
    }
}

