/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.easui;

import com.kingdee.bos.ctrl.common.layout.table.Style;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.easui.SelectFieldDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class BillConfigDialog
extends KDDialog {
    private KDTextField tfBillNumber;
    private KDTextField tfBillHeaders;
    private KDLabelContainer lcBillNumber;
    private KDLabelContainer lcBillHeaders;
    private KDButton btnBillNumber;
    private KDButton btnBillHeaders;
    private KDTextArea taNotes;
    private KDLabelContainer lcNotes;
    private KDButton btnOk;
    private KDButton btnCancel;
    private SelectFieldDialog selectFieldDialog;
    private boolean isOk = false;
    DataSource dataSource;

    public BillConfigDialog(JFrame parent) {
        super((Frame)parent);
        this.initUI();
        this.initListener();
    }

    private void initUI() {
        this.setTitle("\u5355\u636e\u8bbe\u7f6e");
        this.setSize(860, 400);
        this.setModal(true);
        this.tfBillNumber = new KDTextField(50);
        this.tfBillHeaders = new KDTextField(50);
        this.lcBillNumber = new KDLabelContainer("\u5355\u636e\u552f\u4e00\u503c\u5b57\u6bb5\uff1a", (JComponent)this.tfBillNumber);
        this.lcBillHeaders = new KDLabelContainer("\u5355\u636e\u5934\u6570\u503c\u5b57\u6bb5\uff1a", (JComponent)this.tfBillHeaders);
        this.lcBillNumber.setBoundLabelLength(100);
        this.lcBillHeaders.setBoundLabelLength(100);
        this.btnBillNumber = new KDButton("\u9009\u62e9\u5b57\u6bb5");
        this.btnBillHeaders = new KDButton("\u9009\u62e9\u5b57\u6bb5");
        this.btnBillNumber.setSize(50, 22);
        this.btnBillHeaders.setSize(50, 22);
        this.tfBillNumber.setEnabled(false);
        this.tfBillHeaders.setEnabled(false);
        String notes = "\r\n\u9ed8\u8ba4\u60c5\u51b5\u4e0b\uff0c\u5047\u8bbe\u4e00\u4e2a\u5355\u636e\u670910\u6761\u5206\u5f55\uff0c\u90a3\u4e48\u5355\u636e\u5934\u7684\u6570\u503c\u5b57\u6bb5\u6c47\u603b\u65f6\u4f1a\u88ab\u91cd\u590d\u8ba1\u7b9710\u6b21\u3002\r\n\u901a\u8fc7\u8bbe\u7f6e\u5355\u636e\u552f\u4e00\u503c\u5b57\u6bb5(\u5982id)\u548c\u5355\u636e\u5934\u6570\u503c\u5b57\u6bb5\uff0c\u9ad8\u7ea7\u7edf\u8ba1\u5c06\u4e3a\u5355\u636e\u5934\u6570\u503c\u5b57\u6bb5\u6c47\u603b\u8fdb\u884c\u6d88\u9664\u91cd\u590d\u8ba1\u7b97\u5904\u7406\u3002\r\n";
        this.taNotes = new KDTextArea(notes);
        this.taNotes.setEnabled(false);
        this.lcNotes = new KDLabelContainer("\u8bf4\u660e\uff1a", (JComponent)this.taNotes);
        this.lcNotes.setBoundLabelLength(100);
        this.lcNotes.setAutoscrolls(true);
        KDPanel p1 = new KDPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)p1, "Center");
        TableLayout layout = TableLayout.splitRow((int)5);
        p1.setLayout((LayoutManager)layout);
        KDPanel pbn = new KDPanel();
        pbn.setLayout((LayoutManager)new FlowLayout(0));
        pbn.add((Component)this.lcBillNumber);
        pbn.add((Component)this.btnBillNumber);
        p1.add((Component)pbn, (Object)layout.cell(0));
        KDPanel pbh = new KDPanel();
        pbh.setLayout((LayoutManager)new FlowLayout(0));
        pbh.add((Component)this.lcBillHeaders);
        pbh.add((Component)this.btnBillHeaders);
        p1.add((Component)pbh, (Object)layout.cell(1));
        p1.add((Component)this.lcNotes, (Object)layout.cell(2));
        Style style = new Style();
        style.setPriY(1);
        layout.cell(3).setStyle(style);
        this.btnOk = new KDButton("\u786e\u5b9a");
        this.btnCancel = new KDButton("\u53d6\u6d88");
        KDPanel bottomPanel = new KDPanel();
        bottomPanel.setLayout((LayoutManager)new FlowLayout(2));
        bottomPanel.add((Component)this.btnOk);
        bottomPanel.add((Component)this.btnCancel);
        this.add((Component)bottomPanel, "South");
        PivotUtils.makeCenter((Window)((Object)this));
    }

    private void initListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                int x = evt.getComponent().getWidth();
                BillConfigDialog.this.tfBillNumber.setColumns(x / 20);
                BillConfigDialog.this.tfBillHeaders.setColumns(x / 20);
                BillConfigDialog.this.lcBillNumber.setBoundLabelLength(x / 8);
                BillConfigDialog.this.lcBillHeaders.setBoundLabelLength(x / 8);
                BillConfigDialog.this.btnBillNumber.setSize(x / 16, 22);
                BillConfigDialog.this.btnBillHeaders.setSize(x / 16, 22);
                BillConfigDialog.this.taNotes.setSize((int)((double)x * 0.6), 300);
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillConfigDialog.this.ok();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillConfigDialog.this.cancel();
            }
        });
        this.btnBillNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillConfigDialog.this.selectBillNumberField();
            }
        });
        this.btnBillHeaders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillConfigDialog.this.selectBillNumberHeaders();
            }
        });
    }

    private void selectBillNumberField() {
        if (this.selectFieldDialog == null) {
            this.selectFieldDialog = new SelectFieldDialog((JDialog)((Object)this));
        }
        this.selectFieldDialog.setCanBeEmpty(true);
        this.selectFieldDialog.showUI(this.dataSource.getColumnNames(), this.getSelected(this.tfBillNumber), true);
        if (this.selectFieldDialog.isOk()) {
            String[] selectedFields = this.selectFieldDialog.getSelectedField();
            this.setSelected(this.tfBillNumber, selectedFields);
        }
    }

    private void selectBillNumberHeaders() {
        if (this.selectFieldDialog == null) {
            this.selectFieldDialog = new SelectFieldDialog((JDialog)((Object)this));
        }
        this.selectFieldDialog.setCanBeEmpty(true);
        this.selectFieldDialog.showUI(this.dataSource.getColumnNames(), this.getSelected(this.tfBillHeaders), false);
        if (this.selectFieldDialog.isOk()) {
            String[] selectedFields = this.selectFieldDialog.getSelectedField();
            this.setSelected(this.tfBillHeaders, selectedFields);
        }
    }

    private List getSelected(KDTextField tf) {
        String text = tf.getText();
        ArrayList<String> result = null;
        if (text != null && text.length() > 0) {
            result = new ArrayList<String>();
            String[] parts = text.split(",");
            for (int i = 0; i < parts.length; ++i) {
                result.add(parts[i]);
            }
        }
        return result;
    }

    public void setSelected(KDTextField tf, String[] fields) {
        if (fields == null || fields.length == 0) {
            tf.setText(null);
            return;
        }
        String text = "";
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                text = text + ",";
            }
            text = text + fields[i];
        }
        tf.setText(text);
    }

    public boolean isOk() {
        return this.isOk;
    }

    protected void cancel() {
        this.isOk = false;
        this.setVisible(false);
    }

    protected void ok() {
        List billNumberFields = this.getSelected(this.tfBillNumber);
        List billHeaderFieldList = this.getSelected(this.tfBillHeaders);
        if (billHeaderFieldList != null && billHeaderFieldList.size() > 0 && billNumberFields == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "\u9009\u62e9\u4e86\u5355\u636e\u5934\u6570\u503c\u5b57\u6bb5\uff0c\u5fc5\u987b\u9009\u62e9\u5355\u636eid\u6216\u7f16\u7801\u5b57\u6bb5");
            return;
        }
        if (billHeaderFieldList != null) {
            String billHeaderFields = "";
            for (int i = 0; i < billHeaderFieldList.size(); ++i) {
                if (i > 0) {
                    billHeaderFields = billHeaderFields + ",";
                }
                billHeaderFields = billHeaderFields + billHeaderFieldList.get(i);
            }
            this.dataSource.setProperty("billHeaderFields", billHeaderFields);
        } else {
            this.dataSource.setProperty("billHeaderFields", null);
        }
        if (billNumberFields != null && billNumberFields.size() > 0) {
            this.dataSource.setProperty("billNumberField", billNumberFields.get(0));
        } else {
            this.dataSource.setProperty("billNumberField", null);
        }
        this.isOk = true;
        this.setVisible(false);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        String billNumberField = (String)dataSource.getProperty("billNumberField");
        String billHeaderFields = (String)dataSource.getProperty("billHeaderFields");
        String headerNumberField = (String)dataSource.getProperty("headerNumberField");
        if (billNumberField != null) {
            this.tfBillNumber.setText(billNumberField);
        } else if (headerNumberField != null) {
            this.tfBillNumber.setText(headerNumberField);
        }
        if (billHeaderFields != null) {
            this.setSelected(this.tfBillHeaders, billHeaderFields.split(","));
        }
    }

    private void setDefaultBillNumberField(String billNumberField) {
        this.tfBillNumber.setText(billNumberField);
    }
}

