/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.easui;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDHyperlink;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.streamwork.calculator.CalculatedField;
import com.kingdee.bos.streamwork.calculator.Expr;
import com.kingdee.bos.streamwork.calculator.ExprParser;
import com.kingdee.bos.streamwork.calculator.FunDef;
import com.kingdee.bos.streamwork.calculator.MapExecuteContext;
import com.kingdee.bos.streamwork.calculator.VerifyVisitor;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.pivot.FunctionHelpFrame;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.easui.SelectFieldDialog;
import com.kingdee.bos.util.backport.Arrays;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class CalculatedFieldDialog
extends KDDialog {
    private KDButton btnOk;
    private KDButton btnCancel;
    private KDTextField tfName;
    private KDLabelContainer lcName;
    private KDLabel lblNameVerify;
    private KDTextPane taFormula;
    private KDLabel lblMessage;
    private KDTable table;
    private KDHyperlink helpLink;
    private KDButton btnSelectField;
    private KDComboBox cbFunc;
    FunctionHelpFrame funcHelpFrame;
    private SelectFieldDialog selectFieldDialog;
    private String demo = "\r\na + b\r\na * 2\r\n(a + b) * c /100\r\nFName + \"\u4e2d\u56fd\"";
    private boolean isOk;
    int type;
    Expr expr;
    String name;
    DataSource dataSource;
    private CalculatedField initField;

    public CalculatedFieldDialog(Frame owner) {
        super(owner);
        this.initUI();
        this.initListener();
    }

    public void initUI() {
        this.btnOk = new KDButton("\u786e\u5b9a");
        this.btnCancel = new KDButton("\u53d6\u6d88");
        KDPanel bottomPanel = new KDPanel();
        bottomPanel.setLayout((LayoutManager)new FlowLayout(2));
        bottomPanel.add((Component)this.btnOk);
        bottomPanel.add((Component)this.btnCancel);
        this.tfName = new KDTextField(20);
        this.lcName = new KDLabelContainer("\u5b57\u6bb5\u540d\u79f0:", (JComponent)this.tfName);
        this.lblNameVerify = new KDLabel();
        this.lblNameVerify.setForeground(Color.RED);
        KDPanel p7 = new KDPanel();
        p7.setLayout((LayoutManager)new FlowLayout(3));
        p7.add((Component)this.lcName);
        p7.add((Component)this.lblNameVerify);
        KDLabel lblFormula = new KDLabel("\u516c\u5f0f(\u8f93\u5165\u5b57\u6bb5\u9700\u8981\u7528[]):");
        this.taFormula = new KDTextPane();
        this.taFormula.setFont(new Font("\u5b8b\u4f53", 0, 16));
        KDScrollPane spFormula = new KDScrollPane((Component)this.taFormula);
        this.lblMessage = new KDLabel();
        this.btnSelectField = new KDButton("\u9009\u62e9\u5b57\u6bb5");
        this.cbFunc = new KDComboBox();
        this.cbFunc.addItem((Object)"--\u51fd\u6570\u5217\u8868--");
        this.cbFunc.addItems((Object[])FunDef.getAllFuncNames());
        this.helpLink = new KDHyperlink((Action)new AbstractAction("\u51fd\u6570\u5e2e\u52a9"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatedFieldDialog.this.showFunctionHelp();
            }
        });
        KDPanel p6 = new KDPanel();
        p6.setLayout((LayoutManager)new FlowLayout(0));
        p6.add((Component)lblFormula);
        p6.add((Component)this.btnSelectField);
        p6.add((Component)this.cbFunc);
        p6.add((Component)this.helpLink);
        p6.add((Component)this.lblMessage);
        KDLabel lblPreview = new KDLabel("\u9884\u89c8:");
        this.table = new KDTable();
        this.table.addHeadRow();
        this.table.addColumns(5);
        this.table.addRows(3);
        this.table.setEditable(false);
        this.table.setAutoscrolls(true);
        KDPanel p1 = new KDPanel();
        p1.setLayout((LayoutManager)new BorderLayout());
        p1.add((Component)p6, (Object)"North");
        p1.add((Component)spFormula, (Object)"Center");
        KDPanel centerPanel = new KDPanel();
        centerPanel.setLayout((LayoutManager)new BorderLayout());
        centerPanel.add((Component)p7, (Object)"North");
        centerPanel.add((Component)p1, (Object)"Center");
        KDPanel p2 = new KDPanel();
        p2.setLayout((LayoutManager)new BorderLayout());
        p2.add((Component)lblPreview, (Object)"North");
        p2.add((Component)new KDScrollPane((Component)this.table), (Object)"Center");
        p2.setPreferredSize(new Dimension(600, 200));
        KDPanel p3 = new KDPanel();
        p3.setLayout((LayoutManager)new BorderLayout());
        p3.add((Component)centerPanel, (Object)"Center");
        p3.add((Component)p2, (Object)"South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)p3, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setTitle("\u516c\u5f0f\u7f16\u8f91");
        this.setModal(true);
        this.setSize(960, 800);
        this.setDefaultCloseOperation(2);
        PivotUtils.makeCenter((Window)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showFunctionHelp() {
        Properties prop = System.getProperties();
        String tempdir = prop.getProperty("java.io.tmpdir");
        String name = "\u9ad8\u7ea7\u7edf\u8ba1\u51fd\u6570\u5e2e\u52a9.txt";
        String filename = tempdir + name;
        InputStream in = null;
        OutputStreamWriter writer = null;
        try {
            in = PivotUtils.class.getResourceAsStream("functionreference.txt");
            String content = PivotUtils.readFileContent(in);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8");
            writer.write(content);
            writer.flush();
            Runtime.getRuntime().exec("explorer " + filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void initListener() {
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatedFieldDialog.this.ok();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatedFieldDialog.this.cancel();
            }
        });
        this.btnSelectField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatedFieldDialog.this.selectField();
            }
        });
        this.cbFunc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (CalculatedFieldDialog.this.cbFunc.getSelectedIndex() == 0) {
                        return;
                    }
                    CalculatedFieldDialog.this.selectFunc();
                }
            }
        });
        this.taFormula.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalculatedFieldDialog.this.documentChanged(e.getOffset(), e.getLength());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalculatedFieldDialog.this.documentChanged(e.getOffset(), e.getLength());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalculatedFieldDialog.this.documentChanged(e.getOffset(), e.getLength());
            }
        });
        this.tfName.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CalculatedFieldDialog.this.checkName();
                        CalculatedFieldDialog.this.documentChanged1();
                    }
                });
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void selectFunc() {
        final String func = (String)this.cbFunc.getSelectedItem();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int pos = CalculatedFieldDialog.this.taFormula.getCaretPosition();
                    CalculatedFieldDialog.this.appendFormula(func + "()");
                    if (pos >= 0) {
                        CalculatedFieldDialog.this.taFormula.setCaretPosition(pos += func.length() + 1);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void documentChanged(final int offset, final int len) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CalculatedFieldDialog.this.documentChanged0(offset, len);
            }
        });
    }

    private void documentChanged0(int offset, int len) {
        this.documentChanged1();
    }

    private void clearTable() {
        this.table.removeRows();
        this.table.removeColumns();
        this.table.removeHeadRows();
        this.table.addHeadRow();
        this.table.addColumns(5);
        this.table.addRows(3);
        this.table.setColumnsAutoResizeMode(4);
    }

    private void checkName() {
        this.lblNameVerify.setText("");
        this.name = this.tfName.getText().trim();
        if (this.name.length() == 0) {
            this.lblNameVerify.setText("\u8bf7\u8f93\u5165\u5b57\u6bb5\u540d\u79f0");
            return;
        }
        String[] fields = this.dataSource.getColumnNames();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].equalsIgnoreCase(this.name)) continue;
            this.lblNameVerify.setText("\u5b57\u6bb5\u540d\u79f0" + this.name + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539");
            return;
        }
    }

    private void documentChanged1() {
        Object[] fields = this.dataSource.getColumnNames();
        String formula = this.taFormula.getText().trim();
        if (formula.length() == 0) {
            return;
        }
        formula.replace('\n', ' ');
        formula.replace('\r', ' ');
        formula.replaceAll("  ", " ");
        try {
            this.clearTable();
            this.lblMessage.setText("");
            Expr expr = ExprParser.parse(formula);
            MapExecuteContext ctx = new MapExecuteContext();
            for (int i = 0; i < fields.length; ++i) {
                ctx.putValue(fields[i], null);
            }
            VerifyVisitor visitor = new VerifyVisitor(ctx);
            expr.accept(visitor);
            List<String> list = visitor.getInvalidSymboList();
            if (list.size() > 0) {
                String message = "\u975e\u6cd5\u5b57\u6bb5\u540d: ";
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        message = message + ",";
                    }
                    message = message + list.get(i);
                }
                this.lblMessage.setForeground(Color.RED);
                this.lblMessage.setText(message);
                return;
            }
            List<String> validFieldList = visitor.getValidSymboList();
            List allFields = Arrays.asList((Object[])fields);
            this.table.removeRows();
            this.table.removeColumns();
            this.table.removeHeadRows();
            IRow headRow = this.table.addHeadRow();
            int colCount = 1 + (validFieldList.size() > 5 ? validFieldList.size() : 5);
            this.table.addColumns(colCount);
            for (int i = 0; i < colCount; ++i) {
                this.table.getColumn(i).setRenderer((IBasicRender)CellTextRender.shareInstance());
            }
            for (int j = 0; j < validFieldList.size(); ++j) {
                String value = validFieldList.get(j);
                headRow.getCell(j).setValue((Object)value);
            }
            String fieldName = this.tfName.getText().trim();
            if (fieldName.length() == 0) {
                fieldName = "\u8ba1\u7b97\u7ed3\u679c";
            }
            headRow.getCell(validFieldList.size()).setValue((Object)fieldName);
            this.table.getColumn(validFieldList.size()).setWidth(300);
            ctx = new MapExecuteContext();
            for (int i = 0; i < 20 && i < this.dataSource.getRowCount(); ++i) {
                Object value;
                int j;
                IRow row = this.table.addRow();
                for (j = 0; j < fields.length; ++j) {
                    ctx.putValue((String)fields[j], this.dataSource.getCell(j, i));
                }
                for (j = 0; j < validFieldList.size(); ++j) {
                    int index = allFields.indexOf(validFieldList.get(j));
                    value = this.dataSource.getCell(index, i);
                    ctx.putValue(validFieldList.get(j), value);
                    if (value instanceof Date) {
                        value = PivotUtils.formatSimpleDate((Date)value);
                    }
                    row.getCell(j).setValue(value);
                }
                try {
                    value = expr.execute(ctx);
                    if (value instanceof Date) {
                        value = PivotUtils.formatSimpleDate((Date)value);
                    }
                    row.getCell(validFieldList.size()).setValue(value);
                    continue;
                }
                catch (Throwable t) {
                    value = "Error(" + t.getMessage() + ")";
                    row.getCell(validFieldList.size()).setValue(value);
                }
            }
            this.table.setColumnsAutoResizeMode(4);
        }
        catch (Throwable t) {
            String message = t.getMessage();
            this.lblMessage.setForeground(Color.RED);
            this.lblMessage.setText(message);
            return;
        }
    }

    private void selectField() {
        this.selectFieldDialog = new SelectFieldDialog((JDialog)((Object)this));
        this.selectFieldDialog.showUI(this.dataSource.getColumnNames());
        if (this.selectFieldDialog.isOk()) {
            String[] selectedFields = this.selectFieldDialog.getSelectedField();
            String text = " ";
            for (int i = 0; i < selectedFields.length; ++i) {
                text = text + "[" + selectedFields[i] + "] ";
            }
            try {
                this.appendFormula(text);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private void appendFormula(String text) throws BadLocationException {
        int pos = this.taFormula.getCaretPosition();
        String str = this.taFormula.getText();
        if (pos < 0 || pos == str.length()) {
            this.taFormula.setText(str + text);
        } else if (pos == 0) {
            this.taFormula.setText(text + str);
        } else {
            String left = this.taFormula.getText(0, pos);
            String right = this.taFormula.getText(pos, str.length() - pos);
            this.taFormula.setText(left + text + right);
        }
    }

    private void showDemo() {
        try {
            this.appendFormula(this.demo);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean isOk() {
        return this.isOk;
    }

    private void cancel() {
        this.setVisible(false);
        this.isOk = false;
    }

    public CalculatedField getCalculatedField() {
        if (!this.isOk) {
            return null;
        }
        if (this.initField != null) {
            this.initField.type = this.type;
            this.initField.text = this.taFormula.getText();
            this.initField.expr = this.expr;
            return this.initField;
        }
        CalculatedField field = new CalculatedField(this.name, this.type, this.taFormula.getText(), this.expr);
        return field;
    }

    private void ok() {
        String formula;
        this.name = this.tfName.getText().trim();
        String[] fields = this.dataSource.getColumnNames();
        if (this.tfName.isEnabled()) {
            if (this.name.length() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "\u8bf7\u8f93\u5165\u5b57\u6bb5\u540d\u79f0");
                this.tfName.requestFocusInWindow();
                return;
            }
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equalsIgnoreCase(this.name)) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "\u5b57\u6bb5\u540d\u79f0" + this.name + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                this.tfName.requestFocusInWindow();
                return;
            }
        }
        if ((formula = this.taFormula.getText().trim()).length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "\u516c\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
            this.taFormula.requestFocusInWindow();
            return;
        }
        formula.replace('\n', ' ');
        formula.replace('\r', ' ');
        formula.replaceAll("  ", " ");
        try {
            this.expr = ExprParser.parse(formula);
            MapExecuteContext ctx = new MapExecuteContext();
            for (int i = 0; i < fields.length; ++i) {
                ctx.putValue(fields[i], null);
            }
            VerifyVisitor visitor = new VerifyVisitor(ctx);
            this.expr.accept(visitor);
            List<String> list = visitor.getInvalidSymboList();
            if (list.size() > 0) {
                String message = "\u516c\u5f0f\u9519\u8bef: ";
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        message = message + ",";
                    }
                    message = message + list.get(i);
                }
                JOptionPane.showMessageDialog((Component)((Object)this), message);
                return;
            }
            this.type = 2;
            ctx = new MapExecuteContext();
            for (int i = 0; i < this.dataSource.getRowCount(); ++i) {
                for (int j = 0; j < fields.length; ++j) {
                    ctx.putValue(fields[j], this.dataSource.getCell(j, i));
                }
                try {
                    Object value = this.expr.execute(ctx);
                    if (value == null) continue;
                    if (value instanceof Number) {
                        this.type = 2;
                        break;
                    }
                    if (value instanceof Boolean) {
                        this.type = 16;
                        break;
                    }
                    if (!(value instanceof String)) break;
                    this.type = 12;
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.isOk = true;
            this.setVisible(false);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog((Component)((Object)this), "\u811a\u672c\u89e3\u6790\u5931\u8d25, \u539f\u56e0:" + t.getMessage());
            return;
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static void main(String[] args) throws Exception {
        new CalculatedFieldDialog(null).show();
    }

    public void setInitField(CalculatedField initField) {
        this.tfName.setText(initField.name);
        this.tfName.setEnabled(false);
        this.taFormula.setText(initField.text);
        this.initField = initField;
    }
}

