/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.easui;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.streamwork.calculator.CalculatedField;
import com.kingdee.bos.streamwork.datasource.DataSourceWithCalculate;
import com.kingdee.bos.streamwork.pivot.Location;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.easui.ColumnItem;
import com.kingdee.bos.streamwork.pivot.easui.ColumnItemComponentListener;
import com.kingdee.bos.streamwork.pivot.easui.ComponentOption;
import com.kingdee.bos.streamwork.pivot.model.AggType;
import com.kingdee.bos.streamwork.pivot.model.DataModel2;
import com.kingdee.bos.streamwork.pivot.resource.Resources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;

public class ColumnItemComponent
extends JPanel {
    DataModel2 dataModel;
    ColumnItem item;
    ComponentOption option;
    ColumnItemComponentListener listener;
    KDLabel labAggType = new KDLabel();
    JPopupMenu popupMenuAggType = new JPopupMenu();
    JLabel labName = new JLabel();
    JLabel labClose = new JLabel();
    JLabel labEdit;
    Color originBgColor;
    Color originForeColor;
    private boolean calculate;

    public ColumnItemComponent(DataModel2 dataModel, ColumnItem item, ComponentOption option, ColumnItemComponentListener listener) {
        this.dataModel = dataModel;
        this.item = item;
        this.listener = listener;
        this.option = option;
        this.initUI();
    }

    private void initPopupMenu() {
        MyAction action1 = new MyAction(AggType.TYPE_SUM);
        MyAction action2 = new MyAction(AggType.TYPE_COUNT);
        MyAction action3 = new MyAction(AggType.TYPE_AVG);
        MyAction action4 = new MyAction(AggType.TYPE_MAX);
        MyAction action5 = new MyAction(AggType.TYPE_MIN);
        this.popupMenuAggType.add(action1);
        this.popupMenuAggType.add(action2);
        this.popupMenuAggType.add(action3);
        this.popupMenuAggType.add(action4);
        this.popupMenuAggType.add(action5);
        if (this.item.aggOnlyCount) {
            action1.setEnabled(false);
            action3.setEnabled(false);
            action4.setEnabled(false);
            action5.setEnabled(false);
        }
    }

    public ColumnItem getItem() {
        return this.item;
    }

    private void initUI() {
        this.setBorder(new LineBorder(Color.GRAY));
        this.labName = new JLabel();
        this.labName.setText(this.item.name);
        this.labName.setCursor(Cursor.getPredefinedCursor(13));
        this.originBgColor = this.labName.getBackground();
        this.originForeColor = this.labName.getForeground();
        this.setLayout(new BorderLayout());
        this.add((Component)this.labName, "West");
        if (this.item.isCountMeasure()) {
            this.setToolTipText("\u884c\u8ba1\u6570\uff0c\u5373\u5206\u7c7b\u5b57\u6bb5\u503c\u5728\u539f\u59cb\u660e\u7ec6\u6570\u636e\u4e2d\u51fa\u73b0\u6b21\u6570\u7684\u603b\u548c\u3002");
        }
        if (!this.item.isCountMeasure() && !this.item.isMetric() && Location.METRIC.equals(this.item.location)) {
            this.initPopupMenu();
            this.labAggType.setText(this.getAggTypeText());
            this.labAggType.setUnderline(true);
            this.labAggType.setUnderlineColor(Color.GRAY);
            this.labAggType.setPreferredSize(new Dimension(40, 20));
            this.labAggType.setCursor(Cursor.getPredefinedCursor(12));
            this.add((Component)this.labAggType, "Center");
            this.labAggType.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ColumnItemComponent.this.popupMenuAggType.show((Component)ColumnItemComponent.this.labAggType, e.getX(), e.getY());
                }
            });
        }
        JPanel iconPanel = new JPanel();
        this.add((Component)iconPanel, "East");
        iconPanel.setLayout(new BorderLayout());
        if (this.option.closable) {
            this.labClose = new JLabel();
            this.labClose.setIcon(Resources.getIcon("icon/tbtn_close2.gif"));
            this.labClose.setCursor(Cursor.getPredefinedCursor(12));
            iconPanel.add((Component)this.labClose, "East");
            this.labClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ColumnItemComponent.this.closeMe();
                }
            });
        }
        if (this.option.editable) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ColumnItemComponent.this.editMe();
                    }
                }
            });
        }
    }

    public String getAggTypeText() {
        return " (" + AggType.getName(this.item.aggType) + ")";
    }

    public void argTypeChanged(AggType aggType) {
        this.item.aggType = aggType.getType();
        this.labAggType.setText(this.getAggTypeText());
        if (this.listener != null) {
            this.listener.aggTypeChanged();
        }
    }

    protected void closeMe() {
        if (this.listener != null) {
            if (this.calculate && this.option.location.equals(Location.FIELDLIST)) {
                List<CalculatedField> list = this.confirmClose();
                if (list == null) {
                    return;
                }
                this.listener.closeCalculated(this, list);
            } else {
                this.listener.close(this);
            }
        }
    }

    private void editMe() {
        if (this.listener != null) {
            this.listener.edit(this);
        }
    }

    private List<CalculatedField> confirmClose() {
        DataSourceWithCalculate dataSource = (DataSourceWithCalculate)this.dataModel.getDataSource();
        List<CalculatedField> list = dataSource.getReferenceFields(this.item.name);
        if (list.size() == 0) {
            return list;
        }
        String message = "\u5220\u9664" + this.item.name + "\u5c06\u540c\u65f6\u5220\u9664\u4ee5\u4e0b\u5f15\u7528\u5b57\u6bb5,\u786e\u8ba4\u5220\u9664\u5417?\r\n";
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                message = message + ",";
            }
            message = message + list.get((int)i).name;
        }
        int r = KDOptionPane.showConfirmDialog((Component)PivotUtils.getMainFrame(), (Object)message, (String)"\u63d0\u793a", (int)0);
        if (1 == r) {
            list.clear();
            return null;
        }
        return list;
    }

    public void setListener(ColumnItemComponentListener listener) {
        this.listener = listener;
    }

    public void setBgColor(Color color) {
        this.setBackground(color);
        this.labName.setBackground(color);
        this.labAggType.setBackground(color);
    }

    public void setForeColor(Color color) {
        this.labName.setForeground(color);
        this.labAggType.setForeground(color);
        this.setForeground(color);
    }

    public void setBorderColor(Color color) {
        this.setBorder(new LineBorder(color));
    }

    public void resetBorderColor() {
        this.setBorder(new LineBorder(Color.GRAY));
    }

    public void resetBgColor() {
        this.labName.setBackground(this.originBgColor);
        this.labAggType.setBackground(this.originBgColor);
        this.setBackground(this.originBgColor);
    }

    public void resetForeColor() {
        this.labName.setForeground(this.originForeColor);
        this.labAggType.setForeground(this.originForeColor);
        this.setForeground(this.originForeColor);
    }

    public void setCalculated(boolean calculate) {
        this.calculate = calculate;
    }

    public boolean isCalculate() {
        return this.calculate;
    }

    private class MyAction
    extends AbstractAction {
        AggType aggType;

        public MyAction(AggType aggType) {
            super(aggType.toString());
            this.aggType = aggType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnItemComponent.this.argTypeChanged(this.aggType);
        }
    }
}

