/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.easui;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.streamwork.calculator.CalculatedField;
import com.kingdee.bos.streamwork.datasource.DataSourceWithCalculate;
import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.metric.MetricDialog;
import com.kingdee.bos.streamwork.pivot.Location;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.easui.CalculatedFieldDialog;
import com.kingdee.bos.streamwork.pivot.easui.ColumnItem;
import com.kingdee.bos.streamwork.pivot.easui.ColumnItemComponent;
import com.kingdee.bos.streamwork.pivot.easui.ColumnItemComponentListener;
import com.kingdee.bos.streamwork.pivot.easui.ComponentOption;
import com.kingdee.bos.streamwork.pivot.easui.ConditionChangeCallback;
import com.kingdee.bos.streamwork.pivot.easui.RemoveCalculatedItemCallback;
import com.kingdee.bos.streamwork.pivot.easui.dnd.ComponentDragSource;
import com.kingdee.bos.streamwork.pivot.easui.dnd.PanelDropTarget;
import com.kingdee.bos.streamwork.pivot.model.AggType;
import com.kingdee.bos.streamwork.pivot.model.DataModel2;
import com.kingdee.bos.streamwork.pivot.model.DataType;
import com.kingdee.bos.streamwork.pivot.ui.BackgroundTextPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;

public class ColumnItemContainer
extends JPanel
implements DragGestureListener {
    DataModel2 dataModel;
    ArrayList<ColumnItemComponent> components = new ArrayList();
    ArrayList<JComponent> otherComponents = new ArrayList();
    String title;
    JPanel rootPanel;
    JPanel downTitlePanel;
    protected final ComponentOption option;
    protected ColumnItemComponentListener componentListener;
    protected DropEndCallBack dropEndCallBack = new DropEndCallBack();
    protected DropCallBack dropCallBack = new DropCallBack();
    private RemoveCalculatedItemCallback removeItemCallback;
    JPanel leftPanel;
    JPanel rightPanel;
    MetricDialog metricDialog;
    private ConditionChangeCallback conditionChangeCallback;

    public ColumnItemContainer(DataModel2 dataModel, String title, ComponentOption option) {
        this.dataModel = dataModel;
        this.option = option;
        this.title = title;
        this.setLayout(new BorderLayout());
        this.rootPanel = new BackgroundTextPanel(option.backgroundText);
        JScrollPane sp = new JScrollPane(this.rootPanel, option.vScroll, option.hScroll);
        Dimension d = new Dimension(20, 32);
        this.rootPanel.setMinimumSize(d);
        this.setMinimumSize(d);
        JLabel titleLabel = new JLabel(title);
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new FlowLayout());
        this.leftPanel.setPreferredSize(new Dimension(70, 30));
        if (title != null && title.length() > 0) {
            this.leftPanel.add(titleLabel);
        }
        this.add((Component)this.leftPanel, "West");
        this.setOpaque(true);
        this.rootPanel.setBackground(Color.WHITE);
        this.rootPanel.setPreferredSize(new Dimension(200, 30));
        this.setBorder(new LineBorder(Color.GRAY));
        if (option.scroll) {
            this.add((Component)sp, "Center");
        } else {
            this.add((Component)this.rootPanel, "Center");
        }
        this.rightPanel = new KDPanel();
        this.rightPanel.setLayout(new FlowLayout());
        this.add((Component)this.rightPanel, "East");
        new PanelDropTarget(this.rootPanel, this.dropCallBack);
        this.componentListener = new ColumnItemComponentListener(){

            @Override
            public void close(ColumnItemComponent component) {
                ColumnItemContainer.this.removeItemComponent(component);
            }

            @Override
            public void aggTypeChanged() {
                ColumnItemContainer.this.conditionChanged();
            }

            @Override
            public void closeCalculated(ColumnItemComponent component, List<CalculatedField> list) {
                ColumnItemContainer.this.removeCalculatedComponents(component, list);
            }

            @Override
            public void edit(ColumnItemComponent component) {
                if (component.item.isMetric) {
                    ColumnItemContainer.this.editMetricComponent(component);
                } else {
                    ColumnItemContainer.this.editCalculatedComponent(component);
                }
            }
        };
    }

    public int getInnerHeight() {
        int h1 = this.rootPanel.getHeight();
        if (this.components.size() > 2) {
            Point p1 = this.components.get(0).getLocationOnScreen();
            Point p2 = this.components.get(this.components.size() - 1).getLocationOnScreen();
            int h2 = p2.y - p1.y;
            return h2 += this.components.get(0).getHeight() + 10;
        }
        return h1;
    }

    public boolean showCalculatedFieldDialog() {
        return this.showCalculatedFieldDialog(null);
    }

    public boolean showCalculatedFieldDialog(CalculatedField initField) {
        CalculatedFieldDialog dialog = new CalculatedFieldDialog(PivotUtils.getParentFrame(this));
        dialog.setDataSource(this.dataModel.getDataSource());
        if (initField != null) {
            dialog.setInitField(initField);
        }
        dialog.show();
        if (dialog.isOk()) {
            if (initField != null) {
                dialog.getCalculatedField();
                this.conditionChanged();
            } else {
                CalculatedField field = dialog.getCalculatedField();
                this.dataModel.addCalculatedField(field);
                this.addCalculatedColumn(field.name, true);
            }
            return true;
        }
        return false;
    }

    public void showMetricDialog() {
        this.showMetricDialog(null);
    }

    public void showMetricDialog(Metric initMetric) {
        this.metricDialog = new MetricDialog(PivotUtils.getParentFrame(this));
        this.metricDialog.setDataModel(this.dataModel);
        if (initMetric != null) {
            this.metricDialog.setInitMetric(initMetric);
        }
        this.metricDialog.setVisible(true);
        if (this.metricDialog.isOk()) {
            if (initMetric != null) {
                this.metricDialog.getMetric();
                this.conditionChanged();
            } else {
                Metric metric = this.metricDialog.getMetric();
                this.dataModel.addMetric(metric);
                this.addMetric(metric);
            }
        }
    }

    private void addMetric(Metric metric) {
        ColumnItemComponent comp = this.createColumnItemComponent(metric);
        this.layoutUI();
        this.conditionChanged();
    }

    public void addCalculatedColumn(String column, boolean calculate) {
        ColumnItemComponent comp = this.addItemComponent(column, calculate);
        comp.setCalculated(calculate);
        comp.setForeColor(Color.RED);
        this.layoutUI();
    }

    protected void editCalculatedComponent(ColumnItemComponent component) {
        CalculatedField initField = ((DataSourceWithCalculate)this.dataModel.getDataSource()).getCalculatedField(component.item.name);
        this.showCalculatedFieldDialog(initField);
    }

    protected void editMetricComponent(ColumnItemComponent component) {
        Metric metric = this.dataModel.getMetric(component.item.name);
        this.showMetricDialog(metric);
    }

    protected void removeCalculatedComponents(ColumnItemComponent component, List<CalculatedField> list) {
        ArrayList<ColumnItemComponent> toRemove = new ArrayList<ColumnItemComponent>();
        ArrayList<String> names = new ArrayList<String>();
        toRemove.add(component);
        for (int i = 0; i < list.size(); ++i) {
            String fieldName = list.get((int)i).name;
            for (int j = 0; j < this.components.size(); ++j) {
                if (!this.components.get((int)j).item.name.equals(fieldName)) continue;
                toRemove.add(this.components.get(j));
            }
        }
        for (ColumnItemComponent c : toRemove) {
            this.components.remove(c);
            this.dataModel.removeCalculatedField(c.item.name);
            names.add(c.item.name);
        }
        if (names.size() > 0 && this.removeItemCallback != null) {
            this.removeItemCallback.itemRemoved(names.toArray(new String[0]));
        }
        this.layoutUI();
        this.conditionChanged();
    }

    public void setRemoveCalculatedItemCallback(RemoveCalculatedItemCallback removeItemCallback) {
        this.removeItemCallback = removeItemCallback;
    }

    public JPanel getDownTitlePanel() {
        return this.downTitlePanel;
    }

    public void addOtherComponent(JComponent component) {
        this.otherComponents.add(component);
        this.rightPanel.add(component);
        this.layoutUI();
    }

    public void removeItemComponent(String[] fields) {
        ArrayList<ColumnItemComponent> toRemove = new ArrayList<ColumnItemComponent>();
        for (int i = 0; i < fields.length; ++i) {
            for (int j = 0; j < this.components.size(); ++j) {
                if (!this.components.get((int)j).item.name.equals(fields[i])) continue;
                toRemove.add(this.components.get(j));
            }
        }
        if (toRemove.size() > 0) {
            for (ColumnItemComponent c : toRemove) {
                this.components.remove(c);
            }
            this.layoutUI();
            this.conditionChanged();
        }
    }

    protected void removeItemComponent(ColumnItemComponent component) {
        this.components.remove(component);
        this.layoutUI();
        if (this.option.location.equals(Location.FIELDLIST)) {
            if (component.isCalculate()) {
                this.conditionChanged();
            }
        } else if (component.getItem().isMetric()) {
            this.dataModel.removeMetric(component.getItem().name);
            this.conditionChanged();
        } else {
            this.conditionChanged();
        }
    }

    public void layoutUI() {
        this.rootPanel.setLayout(new FlowLayout(0));
        this.rootPanel.removeAll();
        for (int i = 0; i < this.components.size(); ++i) {
            this.rootPanel.add(this.components.get(i));
        }
        this.updateUI();
    }

    public void removeAllComponents() {
        this.components.clear();
    }

    @Override
    public void validateTree() {
        int afterHeight;
        int beforeHeight = -1;
        try {
            beforeHeight = this.getInnerHeight();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        super.validateTree();
        if (beforeHeight > -1 && (afterHeight = this.getInnerHeight()) != beforeHeight) {
            this.rootPanel.setSize(this.rootPanel.getWidth(), afterHeight);
            this.rootPanel.setPreferredSize(new Dimension(this.rootPanel.getWidth(), afterHeight));
        }
    }

    public ColumnItemComponent addItemComponent(String column) {
        Metric metric = this.dataModel.getMetric(column);
        if (metric != null) {
            return this.createColumnItemComponent(metric);
        }
        return this.addItemComponent(column, false);
    }

    public ColumnItemComponent addItemComponent(String column, boolean calculate) {
        ColumnItemComponent component = this.createColumnItemComponent(column, calculate);
        this.components.add(component);
        return component;
    }

    public ColumnItemComponent createColumnItemComponent(String column) {
        return this.createColumnItemComponent(column, false);
    }

    public ColumnItemComponent createColumnItemComponent(String column, boolean calculate) {
        ComponentOption option2 = this.option.copy();
        option2.editable = calculate;
        ColumnItemComponent component = new ColumnItemComponent(this.dataModel, this.createColumnItem(column), option2, this.componentListener);
        new ComponentDragSource(component, 2, this.dropEndCallBack);
        return component;
    }

    public ColumnItemComponent createColumnItemComponent(Metric metric) {
        ColumnItem item = this.createColumnItem(metric);
        ComponentOption option2 = this.option.copy();
        option2.editable = true;
        option2.removeWhenDropOut = true;
        ColumnItemComponent component = new ColumnItemComponent(this.dataModel, item, option2, this.componentListener);
        component.setForeColor(Color.RED);
        this.components.add(component);
        new ComponentDragSource(component, 2, this.dropEndCallBack);
        return component;
    }

    private ColumnItem createColumnItem(Metric metric) {
        ColumnItem item = new ColumnItem(metric);
        return item;
    }

    public ColumnItem createColumnItem(String column) {
        ColumnItem item = new ColumnItem(column);
        item.location = this.option.location;
        if (!item.isCountMeasure() && Location.METRIC.equals(this.option.location)) {
            if (DataType.isNumber(this.dataModel.getColumnValues(column).getDataType())) {
                item.aggType = 0;
            } else {
                item.aggType = 4;
                item.aggOnlyCount = true;
            }
        }
        return item;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    private void dndRemoveItemComponent(ColumnItemComponent p) {
        this.components.remove(p);
        this.layoutUI();
        this.conditionChanged();
    }

    private boolean dndAddItemComponent(ColumnItem item, Point location) {
        TreeMap<Integer, ColumnItemComponent> map = new TreeMap<Integer, ColumnItemComponent>();
        boolean inSamePane = false;
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            ColumnItemComponent component = this.components.get(i);
            Rectangle r = component.getBounds();
            inSamePane = this.option.canBeDropDuplicate ? item == component.item : item.name.equals(component.item.name);
            if (inSamePane) {
                map.put(location.x, component);
                continue;
            }
            map.put((int)r.getCenterX(), component);
        }
        if (!inSamePane) {
            map.put(location.x, this.addItemComponent(item.name));
            this.components = new ArrayList();
            this.components.addAll(map.values());
            this.layoutUI();
            this.conditionChanged();
            return true;
        }
        ArrayList orderedComponents = new ArrayList();
        orderedComponents.addAll(map.values());
        for (int i = 0; i < this.components.size(); ++i) {
            if (orderedComponents.get(i) == this.components.get(i)) continue;
            this.components = orderedComponents;
            this.layoutUI();
            this.conditionChanged();
            break;
        }
        return false;
    }

    public String[] getColumns() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.components.size(); ++i) {
            list.add(this.components.get((int)i).getItem().name);
        }
        return list.toArray(new String[0]);
    }

    public void setAggTypes(int[] aggTypes) {
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).argTypeChanged(new AggType(aggTypes[i]));
        }
    }

    public int[] getAggTypes() {
        int[] aggTypes = new int[this.components.size()];
        for (int i = 0; i < this.components.size(); ++i) {
            aggTypes[i] = this.components.get((int)i).getItem().aggType;
        }
        return aggTypes;
    }

    public void conditionChanged() {
        if (this.conditionChangeCallback != null) {
            this.conditionChangeCallback.callback();
        }
    }

    public void setConditionChangeCallback(ConditionChangeCallback conditionChangeCallback) {
        this.conditionChangeCallback = conditionChangeCallback;
    }

    private class DropCallBack
    implements PanelDropTarget.DropCallBack {
        private DropCallBack() {
        }

        @Override
        public boolean drop(ColumnItem item, Point location) {
            if (ColumnItemContainer.this.option.canBeDropTarget) {
                if (!Location.METRIC.equals(ColumnItemContainer.this.option.location) && (item.isCountMeasure() || item.isMetric())) {
                    return false;
                }
                if (item.isCountMeasure()) {
                    int n = ColumnItemContainer.this.components.size();
                    for (int i = 0; i < n; ++i) {
                        ColumnItemComponent component = ColumnItemContainer.this.components.get(i);
                        if (item.timestamp == component.item.timestamp || !component.item.isCountMeasure()) continue;
                        return false;
                    }
                }
                boolean b = ColumnItemContainer.this.dndAddItemComponent(item, location);
                ColumnItemContainer.this.validate();
                return b;
            }
            return true;
        }
    }

    private class DropEndCallBack
    implements ComponentDragSource.DropCallBack {
        private DropEndCallBack() {
        }

        @Override
        public void dropEnd(Component c) {
            if (ColumnItemContainer.this.option.removeWhenDropOut) {
                ColumnItemComponent p = (ColumnItemComponent)c;
                Container parent = p.getParent();
                ColumnItemContainer.this.dndRemoveItemComponent(p);
                if (parent != null) {
                    parent.validate();
                }
                ColumnItemContainer.this.validate();
                ColumnItemContainer.this.getParent().doLayout();
            }
        }
    }
}

