/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.easui;

import com.kingdee.bos.streamwork.pivot.easui.ColumnItem;
import com.kingdee.bos.streamwork.pivot.easui.ConditionChangeCallback;
import com.kingdee.bos.streamwork.pivot.easui.ValueSelectWidget;
import com.kingdee.bos.streamwork.pivot.easui.dnd.PanelDropTarget;
import com.kingdee.bos.streamwork.pivot.model.DataModel2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ValueSelectContainer
extends JPanel
implements DragGestureListener {
    DataModel2 dataModel;
    ArrayList<ValueSelectWidget> widgets = new ArrayList();
    private HashMap<String, ValueSelectWidget> mapWidget = new HashMap();
    JPanel rootPanel;
    JPanel topPanel;
    private ConditionChangeCallback valueChangeCallback;

    public ValueSelectContainer(DataModel2 dataModel) {
        this.dataModel = dataModel;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.rootPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(this.rootPanel);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)new JLabel("\u8bf7\u5c06\u7b5b\u9009\u5b57\u6bb5\u62d6\u5230\u6b64\u5904"), "West");
        this.add((Component)this.topPanel, "North");
        LineBorder border = new LineBorder(Color.GRAY);
        JPanel scrollPaneContainer = new JPanel();
        scrollPaneContainer.setLayout(new BorderLayout());
        scrollPaneContainer.add((Component)scrollPane, "Center");
        scrollPaneContainer.setBorder(border);
        this.add((Component)scrollPaneContainer, "Center");
        this.rootPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ValueSelectContainer.this.doResizeComponent();
            }
        });
        new PanelDropTarget(this.rootPanel, new PanelDropTarget.DropCallBack(){

            @Override
            public boolean drop(ColumnItem item, Point location) {
                if (item.isCountMeasure()) {
                    return false;
                }
                return ValueSelectContainer.this.dropColumnHere(item.name, location);
            }
        });
    }

    public void addToTopPanel(JPanel panel, Object layout) {
        this.topPanel.add((Component)panel, layout);
    }

    public void doResizeComponent() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            Dimension d = this.widgets.get(i).getMaximumSize();
            Dimension d2 = this.widgets.get(i).getSize();
            d.height = this.rootPanel.getHeight() - 5;
            d2.height = this.rootPanel.getHeight() - 5;
            this.widgets.get(i).setMaximumSize(d);
            this.widgets.get(i).setPreferredSize(d2);
        }
        this.updateUI();
    }

    protected boolean dropColumnHere(String column, Point location) {
        ValueSelectWidget widget = this.mapWidget.get(column);
        if (widget != null) {
            return false;
        }
        int index = this.judgeInsertIndex(location.x);
        this.addWidget(column, index);
        this.layoutUI();
        return false;
    }

    private int judgeInsertIndex(int x) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            double location = this.widgets.get(i).getBounds().getCenterX();
            if (i == 0 && (double)x < location) {
                return 0;
            }
            if (!((double)x < location)) continue;
            return i;
        }
        return this.widgets.size();
    }

    public void addWidget(String column, int index) {
        ValueSelectWidget widget = new ValueSelectWidget(this, this.dataModel, column);
        new PanelDropTarget((JComponent)widget.getKDList(), new PanelDropTarget.DropCallBack(){

            @Override
            public boolean drop(ColumnItem item, Point location) {
                return ValueSelectContainer.this.dropColumnHere(item.name, location);
            }
        });
        this.widgets.add(index, widget);
        this.mapWidget.put(column, widget);
    }

    public void addWidget(String column) {
        ValueSelectWidget widget = new ValueSelectWidget(this, this.dataModel, column);
        new PanelDropTarget((JComponent)((Object)widget), new PanelDropTarget.DropCallBack(){

            @Override
            public boolean drop(ColumnItem item, Point location) {
                return ValueSelectContainer.this.dropColumnHere(item.name, location);
            }
        });
        new PanelDropTarget((JComponent)widget.getKDList(), new PanelDropTarget.DropCallBack(){

            @Override
            public boolean drop(ColumnItem item, Point location) {
                return ValueSelectContainer.this.dropColumnHere(item.name, location);
            }
        });
        this.widgets.add(widget);
        this.mapWidget.put(column, widget);
    }

    public void removeWidget(String column) {
        ValueSelectWidget widget = this.mapWidget.remove(column);
        this.widgets.remove((Object)widget);
        this.layoutUI();
    }

    public ValueSelectWidget getWidget(String column) {
        return this.mapWidget.get(column);
    }

    public void removeAllWidgets() {
        this.widgets.clear();
        this.mapWidget.clear();
        this.layoutUI();
    }

    public String[] getColumns() {
        if (this.widgets.size() == 0) {
            return null;
        }
        String[] columns = new String[this.widgets.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.widgets.get(i).getDimensionName();
        }
        return columns;
    }

    public void setSelectedValues(String column, Object[] values) {
        ValueSelectWidget widget = this.getWidget(column);
        if (widget != null) {
            widget.setSelectdValues(values);
        }
    }

    public void setWidgetIcon(ValueSelectWidget widget, Icon icon) {
        widget.setIcon(icon);
    }

    public void setWidgetBackground(ValueSelectWidget widget, Color color) {
        widget.setTableBackground(color);
    }

    public void layoutUI() {
        this.rootPanel.setLayout(new GridBagLayout());
        this.rootPanel.removeAll();
        this.rootPanel.setBackground(Color.WHITE);
        this.rootPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        int i = 0;
        while (i < this.widgets.size()) {
            ValueSelectWidget widget = this.widgets.get(i);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 0;
            gc.gridx = i++;
            gc.gridheight = 0;
            gc.insets = new Insets(0, 4, 0, 0);
            gc.fill = 3;
            gc.anchor = 18;
            this.rootPanel.add((Component)((Object)widget), gc);
        }
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = this.widgets.size();
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 2;
        gc.anchor = 14;
        JPanel panel = new JPanel();
        panel.setOpaque(true);
        panel.setBackground(Color.WHITE);
        this.rootPanel.add((Component)panel, gc);
        this.updateUI();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    public void valueChangeCallback() {
        if (this.valueChangeCallback != null) {
            this.valueChangeCallback.callback();
        }
    }

    public void setValueChangeCallback(ConditionChangeCallback valueChangeCallback) {
        this.valueChangeCallback = valueChangeCallback;
    }
}

