/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.excelui;

import com.kingdee.bos.streamwork.pivot.Location;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItem;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItemListener;
import com.kingdee.bos.streamwork.pivot.excelui.FilterItemPanel;
import com.kingdee.bos.streamwork.pivot.excelui.WidgetListener;
import com.kingdee.bos.streamwork.pivot.excelui.dnd.ComponentDragSource;
import com.kingdee.bos.streamwork.pivot.excelui.dnd.PanelDropTarget;
import com.kingdee.bos.streamwork.pivot.model.DataModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class FilterItemWidget
extends JPanel
implements DragGestureListener {
    private List<CheckedItem> checkedItems = new ArrayList<CheckedItem>();
    private Map<String, FilterItemPanel> checkedItemPanels = new HashMap<String, FilterItemPanel>();
    private MyCheckedItemListener checkedItemListener = new MyCheckedItemListener();
    JScrollPane scrollPane;
    JPanel rootPanel;
    private DataModel dataModel;
    boolean doDropTarget = false;
    private DropEndCallBack dropEndCallBack = new DropEndCallBack();
    private DropCallBack dropCallBack = new DropCallBack();
    private WidgetListener listener;

    public FilterItemWidget(DataModel dataModel) {
        this.dataModel = dataModel;
        this.setLayout(new BorderLayout());
        this.rootPanel = new JPanel();
        this.scrollPane = new JScrollPane(this.rootPanel);
        this.add((Component)new JLabel("\u8bf7\u5c06\u7b5b\u9009\u5b57\u6bb5\u62d6\u5230\u6b64\u5904"), "North");
        LineBorder border = new LineBorder(Color.GRAY);
        JPanel scrollPaneContainer = new JPanel();
        scrollPaneContainer.setLayout(new BorderLayout());
        scrollPaneContainer.add((Component)this.scrollPane, "Center");
        scrollPaneContainer.setBorder(border);
        this.add((Component)scrollPaneContainer, "Center");
        this.setCheckedItems(new String[0]);
    }

    public void setCheckedItems(String[] checkedItemNames) {
        ArrayList<CheckedItem> list = new ArrayList<CheckedItem>();
        for (int i = 0; i < checkedItemNames.length; ++i) {
            list.add(this.createCheckedItem(checkedItemNames[i]));
        }
        this.setCheckedItems(list);
    }

    private CheckedItem createCheckedItem(String name) {
        CheckedItem item = new CheckedItem(name);
        item.location = Location.FILTERITEM;
        return item;
    }

    public void setCheckedItems(List<CheckedItem> checkedItems) {
        this.checkedItems.clear();
        this.checkedItems.addAll(checkedItems);
        this.checkedItemPanels.clear();
        for (int i = 0; i < checkedItems.size(); ++i) {
            CheckedItem item = checkedItems.get(i);
            FilterItemPanel panel = this.createFilterItemPanel(item);
            this.checkedItemPanels.put(item.name, panel);
        }
        this.layoutUI();
        this.updateUI();
    }

    private FilterItemPanel createFilterItemPanel(CheckedItem item) {
        FilterItemPanel panel = new FilterItemPanel(this.dataModel, item);
        panel.addListener(this.checkedItemListener);
        new ComponentDragSource(panel, 2, this.dropEndCallBack);
        return panel;
    }

    public String[] getAllCheckedItemNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (CheckedItem item : this.checkedItems) {
            ret.add(item.name);
        }
        return ret.toArray(new String[0]);
    }

    public CheckedItem[] getAllCheckedItems() {
        ArrayList<CheckedItem> ret = new ArrayList<CheckedItem>();
        for (CheckedItem item : this.checkedItems) {
            ret.add(item);
        }
        return ret.toArray(new CheckedItem[0]);
    }

    public void addCheckedItem(String name) {
        ArrayList<CheckedItem> checkedItems = new ArrayList<CheckedItem>();
        checkedItems.addAll(this.checkedItems);
        checkedItems.add(this.createCheckedItem(name));
        this.setCheckedItems(checkedItems);
    }

    public void removeCheckedItem(String name) {
        ArrayList<CheckedItem> ret = new ArrayList<CheckedItem>();
        for (int i = 0; i < this.checkedItems.size(); ++i) {
            CheckedItem item = this.checkedItems.get(i);
            if (this.checkedItems.get((int)i).name.equals(name)) continue;
            ret.add(item);
        }
        if (ret.size() != this.checkedItems.size()) {
            this.setCheckedItems(ret);
        }
    }

    public boolean dndAddCheckedItemPanel(CheckedItem item, Point location) {
        ArrayList<CheckedItem> orderedCheckedItem = new ArrayList<CheckedItem>();
        TreeMap<Integer, CheckedItem> map = new TreeMap<Integer, CheckedItem>();
        boolean inSamePane = false;
        int n = this.checkedItems.size();
        for (int i = 0; i < n; ++i) {
            FilterItemPanel p = this.checkedItemPanels.get(this.checkedItems.get((int)i).name);
            Rectangle r = p.getBounds();
            if (!item.name.equals(p.item.name)) {
                map.put((int)r.getCenterY(), p.item);
                continue;
            }
            map.put(location.y, p.item);
            inSamePane = true;
        }
        if (!inSamePane) {
            map.put(location.y, this.createCheckedItem(item.name));
        }
        orderedCheckedItem.addAll(map.values());
        if (inSamePane) {
            boolean sameOrder = false;
            for (int i = 0; i < orderedCheckedItem.size(); ++i) {
                if (orderedCheckedItem.get((int)i).name.equals(this.checkedItems.get((int)i).name)) continue;
                sameOrder = false;
                break;
            }
            if (!sameOrder) {
                this.setCheckedItems(orderedCheckedItem);
                if (this.listener != null) {
                    this.listener.itemMoved(item);
                }
            }
        } else {
            this.setCheckedItems(orderedCheckedItem);
            if (this.listener != null) {
                this.listener.itemAdded(item);
            }
        }
        return !inSamePane;
    }

    public void dndRemoveCheckedItemPanel(CheckedItem item) {
        ArrayList<CheckedItem> orderedCheckedItem = new ArrayList<CheckedItem>();
        boolean found = false;
        int n = this.checkedItems.size();
        for (int i = 0; i < n; ++i) {
            if (this.checkedItems.get(i) != item) {
                orderedCheckedItem.add(this.checkedItems.get(i));
                continue;
            }
            found = true;
        }
        if (found) {
            this.setCheckedItems(orderedCheckedItem);
            if (this.listener != null) {
                this.listener.itemRemoved(item);
            }
        }
    }

    private void layoutUI() {
        JPanel panel;
        this.rootPanel.setLayout(new GridBagLayout());
        this.rootPanel.removeAll();
        this.rootPanel.setBackground(Color.WHITE);
        this.rootPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        int i = 0;
        while (i < this.checkedItems.size()) {
            panel = this.checkedItemPanels.get(this.checkedItems.get((int)i).name);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = i++;
            gc.gridx = 0;
            gc.gridwidth = 0;
            gc.weightx = 1.0;
            gc.insets = new Insets(1, 0, 0, 0);
            gc.fill = 2;
            gc.anchor = 18;
            this.rootPanel.add((Component)panel, gc);
        }
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = this.checkedItems.size();
        gc.gridx = 0;
        gc.gridwidth = 0;
        gc.gridheight = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 10;
        gc.anchor = 16;
        panel = new JPanel();
        panel.setOpaque(true);
        panel.setBackground(Color.WHITE);
        this.rootPanel.add((Component)panel, gc);
        if (!this.doDropTarget) {
            new PanelDropTarget(this.rootPanel, this.dropCallBack);
            this.doDropTarget = true;
        }
    }

    public void setWidgetListener(WidgetListener l) {
        this.listener = l;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    public CheckedItem getCheckedItemByName(String name) {
        return this.checkedItemPanels.get((Object)name).item;
    }

    public void refreshFilterIcon() {
        Iterator<FilterItemPanel> iter = this.checkedItemPanels.values().iterator();
        while (iter.hasNext()) {
            iter.next().refreshFilterIcon();
        }
    }

    private class DropCallBack
    implements PanelDropTarget.DropCallBack {
        private DropCallBack() {
        }

        @Override
        public boolean drop(CheckedItem item, Point location) {
            boolean b = FilterItemWidget.this.dndAddCheckedItemPanel(item, location);
            FilterItemWidget.this.validate();
            return b;
        }
    }

    private class DropEndCallBack
    implements ComponentDragSource.DropCallBack {
        private DropEndCallBack() {
        }

        @Override
        public void dropEnd(Component c) {
            FilterItemPanel p = (FilterItemPanel)c;
            Container parent = p.getParent();
            FilterItemWidget.this.dndRemoveCheckedItemPanel(p.item);
            if (parent != null) {
                parent.validate();
            }
            FilterItemWidget.this.validate();
            FilterItemWidget.this.getParent().doLayout();
        }
    }

    private class MyCheckedItemListener
    implements CheckedItemListener {
        private MyCheckedItemListener() {
        }

        @Override
        public void menuClicked(CheckedItem item) {
            if (FilterItemWidget.this.listener != null) {
                FilterItemWidget.this.listener.menuClicked(item);
            }
        }

        @Override
        public void selected(CheckedItem item, boolean selected) {
        }
    }
}

