/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.excelui;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.excelui.MeasureProperty;
import com.kingdee.bos.streamwork.pivot.excelui.MeasuresTable;
import com.kingdee.bos.streamwork.pivot.model.DataModelSupport;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import com.kingdee.bos.streamwork.pivot.resource.Icons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;

public class MeasureWidget2
extends KDPanel {
    private DataModelSupport dataModelSupport;
    private KDLabel labName;
    private MeasuresTable table;
    private KDScrollPane scrollPane;
    private KDLabel labResizeTag;
    private KDPanel panFoot;
    private static final Cursor CURSOR_DEFAULT = Cursor.getDefaultCursor();
    private static final Cursor CURSOR_RESIZE = Cursor.getPredefinedCursor(5);
    private static final Cursor CURSOR_MOVE = Cursor.getPredefinedCursor(13);
    private static final Cursor CURSOR_DRAG = Toolkit.getDefaultToolkit().createCustomCursor(Icons.createImage("icon/cursors/mos_movedrop.gif"), new Point(0, 0), "CanDrop");
    private static final Cursor CURSOR_FORBID = Toolkit.getDefaultToolkit().createCustomCursor(Icons.createImage("icon/cursors/cursor_lock.gif"), new Point(0, 0), "Forbid");
    MeasureProperty measureProperty;

    public MeasureWidget2(DataModelSupport dataModelSupport) {
        this.dataModelSupport = dataModelSupport;
        this.initUI();
    }

    public void initUI() {
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.labName = new KDLabel("\u6307\u6807");
        this.labName.setPreferredSize(new Dimension(1, 20));
        this.labName.setOpaque(true);
        this.setMouseIcon((JComponent)this.labName, CURSOR_MOVE);
        this.labResizeTag = new KDLabel();
        this.labResizeTag.setIcon((Icon)Icons.createIcon("icon/resize.gif"));
        this.labResizeTag.setPreferredSize(new Dimension(15, 14));
        this.labResizeTag.setHorizontalAlignment(2);
        this.labResizeTag.setVerticalAlignment(1);
        this.setMouseIcon((JComponent)this.labResizeTag, CURSOR_RESIZE);
        this.initTable();
        this.refreshField();
        this.scrollPane = new KDScrollPane((Component)this.table);
        this.panFoot = new KDPanel((LayoutManager)new BorderLayout());
        this.panFoot.add((Component)new KDSeparator(), (Object)"North");
        this.panFoot.add((Component)this.labResizeTag, (Object)"East");
        this.setLayout(new BorderLayout());
        this.add((Component)this.labName, "North");
        this.add((Component)this.scrollPane, "Center");
        this.measureProperty = new MeasureProperty(PivotUtils.getMainFrame());
        this.initDefaultCondition();
        this.installListener();
    }

    private void initTable() {
        this.table = new MeasuresTable();
    }

    private void initDefaultCondition() {
        Measure[] measures = this.dataModelSupport.getMeasures();
        ArrayList<Measure> selectedMeasures = new ArrayList<Measure>();
        for (int i = 0; i < measures.length; ++i) {
            String column = measures[i].name;
            if (!this.dataModelSupport.isMeasureSelected(column)) continue;
            selectedMeasures.add(measures[i]);
        }
        this.table.setSelectedMeasures(selectedMeasures);
    }

    public void refreshField() {
        Measure[] measures = this.dataModelSupport.getMeasures();
        this.table.setMeasures(Arrays.asList(measures));
    }

    private void installListener() {
        this.table.setSelectListener(new MeasuresTable.SelectListener(){

            @Override
            public void selectedChanged(Measure[] measures) {
                MeasureWidget2.this.measureSelected(measures);
            }

            @Override
            public void measureAggTypeChanged(Measure measure) {
                MeasureWidget2.this.measureAggTypeChanged(measure);
            }
        });
    }

    private void measureAggTypeChanged(Measure measure) {
        this.dataModelSupport.measureArgTypeChanged(measure.name, measure.aggType);
    }

    private void measureSelected(Measure[] values) {
        if (values.length == 0) {
            this.dataModelSupport.setSelectedMeasures(null);
        } else {
            String[] columns = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                columns[i] = values[i].name;
            }
            this.dataModelSupport.setSelectedMeasures(columns);
        }
    }

    private void setMouseIcon(JComponent source, Cursor cs) {
        if (source.getCursor() != cs) {
            source.setCursor(cs);
        }
    }

    private void selectTable() {
    }

    public static Dimension caculateDefaultSize(DataModelSupport dataModelSupport, String column) {
        int fieldCount = dataModelSupport.getColumnValues(column).getValues().size();
        if (fieldCount < 2) {
            fieldCount = 2;
        }
        if (fieldCount > 10) {
            fieldCount = 10;
        }
        int w = 80 + fieldCount * 5;
        int h = fieldCount * 20 + 46;
        return new Dimension(w, h);
    }

    public void setIcon(Icon icon) {
        this.labName.setIcon(icon);
    }

    public void setTableBackground(Color color) {
        this.labName.setBackground(color);
        this.labResizeTag.setBackground(color);
        this.panFoot.setBackground(color);
    }
}

