/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.excelui;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.streamwork.pivot.model.ColumnValues;
import com.kingdee.bos.streamwork.pivot.model.DataModel;
import com.kingdee.bos.streamwork.pivot.resource.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class MemberSelectTreePanel
extends KDPanel {
    public static int TYPE_NOTSHOW = 0;
    public static int TYPE_ONFILTER = 1;
    public static int TYPE_ONROWCOLUMN = 2;
    private String column;
    private int type;
    private Icon emptyIcon;
    private KDTree tree;
    private boolean onSet = false;
    AllNodeNotCheckedCallback allNodeNotCheckedCallback;
    DefaultKingdeeTreeNode root;
    DefaultKingdeeTreeNode allNode;
    DefaultKingdeeTreeNode nullNode;

    public MemberSelectTreePanel() {
        this.initUI();
        this.emptyIcon = Icons.createEmptyIcon();
    }

    private void initUI() {
        this.tree = new KDTree(true);
        this.tree.setRootVisible(false);
        this.tree.setAutoscrolls(true);
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane((Component)this.tree), "Center");
        this.tree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                if (MemberSelectTreePanel.this.onSet) {
                    return;
                }
                MemberSelectTreePanel.this.onSet = true;
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
                MemberSelectTreePanel.this.nodeChecked(node);
                MemberSelectTreePanel.this.onSet = false;
            }
        });
    }

    public void showForItem(DataModel dataModel, String column, int type) {
        this.column = column;
        this.type = type;
        this.tree.setModel((TreeModel)this.createModel(dataModel));
    }

    protected void nodeChecked(DefaultKingdeeTreeNode node) {
        if (node == this.allNode) {
            this.setAllNodeChecked(node.isChecked());
        } else {
            this.allNode.setChecked(this.allNodeChecked());
        }
        this.setStatus(this.allNodeNotChecked());
        this.updateUI();
    }

    private void setStatus(boolean allNodeNotChecked) {
        if (this.allNodeNotCheckedCallback != null) {
            this.allNodeNotCheckedCallback.callback(allNodeNotChecked);
        }
    }

    private boolean allNodeChecked() {
        int n = this.root.getChildCount();
        for (int i = 1; i < n; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.root.getChildAt(i);
            if (node.isChecked()) continue;
            return false;
        }
        return true;
    }

    private boolean allNodeNotChecked() {
        int n = this.root.getChildCount();
        for (int i = 1; i < n; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.root.getChildAt(i);
            if (!node.isChecked()) continue;
            return false;
        }
        return true;
    }

    private void setAllNodeChecked(boolean checked) {
        int n = this.root.getChildCount();
        for (int i = 1; i < n; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.root.getChildAt(i);
            node.setChecked(checked);
        }
    }

    public KingdeeTreeModel createModel(DataModel dataModel) {
        this.root = new DefaultKingdeeTreeNode((Object)"root");
        ColumnValues cv = dataModel.getColumnValues(this.column);
        List selectedValues = dataModel.getSelectedValues(this.column);
        this.allNode = new DefaultKingdeeTreeNode((Object)"\u5168\u9009");
        this.allNode.setCustomIcon(this.emptyIcon);
        this.allNode.setCustomOpenIcon(this.emptyIcon);
        this.allNode.setCustomClosedIcon(this.emptyIcon);
        this.root.add((MutableTreeNode)this.allNode);
        for (Object v : cv.getValues()) {
            boolean selected = selectedValues == null || selectedValues.isEmpty() || selectedValues.contains(v);
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode(v, null, selected, false);
            node.setCustomIcon(this.emptyIcon);
            node.setCustomOpenIcon(this.emptyIcon);
            node.setCustomClosedIcon(this.emptyIcon);
            node.setAllowsChildren(false);
            this.root.add((MutableTreeNode)node);
        }
        if (cv.hasNull()) {
            String v = "(\u7a7a\u767d)";
            boolean selected = selectedValues == null || selectedValues.isEmpty() || selectedValues.contains(v);
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)v, null, selected, false);
            this.root.add((MutableTreeNode)node);
            node.setCustomIcon(this.emptyIcon);
            node.setCustomOpenIcon(this.emptyIcon);
            node.setCustomClosedIcon(this.emptyIcon);
        }
        if (selectedValues == null || selectedValues.isEmpty()) {
            this.allNode.setChecked(true);
        }
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)this.root);
        return model;
    }

    public List getSelectedValues() {
        if (this.allNode.isChecked()) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int n = this.root.getChildCount();
        for (int i = 1; i < n; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.root.getChildAt(i);
            if (!node.isChecked()) continue;
            list.add(node.getUserObject());
        }
        return list;
    }

    public static interface AllNodeNotCheckedCallback {
        public void callback(boolean var1);
    }
}

