/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.excelui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public class MenuIcon
implements Icon,
SwingConstants {
    private int iconSize;

    public MenuIcon() {
        this(16);
    }

    public MenuIcon(int iconSize) {
        this.iconSize = iconSize;
    }

    @Override
    public int getIconWidth() {
        return this.iconSize;
    }

    @Override
    public int getIconHeight() {
        return this.iconSize;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.paint(g, x, y, false);
    }

    public void paint(Graphics g, int x, int y, boolean paintBound) {
        this.paintTriangle(g, x, y, this.iconSize, 5);
        if (paintBound) {
            this.paintFloatBound(g, x, y, this.iconSize);
        }
    }

    private void paintFloatBound(Graphics g, int x, int y, int size) {
        Color oldColor = g.getColor();
        g.setColor(Color.WHITE);
        int[] xPoints = new int[]{(x -= 4) + (size += 8) - 1, x, x, x + 1, x + 1, x + size - 1};
        int[] yPoints = new int[]{y -= 4, y, y + size, y + size, y + 1, y + 1};
        g.fillPolygon(xPoints, yPoints, 6);
        g.setColor(Color.GRAY);
        xPoints = new int[]{x + size - 1, x + size - 1, x + 1, x + 1, x + size, x + size};
        yPoints = new int[]{y, y + size - 1, y + size - 1, y + size, y + size, y};
        g.fillPolygon(xPoints, yPoints, 6);
        g.setColor(oldColor);
    }

    private void paintTriangle(Graphics g, int x, int y, int size, int direction) {
        Color oldColor = g.getColor();
        int j = 0;
        size = Math.max(size, 2);
        int mid = size / 2 - 1;
        g.translate(x, y);
        switch (direction) {
            case 1: {
                for (int i = 0; i < size; ++i) {
                    g.drawLine(mid - i, i, mid + i, i);
                }
                break;
            }
            case 5: {
                j = 0;
                for (int i = size - 1; i >= 0; --i) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < size; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                }
                break;
            }
            case 3: {
                j = 0;
                for (int i = size - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

