/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.execute;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.def.CalculatedMemberDef;
import com.kingdee.bos.streamwork.cuba.def.CubeDef;
import com.kingdee.bos.streamwork.cuba.def.DimensionUsageDef;
import com.kingdee.bos.streamwork.cuba.def.HierarchyDef;
import com.kingdee.bos.streamwork.cuba.def.LevelDef;
import com.kingdee.bos.streamwork.cuba.def.MeasureDef;
import com.kingdee.bos.streamwork.cuba.def.ParameterDef;
import com.kingdee.bos.streamwork.cuba.def.PropertyDef;
import com.kingdee.bos.streamwork.cuba.def.SharedDimensionDef;
import com.kingdee.bos.streamwork.cuba.impl.ConnectionImpl;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.FunCall;
import com.kingdee.bos.streamwork.cuba.mdx.SchemaReader;
import com.kingdee.bos.streamwork.cuba.mdx.Syntax;
import com.kingdee.bos.streamwork.cuba.mdx.elementexp.MemberExpr;
import com.kingdee.bos.streamwork.cuba.util.UniqueNameUtil;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.pivot.execute.CubeBuilder;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import java.util.ArrayList;

public abstract class CubaBuilderBase
implements CubeBuilder {
    static final String NAME_SUB_TOTAL = "(\u5c0f\u8ba1)";
    static final String NAME_TOTAL = "(\u5408\u8ba1)";
    protected DataSource dataSource;
    protected QueryModel queryModel;
    ConnectionImpl con;

    public CubaBuilderBase(DataSource dataSource, QueryModel queryModel) {
        this.dataSource = dataSource;
        this.queryModel = queryModel;
    }

    protected void buildCalculatedMemberDef(CalculatedMemberDef cm, Metric metric) {
        cm.dimension = "Measures";
        cm.formula = metric.getFormular(this.queryModel);
        cm.name = metric.getName();
        cm.caption = metric.getCaption();
        cm.formatString = metric.getFormatString(this.queryModel.scale);
    }

    protected Exp createMeasuresExp(SchemaReader schemaReader) throws CUBAException {
        Exp[] all = new Exp[this.queryModel.measures.length];
        for (int i = 0; i < this.queryModel.measures.length; ++i) {
            all[i] = this.createMeasureExp(schemaReader, this.queryModel.measures[i].getId());
        }
        return new FunCall("{}", all, Syntax.Braces);
    }

    protected Exp createMeasureExp(SchemaReader schemaReader, String name) throws CUBAException {
        String uniqueName = UniqueNameUtil.createUniqueName(new String[]{"Measures", name});
        Member member = schemaReader.getMemberByUniqueName(schemaReader.getCubes()[0], uniqueName);
        return new MemberExpr(member);
    }

    protected String getMeasuresMembersMdx() {
        String measuresMdx = "{";
        for (int i = 0; i < this.queryModel.measures.length; ++i) {
            Measure measure = this.queryModel.measures[i];
            if (i > 0) {
                measuresMdx = measuresMdx + ",";
            }
            measuresMdx = measuresMdx + "Measures.[" + measure.getId() + "]";
        }
        measuresMdx = measuresMdx + "}";
        return measuresMdx;
    }

    protected void buildCubeMeasureDefs(CubeDef cubeDef) {
        ArrayList<MeasureDef> cubeMeasures = new ArrayList<MeasureDef>();
        ArrayList<CalculatedMemberDef> cubeCalculatedMembers = new ArrayList<CalculatedMemberDef>();
        for (Measure measure : this.queryModel.measures) {
            if (measure.isMetric) {
                CalculatedMemberDef cm = new CalculatedMemberDef();
                cubeCalculatedMembers.add(cm);
                this.buildCalculatedMemberDef(cm, measure.metric);
                continue;
            }
            MeasureDef measureDef = new MeasureDef();
            cubeMeasures.add(measureDef);
            this.buildMeasureDef(measureDef, measure);
        }
        cubeDef.measures = cubeMeasures.toArray(new MeasureDef[0]);
        if (cubeCalculatedMembers.size() > 0) {
            cubeDef.calculatedMembers = cubeCalculatedMembers.toArray(new CalculatedMemberDef[0]);
        }
    }

    protected void buildMeasureDef(MeasureDef measureDef, Measure measure) {
        measureDef.column = measure.name;
        measureDef.name = measure.getId();
        measureDef.caption = measure.getCaption();
        int scale = this.queryModel.scale;
        String fAmount = "#,###";
        if (scale > 0) {
            fAmount = fAmount + ".";
            for (int i = 0; i < scale; ++i) {
                fAmount = fAmount + "0";
            }
        }
        String fQuantity = "#,###";
        String fmt = fAmount;
        if (measure.dataType == 0) {
            fmt = fQuantity;
        }
        switch (measure.aggType) {
            case 0: {
                measureDef.formatString = fmt;
                measureDef.aggregator = "sum";
                break;
            }
            case 1: {
                measureDef.formatString = fAmount;
                measureDef.aggregator = "avg";
                break;
            }
            case 2: {
                measureDef.formatString = fmt;
                measureDef.aggregator = "max";
                break;
            }
            case 3: {
                measureDef.formatString = fmt;
                measureDef.aggregator = "min";
                break;
            }
            case 4: {
                measureDef.formatString = fQuantity;
                measureDef.aggregator = "count";
                break;
            }
            case 5: {
                measureDef.formatString = fQuantity;
                measureDef.aggregator = "count";
            }
        }
    }

    protected void buildDimParam(ParameterDef paramDef, String name) {
        paramDef.name = name;
        paramDef.type = "Table";
    }

    protected void buildDimUsage(DimensionUsageDef usageDef, String name) {
        usageDef.name = name;
        usageDef.foreignKey = name;
    }

    protected void buildDim(SharedDimensionDef dimDef, String name) {
        dimDef.name = name;
        HierarchyDef hieDef = new HierarchyDef();
        dimDef.table = name;
        dimDef.primaryKey = name;
        dimDef.hierarchies = new HierarchyDef[]{hieDef};
        LevelDef levelDef = new LevelDef();
        levelDef.name = dimDef.name;
        levelDef.column = dimDef.name;
        PropertyDef propertyDef = new PropertyDef();
        propertyDef.name = "name";
        propertyDef.column = levelDef.column;
        levelDef.properties = new PropertyDef[]{propertyDef};
        hieDef.levels = new LevelDef[]{levelDef};
    }
}

