/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.execute;

import com.kingdee.bos.streamwork.cuba.CUBAConfig;
import com.kingdee.bos.streamwork.cuba.CUBADatabase;
import com.kingdee.bos.streamwork.cuba.CUBAEngine;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.MdxResult;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.dbsource.ArrayTable;
import com.kingdee.bos.streamwork.cuba.dbsource.Table;
import com.kingdee.bos.streamwork.cuba.def.CubeDef;
import com.kingdee.bos.streamwork.cuba.def.DimensionUsageDef;
import com.kingdee.bos.streamwork.cuba.def.HierarchyDef;
import com.kingdee.bos.streamwork.cuba.def.LevelDef;
import com.kingdee.bos.streamwork.cuba.def.MeasureDef;
import com.kingdee.bos.streamwork.cuba.def.ParameterDef;
import com.kingdee.bos.streamwork.cuba.def.PropertyDef;
import com.kingdee.bos.streamwork.cuba.def.SchemaDef;
import com.kingdee.bos.streamwork.cuba.def.SharedDimensionDef;
import com.kingdee.bos.streamwork.cuba.impl.ConnectionImpl;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.FunCall;
import com.kingdee.bos.streamwork.cuba.mdx.MdxQuery;
import com.kingdee.bos.streamwork.cuba.mdx.QueryAxis;
import com.kingdee.bos.streamwork.cuba.mdx.SchemaReader;
import com.kingdee.bos.streamwork.cuba.mdx.Syntax;
import com.kingdee.bos.streamwork.cuba.mdx.elementexp.DimensionExpr;
import com.kingdee.bos.streamwork.cuba.mdx.elementexp.MemberExpr;
import com.kingdee.bos.streamwork.cuba.util.UniqueNameUtil;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.pivot.model.Dimension;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import com.kingdee.bos.streamwork.pivot.model.MemberSelection;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CubaBuilderForEASPivot {
    private static final Logger logger = Logger.getLogger(CubaBuilderForEASPivot.class);
    private static final String NAME_SUB_TOTAL = "(\u5c0f\u8ba1)";
    private static final String NAME_TOTAL = "(\u5408\u8ba1)";
    private DataSource dataSource;
    private QueryModel queryModel;
    ConnectionImpl con;
    private HashMap tableParams;
    TreeMap<Integer, String> dimSize = new TreeMap();

    public CubaBuilderForEASPivot(DataSource dataSource, QueryModel queryModel) {
        this.dataSource = dataSource;
        this.queryModel = queryModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdxResult buildMdxResult() throws CUBAException, SQLException {
        long start = System.currentTimeMillis();
        this.buildCuba();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildCuba cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        start = System.currentTimeMillis();
        String mdx = this.buildMdx();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildMdx cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        start = System.currentTimeMillis();
        MdxQuery mdxQuery = this.con.parseQuery(mdx);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseQuery cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        if (this.queryModel.dimensions.length > 0) {
            start = System.currentTimeMillis();
            mdxQuery = this.processMdxQuery(mdxQuery, false);
            mdxQuery.resolve();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("processMdxQuery cost " + (System.currentTimeMillis() - start) + "ms."));
            }
        }
        start = System.currentTimeMillis();
        try {
            MdxResult mdxResult = this.con.executeMdxQuery(mdxQuery);
            return mdxResult;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("executeMdxQuery cost " + (System.currentTimeMillis() - start) + "ms."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdxResult buildMdxResultWhenConditionChanged(QueryModel queryModel) throws CUBAException, SQLException {
        this.queryModel = queryModel;
        long start = System.currentTimeMillis();
        String mdx = this.buildMdx();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildMdx cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        start = System.currentTimeMillis();
        MdxQuery mdxQuery = this.con.parseQuery(mdx);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseQuery cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        if (mdxQuery.getAxes().length == 2) {
            start = System.currentTimeMillis();
            mdxQuery = this.processMdxQuery(mdxQuery, false);
            mdxQuery.resolve();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("processMdxQuery cost " + (System.currentTimeMillis() - start) + "ms."));
            }
        }
        start = System.currentTimeMillis();
        try {
            MdxResult mdxResult = this.con.executeMdxQuery(mdxQuery);
            return mdxResult;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("executeMdxQuery cost " + (System.currentTimeMillis() - start) + "ms."));
            }
        }
    }

    private MdxQuery processMdxQuery(MdxQuery mdxQuery, boolean columnAxis) throws CUBAException {
        int i;
        QueryAxis[] axes = mdxQuery.getAxes();
        SchemaReader schemaReader = mdxQuery.getSchemaReader();
        Table factTable = (Table)this.tableParams.get("fact");
        factTable.close();
        String[] columnNames = new String[this.queryModel.dimensions.length];
        int[] columnIndexes = new int[this.queryModel.dimensions.length];
        ArrayList[] values = new ArrayList[columnIndexes.length];
        final HashMap[] valuePosMap = new HashMap[columnIndexes.length];
        HashMap[] nameToExps = new HashMap[columnIndexes.length];
        for (int i2 = 0; i2 < this.queryModel.dimensions.length; ++i2) {
            String column = this.queryModel.dimensions[i2].name;
            int index = factTable.getColumnIndex(column);
            columnNames[i2] = column;
            columnIndexes[i2] = index;
            values[i2] = new ArrayList();
            valuePosMap[i2] = new HashMap();
            nameToExps[i2] = new HashMap();
        }
        Object[] currentRow = null;
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        HashSet<TupleKey> rowSet = new HashSet<TupleKey>();
        long start = System.currentTimeMillis();
        while (factTable.next()) {
            currentRow = new Object[columnIndexes.length];
            for (int i3 = 0; i3 < columnIndexes.length; ++i3) {
                currentRow[i3] = factTable.getValue(columnIndexes[i3]);
                if (currentRow[i3] == null) continue;
                Integer idx = (Integer)valuePosMap[i3].get(currentRow[i3]);
                if (idx != null) {
                    currentRow[i3] = values[i3].get(idx);
                    continue;
                }
                values[i3].add(currentRow[i3]);
                valuePosMap[i3].put(currentRow[i3], values[i3].size() - 1);
            }
            TupleKey key = new TupleKey(currentRow);
            if (rowSet.contains(key)) continue;
            rows.add(currentRow);
            rowSet.add(new TupleKey(currentRow));
        }
        if (rows.isEmpty()) {
            return mdxQuery;
        }
        Object[] rowArray = rows.toArray();
        rowSet = null;
        rows = null;
        if (columnIndexes.length > 0) {
            Arrays.sort(rowArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Object[] v1 = (Object[])o1;
                    Object[] v2 = (Object[])o2;
                    for (int i = 0; i < v1.length; ++i) {
                        int idx2;
                        if (v1[i] == v2[i]) continue;
                        if (v1[i] == null && v2[i] != null) {
                            return 1;
                        }
                        if (v1[i] != null && v2[i] == null) {
                            return -1;
                        }
                        if (v1[i] == null || v2[i] == null) continue;
                        int idx1 = (Integer)valuePosMap[i].get(v1[i]);
                        if (idx1 > (idx2 = ((Integer)valuePosMap[i].get(v2[i])).intValue())) {
                            return 1;
                        }
                        if (idx1 >= idx2) continue;
                        return -1;
                    }
                    return 0;
                }
            });
        }
        long end = System.currentTimeMillis();
        start = System.currentTimeMillis();
        Exp[] lastTuple = null;
        Exp[] tuple = null;
        ArrayList<Exp> tuples = new ArrayList<Exp>();
        int[] timeCount = new int[]{0};
        boolean showSubTotal = columnAxis ? this.queryModel.showSubTotalOnColumn : this.queryModel.showSubTotalOnRow;
        boolean showTotal = columnAxis ? this.queryModel.showTotalOnColumn : this.queryModel.showTotalOnRow;
        for (int pos = 0; pos < rowArray.length; ++pos) {
            currentRow = (Object[])rowArray[pos];
            tuple = new Exp[columnIndexes.length];
            for (i = 0; i < currentRow.length; ++i) {
                tuple[i] = this.createMember(schemaReader, nameToExps[i], columnNames[i], currentRow[i], timeCount);
            }
            if (lastTuple == null) {
                tuples.add(this.createTupleFunCall(tuple));
            } else {
                Exp[] tuple2 = new Exp[columnIndexes.length];
                System.arraycopy(lastTuple, 0, tuple2, 0, tuple.length);
                for (int i4 = 0; i4 < currentRow.length - 1; ++i4) {
                    if (tuple[i4] == lastTuple[i4]) continue;
                    if (!showSubTotal) break;
                    for (int j = currentRow.length - 1; j > i4; --j) {
                        Exp[] tuple3 = new Exp[columnIndexes.length];
                        System.arraycopy(tuple2, 0, tuple3, 0, tuple.length);
                        for (int k = j; k < currentRow.length; ++k) {
                            tuple3[k] = this.createMember(schemaReader, nameToExps[k], columnNames[k], NAME_SUB_TOTAL, timeCount);
                        }
                        tuples.add(this.createTupleFunCall(tuple3));
                    }
                    break;
                }
                tuples.add(this.createTupleFunCall(tuple));
            }
            lastTuple = tuple;
        }
        if (columnIndexes.length > 1 && lastTuple != null) {
            Exp[] tuple2 = new Exp[columnIndexes.length];
            System.arraycopy(lastTuple, 0, tuple2, 0, tuple.length);
            if (showSubTotal) {
                for (int j = currentRow.length - 1; j > 0; --j) {
                    Exp[] tuple3 = new Exp[columnIndexes.length];
                    System.arraycopy(tuple2, 0, tuple3, 0, tuple.length);
                    for (int k = j; k < currentRow.length; ++k) {
                        tuple3[k] = this.createMember(schemaReader, nameToExps[k], columnNames[k], NAME_SUB_TOTAL, timeCount);
                    }
                    tuples.add(this.createTupleFunCall(tuple3));
                }
            }
        }
        if (lastTuple != null && showTotal) {
            Exp[] tuple3 = new Exp[columnIndexes.length];
            for (i = 0; i < columnIndexes.length; ++i) {
                tuple3[i] = this.createMember(schemaReader, nameToExps[i], columnNames[i], NAME_TOTAL, timeCount);
            }
            tuples.add(this.createTupleFunCall(tuple3));
        }
        FunCall funCall = new FunCall("{}", tuples.toArray(new Exp[0]), Syntax.Braces);
        if (columnAxis) {
            QueryAxis axis = mdxQuery.getAxes()[0];
            if (this.queryModel.measures.length > 1) {
                FunCall exp = new FunCall("crossjoin", new Exp[]{funCall, new FunCall("members", new Exp[]{new DimensionExpr(mdxQuery.getCube().getMeasureDimension())}, Syntax.Property)}, Syntax.Function);
                axis.setExp(exp);
            } else {
                axis.setExp(funCall);
            }
        } else {
            QueryAxis axis = mdxQuery.getAxes()[0];
            axis.setExp(funCall);
        }
        end = System.currentTimeMillis();
        factTable.close();
        return mdxQuery;
    }

    private Exp createTupleFunCall(Exp[] tuple) {
        return new FunCall("()", tuple, Syntax.Parentheses);
    }

    private Exp createMember(SchemaReader schemaReader, HashMap map, String dim, Object object, int[] timeCount) throws CUBAException {
        long start = System.currentTimeMillis();
        String name = null;
        name = object == null ? "V$NULL" : object.toString();
        Exp exp = (Exp)map.get(name);
        if (exp != null) {
            return exp;
        }
        String uniqueName = UniqueNameUtil.createUniqueName(new String[]{dim, name});
        Member member = schemaReader.getMemberByUniqueName(schemaReader.getCubes()[0], uniqueName);
        if (member == null) {
            throw new CUBAException("\u672a\u627e\u5230" + uniqueName);
        }
        exp = new MemberExpr(member);
        map.put(name, exp);
        timeCount[0] = (int)((long)timeCount[0] + (System.currentTimeMillis() - start));
        return exp;
    }

    private void buildCuba() throws CUBAException, SQLException {
        long start = System.currentTimeMillis();
        this.tableParams = this.buildTables();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildTables cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        start = System.currentTimeMillis();
        SchemaDef schemaDef = this.buildSchema(this.tableParams);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildSchema cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        CUBAEngine.setResource(Locale.CHINA, "measureDimensionCaption", "\u503c");
        CUBAEngine.setResource(Locale.CHINESE, "measureDimensionCaption", "\u503c");
        CUBAEngine.setResource(Locale.TRADITIONAL_CHINESE, "measureDimensionCaption", "\u503c");
        CUBAEngine.setResource(Locale.TAIWAN, "measureDimensionCaption", "\u503c");
        CUBAEngine.setResource(Locale.SIMPLIFIED_CHINESE, "measureDimensionCaption", "\u503c");
        start = System.currentTimeMillis();
        CUBAConfig config = new CUBAConfig();
        config.BUILD_AUTOJOINFACTSQL = false;
        config.BUILD_FACT_IGNORENULLOTHER = false;
        CUBADatabase database = CUBAEngine.buildWithoutCheck(schemaDef, this.tableParams, config);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildDatabase cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        this.con = new ConnectionImpl(database);
        this.con.setExecuteModel(1);
    }

    private String buildMdx() {
        String formula;
        int i;
        StringBuilder sb = new StringBuilder();
        HashMap<String, List<com.kingdee.bos.streamwork.pivot.model.Member>> mapMemSelection = new HashMap<String, List<com.kingdee.bos.streamwork.pivot.model.Member>>();
        MemberSelection[] mss = this.queryModel.memberSelections;
        if (mss != null) {
            for (int i2 = 0; i2 < mss.length; ++i2) {
                List<com.kingdee.bos.streamwork.pivot.model.Member> memberList = mss[i2].getMemberList();
                mapMemSelection.put(mss[i2].dimension.name, memberList);
            }
        }
        HashMap<String, String> withMembers = new HashMap<String, String>();
        StringBuilder selectOnRows = new StringBuilder();
        String caption1 = NAME_SUB_TOTAL;
        String caption2 = NAME_TOTAL;
        Dimension[] dims = this.queryModel.dimensionsOnRow;
        for (i = dims.length - 1; i >= 0; --i) {
            String allUniqueName = this.getMemberUniqueName(dims[i].name, "V$ALL");
            String calmember = this.getMemberUniqueName(dims[i].name, caption1);
            formula = allUniqueName;
            formula = "'" + formula + "'";
            withMembers.put(calmember, formula);
            String calmember2 = this.getMemberUniqueName(dims[i].name, caption2);
            String formula2 = this.getMemberUniqueName(dims[i].name, caption1);
            formula2 = "'" + formula2 + "'";
            withMembers.put(calmember2, formula2);
            String last = selectOnRows.toString();
            selectOnRows = new StringBuilder();
            selectOnRows.append("{");
            selectOnRows.append(this.getDimUniqueName(dims[i].name)).append(".members");
            if (dims.length == 1 && this.queryModel.measures.length > 0 && this.queryModel.showTotalOnRow) {
                selectOnRows.append(", (").append(this.getMemberUniqueName(dims[i].name, caption2)).append(")");
            } else if (i < dims.length - 1) {
                selectOnRows.append("*{").append(last);
                if (this.queryModel.showSubTotalOnRow) {
                    selectOnRows.append(",(");
                    for (int j = i + 1; j < dims.length; ++j) {
                        selectOnRows.append(this.getMemberUniqueName(dims[j].name, caption1));
                        if (j >= dims.length - 1) continue;
                        selectOnRows.append(",");
                    }
                    selectOnRows.append(")");
                }
                selectOnRows.append("}");
            }
            selectOnRows.append("}");
        }
        if (dims.length > 1 && this.queryModel.showTotalOnRow) {
            selectOnRows.append(", (");
            for (i = 0; i < dims.length; ++i) {
                selectOnRows.append(this.getMemberUniqueName(dims[i].name, caption2));
                if (i >= dims.length - 1) continue;
                selectOnRows.append(",");
            }
            selectOnRows.append(")");
        }
        if (!withMembers.isEmpty()) {
            sb.append("with ");
            for (Map.Entry entry : withMembers.entrySet()) {
                String name = (String)entry.getKey();
                formula = (String)entry.getValue();
                sb.append(" cache member ").append(name).append(" as ").append(formula);
            }
        }
        sb.append(" select ");
        if (this.queryModel.dimensionsOnRow.length > 0) {
            sb.append("{").append(selectOnRows.toString()).append("} on rows");
            if (this.queryModel.dimensionsOnColumn.length > 0 || this.queryModel.measures.length > 0) {
                sb.append(",");
            }
        }
        if (this.queryModel.measures.length > 0) {
            sb.append("  Measures.members");
        }
        if (this.queryModel.dimensionsOnColumn.length > 0 || this.queryModel.measures.length > 0) {
            sb.append(" on columns ");
        }
        sb.append(" from cuba");
        System.out.println(sb.toString());
        return sb.toString();
    }

    private String getDimUniqueName(String dim) {
        return UniqueNameUtil.makeUniqueName(dim);
    }

    private String getMemberUniqueName(String dim, String member) {
        if ("V$NULL".equals(member) || com.kingdee.bos.streamwork.pivot.model.Member.NULL_CAPTION.equals(member)) {
            member = "V$NULL";
        }
        return UniqueNameUtil.createUniqueName(new String[]{dim, member});
    }

    private HashMap buildTables() {
        int i;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fact", this.buildFactTable());
        HashMap<String, List<com.kingdee.bos.streamwork.pivot.model.Member>> msDims = new HashMap<String, List<com.kingdee.bos.streamwork.pivot.model.Member>>();
        if (this.queryModel.memberSelections != null) {
            for (i = 0; i < this.queryModel.memberSelections.length; ++i) {
                List<com.kingdee.bos.streamwork.pivot.model.Member> memberList = this.queryModel.memberSelections[i].getNonNullMemberList();
                if (memberList.isEmpty()) continue;
                msDims.put(this.queryModel.memberSelections[i].dimension.name, memberList);
            }
        }
        for (i = 0; i < this.queryModel.dimensions.length; ++i) {
            ArrayTable table = null;
            table = msDims.containsKey(this.queryModel.dimensions[i].name) ? this.buildDimTable(this.queryModel.dimensions[i].name, (List)msDims.get(this.queryModel.dimensions[i].name)) : this.buildDimTable(this.queryModel.dimensions[i].name);
            map.put(this.queryModel.dimensions[i].name, table);
            this.dimSize.put(-table.getRowCount(), this.queryModel.dimensions[i].name);
        }
        return map;
    }

    private ArrayTable buildDimTable(String name, List<com.kingdee.bos.streamwork.pivot.model.Member> memberList) {
        String[] header = new String[]{name};
        int[] dataTypes = new int[]{12};
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        boolean rowIndex = false;
        for (com.kingdee.bos.streamwork.pivot.model.Member member : memberList) {
            if (member.value == null) continue;
            values.add(new Object[]{member.value});
        }
        Object[][] values2 = new Object[values.size()][];
        values.toArray((T[])values2);
        return new ArrayTable(values2, header, dataTypes);
    }

    private ArrayTable buildDimTable(String name) {
        String[] header = new String[]{name};
        int[] dataTypes = new int[]{12};
        int columnIndex = Arrays.asList(this.dataSource.getColumnNames()).indexOf(name);
        int rowCount = this.dataSource.getRowCount();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < rowCount; ++i) {
            Object v = this.dataSource.getCell(columnIndex, i);
            if (v == null || set.contains(v)) continue;
            list.add(new Object[]{v});
            set.add(v);
        }
        set.clear();
        Object[][] values = (Object[][])list.toArray((T[])new Object[0][1]);
        return new ArrayTable(values, header, dataTypes);
    }

    private Object buildFactTable() {
        return new FactTable();
    }

    private SchemaDef buildSchema(HashMap tableParams) {
        SchemaDef schemaDef = new SchemaDef();
        schemaDef.caption = "cuba";
        schemaDef.name = "cuba";
        CubeDef cubeDef = new CubeDef();
        schemaDef.cubes = new CubeDef[]{cubeDef};
        cubeDef.name = "cuba";
        cubeDef.table = "fact";
        schemaDef.dimensions = new SharedDimensionDef[this.queryModel.dimensionsOnRow.length];
        cubeDef.dimensions = new DimensionUsageDef[this.queryModel.dimensionsOnRow.length];
        ArrayList<ParameterDef> paramList = new ArrayList<ParameterDef>();
        for (int i = 0; i < schemaDef.dimensions.length; ++i) {
            schemaDef.dimensions[i] = new SharedDimensionDef();
            this.buildDim(schemaDef.dimensions[i], this.queryModel.dimensionsOnRow[i]);
            DimensionUsageDef usageDef = new DimensionUsageDef();
            cubeDef.dimensions[i] = usageDef;
            this.buildDimUsage(usageDef, this.queryModel.dimensionsOnRow[i]);
            ParameterDef paramDef = new ParameterDef();
            this.buildDimParam(paramDef, this.queryModel.dimensionsOnRow[i]);
            paramList.add(paramDef);
        }
        ParameterDef factTableDef = new ParameterDef();
        factTableDef.name = "fact";
        factTableDef.type = "Table";
        paramList.add(factTableDef);
        schemaDef.parameters = paramList.toArray(new ParameterDef[0]);
        cubeDef.measures = new MeasureDef[this.queryModel.measures.length];
        for (int i = 0; i < this.queryModel.measures.length; ++i) {
            cubeDef.measures[i] = new MeasureDef();
            this.buildMeasureDef(cubeDef.measures[i], this.queryModel.measures[i]);
        }
        return schemaDef;
    }

    private void buildMeasureDef(MeasureDef measureDef, Measure measure) {
        measureDef.column = measure.name;
        measureDef.name = "\u884c\u8ba1\u6570".equals(measure.name) ? "V$COUNTMEASURE" : measure.getId();
        measureDef.caption = measure.getCaption();
        String fAmount = "#,###.00";
        String fQuantity = "#,###";
        if (measure.dataType == 0) {
            fAmount = "#,###";
        }
        switch (measure.aggType) {
            case 0: {
                measureDef.formatString = fAmount;
                measureDef.aggregator = "sum";
                break;
            }
            case 1: {
                measureDef.formatString = "#,###.00";
                measureDef.aggregator = "avg";
                break;
            }
            case 2: {
                measureDef.formatString = fAmount;
                measureDef.aggregator = "max";
                break;
            }
            case 3: {
                measureDef.formatString = fAmount;
                measureDef.aggregator = "min";
                break;
            }
            case 4: {
                measureDef.formatString = fQuantity;
                measureDef.aggregator = "count";
                break;
            }
            case 5: {
                measureDef.formatString = fQuantity;
                measureDef.aggregator = "count";
            }
        }
    }

    private void buildDimParam(ParameterDef paramDef, Dimension dimension) {
        paramDef.name = dimension.name;
        paramDef.type = "Table";
    }

    private void buildDimUsage(DimensionUsageDef usageDef, Dimension dimension) {
        usageDef.name = dimension.name;
        usageDef.foreignKey = dimension.name;
    }

    private void buildDim(SharedDimensionDef dimDef, Dimension dimension) {
        dimDef.name = dimension.name;
        HierarchyDef hieDef = new HierarchyDef();
        dimDef.table = dimension.name;
        dimDef.primaryKey = dimension.name;
        dimDef.hierarchies = new HierarchyDef[]{hieDef};
        LevelDef levelDef = new LevelDef();
        levelDef.name = dimDef.name;
        levelDef.column = dimDef.name;
        PropertyDef propertyDef = new PropertyDef();
        propertyDef.name = "name";
        propertyDef.column = levelDef.column;
        levelDef.properties = new PropertyDef[]{propertyDef};
        hieDef.levels = new LevelDef[]{levelDef};
    }

    class FactTable
    implements Table {
        String[] header;
        HashMap<String, Integer> indexMap = new HashMap();
        int[] dataTypes;
        int dataSourceRowCount;
        int columnCount;
        HashSet[] valuesSelectedList;
        private int cursor = -1;
        private Object[] row = null;

        public FactTable() {
            int i;
            this.header = CubaBuilderForEASPivot.this.dataSource.getColumnNames();
            this.columnCount = this.header.length;
            ArrayList<String> measureNames = new ArrayList<String>();
            for (i = 0; i < ((CubaBuilderForEASPivot)CubaBuilderForEASPivot.this).queryModel.measures.length; ++i) {
                measureNames.add(((CubaBuilderForEASPivot)CubaBuilderForEASPivot.this).queryModel.measures[i].name);
            }
            this.dataTypes = new int[this.header.length];
            for (i = 0; i < this.header.length; ++i) {
                String name = this.header[i];
                this.indexMap.put(name, i);
                this.dataTypes[i] = measureNames.contains(name) ? 2 : 12;
            }
            if (((CubaBuilderForEASPivot)CubaBuilderForEASPivot.this).queryModel.memberSelections != null) {
                this.valuesSelectedList = new HashSet[this.header.length];
                for (i = 0; i < ((CubaBuilderForEASPivot)CubaBuilderForEASPivot.this).queryModel.memberSelections.length; ++i) {
                    MemberSelection memberSelection = ((CubaBuilderForEASPivot)CubaBuilderForEASPivot.this).queryModel.memberSelections[i];
                    List<com.kingdee.bos.streamwork.pivot.model.Member> memberList = memberSelection.getMemberList();
                    int index = this.indexMap.get(memberSelection.dimension.name);
                    this.valuesSelectedList[index] = this.createSelectedList(memberList);
                }
            }
            this.dataSourceRowCount = CubaBuilderForEASPivot.this.dataSource.getRowCount();
        }

        public HashSet createSelectedList(List<com.kingdee.bos.streamwork.pivot.model.Member> memberList) {
            HashSet<Object> result = new HashSet<Object>();
            Iterator<com.kingdee.bos.streamwork.pivot.model.Member> iter = memberList.iterator();
            while (iter.hasNext()) {
                result.add(iter.next().value);
            }
            return result;
        }

        @Override
        public int getColumnCount() throws CUBAException {
            return this.header.length;
        }

        @Override
        public int getColumnType(int index) throws CUBAException {
            return this.dataTypes[index];
        }

        @Override
        public int getColumnIndex(String name) throws CUBAException {
            return this.indexMap.get(name);
        }

        @Override
        public String[] getColumnNames() throws CUBAException {
            return this.header;
        }

        @Override
        public boolean next() throws CUBAException {
            do {
                ++this.cursor;
                if (this.cursor >= this.dataSourceRowCount) {
                    return false;
                }
                this.row = this.getRow(this.cursor);
            } while (!this.isGoodRow());
            return true;
        }

        private Object[] getRow(int cursor) {
            Object[] array = new Object[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                array[i] = CubaBuilderForEASPivot.this.dataSource.getCell(i, cursor);
            }
            return array;
        }

        @Override
        public Object getValue(int index) throws CUBAException {
            return this.row[index];
        }

        @Override
        public Object[] getValues() throws CUBAException {
            return this.row;
        }

        @Override
        public void close() {
            this.cursor = -1;
        }

        public boolean isGoodRow() {
            if (this.valuesSelectedList == null) {
                return true;
            }
            for (int i = 0; i < this.valuesSelectedList.length; ++i) {
                if (this.valuesSelectedList[i] == null || this.valuesSelectedList[i].contains(this.row[i])) continue;
                return false;
            }
            return true;
        }
    }

    private class TupleKey {
        Object[] values;

        public TupleKey(Object[] values) {
            this.values = values;
        }

        public int hashCode() {
            int code = 0;
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null) continue;
                code += this.values[i].hashCode() * (17 + i);
            }
            return code;
        }

        public boolean equals(Object x) {
            TupleKey key2 = (TupleKey)x;
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == key2.values[i]) continue;
                return false;
            }
            return true;
        }
    }
}

