/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.model;

import com.kingdee.bos.streamwork.pivot.model.Member;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ColumnValues {
    private String columnName;
    private ArrayList values = new ArrayList();
    private HashSet set = new HashSet();
    private int dataType = -1;
    private boolean hasNull;
    private HashMap<String, Object> indexes;

    public ColumnValues(String columnName) {
        this.columnName = columnName;
    }

    public void addValue(Object value) {
        if (value == null) {
            this.hasNull = true;
            return;
        }
        if (value instanceof String) {
            value = ((String)value).replaceAll("`", "");
        }
        if (!this.set.contains(value)) {
            this.values.add(value);
            this.set.add(value);
            this.guessDataType(value);
        }
    }

    public Object lookupByString(String str) {
        if (str.equals("V$NULL") || str.equals(Member.NULL_CAPTION)) {
            return str;
        }
        if (this.indexes == null) {
            this.createIndexes();
        }
        return this.indexes.get(str);
    }

    private void createIndexes() {
        this.indexes = new HashMap();
        for (Object v : this.values) {
            this.indexes.put(v.toString(), v);
        }
    }

    public void finishAdd() {
        this.set.clear();
    }

    public boolean isEmpty() {
        return this.dataType == -1;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public List getValues() {
        return this.values;
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean hasNull() {
        return this.hasNull;
    }

    private void guessDataType(Object value) {
        int type = this.getType(value);
        if (type > this.dataType) {
            this.dataType = type;
        }
    }

    private int getType(Object value) {
        int ret = -1;
        if (value instanceof Integer) {
            ret = 0;
        } else if (value instanceof Number) {
            try {
                if (value instanceof BigDecimal && ((BigDecimal)value).scale() == 0) {
                    return 0;
                }
                if (value.toString().indexOf(46) < 0) {
                    return 0;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ret = 1;
        } else {
            ret = value instanceof Date ? 3 : 2;
        }
        return ret;
    }
}

