/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.model;

import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.pivot.model.AggType;

public class Measure {
    private static int ID = 0;
    private String id;
    public String name;
    public int aggType;
    public int dataType;
    public String caption;
    public boolean isCountMeasure;
    public boolean isMetric;
    public Metric metric;

    public Measure(String name, int aggType, int dataType) {
        this(name, aggType, dataType, false);
    }

    public Measure(String name, int aggType, int dataType, boolean isCountMeasure) {
        this.isCountMeasure = isCountMeasure;
        this.name = name;
        this.aggType = aggType;
        this.dataType = dataType;
        if (isCountMeasure) {
            this.id = "V$COUNTMEASURE";
            this.caption = "\u884c\u8ba1\u6570";
        } else {
            this.id = aggType == 0 ? name : this.newId(name, aggType);
        }
    }

    private synchronized String newId(String column, int aggType) {
        return column + "-" + aggType;
    }

    public Measure(Metric metric) {
        this.isMetric = true;
        this.name = metric.getName();
        this.caption = metric.getCaption();
        this.metric = metric;
        this.id = this.name;
    }

    public String getId() {
        return this.id;
    }

    public Measure copy() {
        Measure m = new Measure(this.name, this.aggType, this.dataType);
        m.caption = this.caption;
        m.isMetric = this.isMetric;
        m.metric = this.metric;
        return m;
    }

    public String getCaption() {
        if (this.caption != null) {
            return this.caption;
        }
        return this.name + "(" + AggType.getName(this.aggType) + ")";
    }

    public String toString() {
        return this.getCaption();
    }
}

