/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.schema;

import com.kingdee.bos.streamwork.calculator.CalculatedField;
import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.pivot.PivotException;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class QuerySchema {
    public String version = "1.0";
    public String number;
    public String name;
    public CalculatedField[] calculatedFields;
    public Metric[] metrics;
    public String[] dimensionOnRows;
    public String[] dimensionOnColumns;
    public String[] dimensionOnFilters;
    public Measure[] measures;
    public Map<String, List<String>> memberSelectionMap;
    public boolean showSubTotalOnRow;
    public boolean showTotalOnRow = true;
    public boolean showSubTotalOnColumn;
    public boolean showTotalOnColumn;
    public int columnModel = 0;
    public int scale = 2;
    public String orderMeasure;
    public int orderMeasureAggType;
    public boolean orderDesc;
    public String billNumberField;
    public String billHeaderFields;

    public String toXML() {
        Format format = Format.getCompactFormat();
        format.setEncoding("UTF-8");
        format.setIndent("\t");
        XMLOutputter outter = new XMLOutputter(format);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(4096);
        try {
            outter.output(this.output(), (OutputStream)outStream);
            return outStream.toString("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static QuerySchema newQuerySchema(String xml) {
        QuerySchema q = new QuerySchema();
        q.fromXML(xml);
        return q;
    }

    public void fromXML(String xml) {
        Document doc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((Reader)new StringReader(xml));
            this.fromXML(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PivotException("\u65b9\u6848\u89e3\u6790\u51fa\u9519:\n" + e.getMessage());
        }
    }

    private Document output() {
        int i;
        Element ele;
        Element rootElement = new Element("QuerySchema");
        rootElement.setAttribute("version", this.version);
        if (this.name != null) {
            rootElement.setAttribute("name", this.name);
        }
        if (this.number != null) {
            rootElement.setAttribute("number", this.number);
        }
        if (this.calculatedFields != null) {
            ele = new Element("CalculatedFields");
            for (i = 0; i < this.calculatedFields.length; ++i) {
                Element child = new Element("CalculatedField");
                child.setAttribute("name", this.calculatedFields[i].name);
                child.setAttribute("type", "" + this.calculatedFields[i].type);
                CDATA text = new CDATA(this.calculatedFields[i].text);
                child.addContent((Content)text);
                ele.addContent((Content)child);
            }
            rootElement.addContent((Content)ele);
        }
        if (this.metrics != null) {
            ele = new Element("Metrics");
            for (Metric metric : this.metrics) {
                Element child = metric.toXML();
                ele.addContent((Content)child);
            }
            rootElement.addContent((Content)ele);
        }
        if (this.dimensionOnRows != null) {
            ele = new Element("DimensionOnRows");
            CDATA text = new CDATA(this.toString(this.dimensionOnRows));
            ele.addContent((Content)text);
            rootElement.addContent((Content)ele);
        }
        if (this.dimensionOnColumns != null) {
            ele = new Element("DimensionOnColumns");
            CDATA text = new CDATA(this.toString(this.dimensionOnColumns));
            ele.addContent((Content)text);
            rootElement.addContent((Content)ele);
        }
        if (this.dimensionOnFilters != null) {
            ele = new Element("DimensionOnFilters");
            CDATA text = new CDATA(this.toString(this.dimensionOnFilters));
            ele.addContent((Content)text);
            rootElement.addContent((Content)ele);
        }
        if (this.measures != null) {
            ele = new Element("Measures");
            for (i = 0; i < this.measures.length; ++i) {
                Element child = new Element("Measure");
                child.setAttribute("name", this.measures[i].name);
                if (this.measures[i].caption != null) {
                    child.setAttribute("caption", this.measures[i].caption);
                }
                child.setAttribute("dataType", "" + this.measures[i].dataType);
                child.setAttribute("aggType", "" + this.measures[i].aggType);
                if (this.measures[i].isCountMeasure) {
                    child.setAttribute("isCountMeasure", "true");
                }
                if (this.measures[i].isMetric) {
                    child.setAttribute("isMetric", "true");
                }
                ele.addContent((Content)child);
            }
            rootElement.addContent((Content)ele);
        }
        if (this.memberSelectionMap != null) {
            ele = new Element("MemberSelections");
            for (Map.Entry<String, List<String>> entry : this.memberSelectionMap.entrySet()) {
                Element child = new Element("MemberSelection");
                child.setAttribute("dimension", entry.getKey());
                CDATA text = new CDATA(this.toString(entry.getValue()));
                child.addContent((Content)text);
                ele.addContent((Content)child);
            }
            rootElement.addContent((Content)ele);
        }
        if (this.orderMeasure != null) {
            ele = new Element("OrderMeasure");
            ele.setAttribute("name", this.orderMeasure);
            ele.setAttribute("desc", this.orderDesc ? "true" : "false");
            ele.setAttribute("aggType", "orderMeasureAggType");
            rootElement.addContent((Content)ele);
        }
        if (this.billHeaderFields != null) {
            ele = new Element("BillConfig");
            ele.setAttribute("billHeaderFields", this.billHeaderFields);
            ele.setAttribute("billNumberField", this.billNumberField);
            rootElement.addContent((Content)ele);
        }
        ele = new Element("Options");
        ele.setAttribute("showSubTotalOnColumn", this.showSubTotalOnColumn ? "true" : "false");
        ele.setAttribute("showSubTotalOnRow", this.showSubTotalOnRow ? "true" : "false");
        ele.setAttribute("showTotalOnColumn", this.showTotalOnColumn ? "true" : "false");
        ele.setAttribute("showTotalOnRow", this.showTotalOnRow ? "true" : "false");
        ele.setAttribute("columnModel", "" + this.columnModel);
        ele.setAttribute("scale", "" + this.scale);
        rootElement.addContent((Content)ele);
        Document doc = new Document(rootElement);
        return doc;
    }

    public void fromXML(Document doc) {
        String text;
        String name;
        Element child;
        int i;
        List children;
        Element rootElement = doc.getRootElement();
        this.version = rootElement.getAttributeValue("version");
        this.name = rootElement.getAttributeValue("name");
        this.number = rootElement.getAttributeValue("number");
        Element ele = rootElement.getChild("Options");
        this.showSubTotalOnColumn = "true".equals(ele.getAttributeValue("showSubTotalOnColumn"));
        this.showSubTotalOnRow = "true".equals(ele.getAttributeValue("showSubTotalOnRow"));
        this.showTotalOnColumn = "true".equals(ele.getAttributeValue("showTotalOnColumn"));
        this.showTotalOnRow = "true".equals(ele.getAttributeValue("showTotalOnRow"));
        this.columnModel = Integer.parseInt(ele.getAttributeValue("columnModel"));
        String s = ele.getAttributeValue("scale");
        if (s != null) {
            try {
                this.scale = Integer.parseInt(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((ele = rootElement.getChild("OrderMeasure")) != null) {
            this.orderMeasure = ele.getAttributeValue("name");
            this.orderDesc = "true".equals(ele.getAttributeValue("desc"));
            this.orderMeasureAggType = Integer.parseInt(ele.getAttributeValue("aggType"));
        }
        if ((ele = rootElement.getChild("BillConfig")) != null) {
            this.billHeaderFields = ele.getAttributeValue("billHeaderFields");
            this.billNumberField = ele.getAttributeValue("billNumberField");
        }
        if ((ele = rootElement.getChild("MemberSelections")) != null) {
            children = ele.getChildren("MemberSelection");
            this.memberSelectionMap = new HashMap<String, List<String>>(children.size());
            for (i = 0; i < children.size(); ++i) {
                child = (Element)children.get(i);
                String dim = child.getAttributeValue("dimension");
                String text2 = child.getText();
                String[] names = text2.split("\\|\\|");
                ArrayList<String> list = new ArrayList<String>(names.length);
                for (int j = 0; j < names.length; ++j) {
                    list.add(names[j]);
                }
                this.memberSelectionMap.put(dim, list);
            }
        }
        if ((ele = rootElement.getChild("Measures")) != null) {
            children = ele.getChildren("Measure");
            this.measures = new Measure[children.size()];
            for (i = 0; i < children.size(); ++i) {
                child = (Element)children.get(i);
                name = child.getAttributeValue("name");
                String caption = child.getAttributeValue("caption");
                String aggType = child.getAttributeValue("aggType");
                String dataType = child.getAttributeValue("dataType");
                String isCountMeasure = child.getAttributeValue("isCountMeasure");
                String isMetric = child.getAttributeValue("isMetric");
                this.measures[i] = new Measure(name, Integer.parseInt(aggType), Integer.parseInt(dataType));
                this.measures[i].isCountMeasure = "true".equals(isCountMeasure);
                this.measures[i].isMetric = "true".equals(isMetric);
                this.measures[i].caption = caption;
                this.measures[i].aggType = Integer.parseInt(aggType);
            }
        }
        if ((ele = rootElement.getChild("CalculatedFields")) != null) {
            children = ele.getChildren("CalculatedField");
            this.calculatedFields = new CalculatedField[children.size()];
            for (i = 0; i < children.size(); ++i) {
                child = (Element)children.get(i);
                name = child.getAttributeValue("name");
                String type = child.getAttributeValue("type");
                String text3 = child.getText();
                this.calculatedFields[i] = new CalculatedField(name, Integer.parseInt(type), text3, null);
            }
        }
        if ((ele = rootElement.getChild("Metrics")) != null) {
            children = ele.getChildren("Metric");
            this.metrics = new Metric[children.size()];
            for (i = 0; i < children.size(); ++i) {
                child = (Element)children.get(i);
                this.metrics[i] = Metric.fromXML(child);
            }
        }
        if ((ele = rootElement.getChild("DimensionOnFilters")) != null) {
            text = ele.getText();
            String[] dims = text.split("\\|\\|");
            this.dimensionOnFilters = dims;
        }
        if ((ele = rootElement.getChild("DimensionOnColumns")) != null) {
            text = ele.getText();
            String[] dims = text.split("\\|\\|");
            this.dimensionOnColumns = dims;
        }
        if ((ele = rootElement.getChild("DimensionOnRows")) != null) {
            text = ele.getText();
            String[] dims = text.split("\\|\\|");
            this.dimensionOnRows = dims;
        }
    }

    private String toString(List<String> memberList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < memberList.size(); ++i) {
            if (i > 0) {
                sb.append("||");
            }
            sb.append(memberList.get(i));
        }
        return sb.toString();
    }

    private String toString(String[] dims) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dims.length; ++i) {
            if (i > 0) {
                sb.append("||");
            }
            sb.append(dims[i]);
        }
        return sb.toString();
    }
}

