/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.worksheet;

import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileChooserUtil {
    private JFileChooser jfc = null;
    private Component parent = null;

    public FileChooserUtil(Component parent) {
        this.parent = parent;
        this.jfc = new JFileChooser();
        this.jfc.setMultiSelectionEnabled(false);
    }

    public void setSelectedFile(String path) {
        this.jfc.setSelectedFile(new File(path));
    }

    public File openFile(String title, String exts, String desc) {
        FileFilter[] ff = this.jfc.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            this.jfc.removeChoosableFileFilter(ff[i]);
        }
        this.jfc.addChoosableFileFilter(new MyFileFilter(exts, desc));
        this.jfc.setDialogTitle(title);
        if (this.jfc.showOpenDialog(this.parent) == 0) {
            return this.jfc.getSelectedFile();
        }
        return null;
    }

    public File saveFile(String title, String exts, String desc) {
        FileFilter[] ff = this.jfc.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            this.jfc.removeChoosableFileFilter(ff[i]);
        }
        this.jfc.setFileFilter(new MyFileFilter(exts, desc));
        this.jfc.setDialogTitle(title);
        if (this.jfc.showSaveDialog(this.parent) == 0) {
            File f = this.jfc.getSelectedFile();
            if (f.exists()) {
                int re = JOptionPane.showConfirmDialog(this.parent, f.getAbsolutePath() + "\n\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728,\u662f\u5426\u8986\u76d6?", title, 1, 3);
                if (re == 0) {
                    return f;
                }
                if (re == 1) {
                    return this.saveFile(title, exts, desc);
                }
                return null;
            }
            return f;
        }
        return null;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static File changeExtension(File f, String ext) {
        String s = f.getAbsolutePath();
        int i = s.lastIndexOf(46);
        if (i != -1) {
            s = s.substring(0, i);
        }
        s = s + '.' + ext;
        return new File(s);
    }

    class MyFileFilter
    extends FileFilter {
        private Set extSet = new HashSet();
        private String desc;
        private boolean acceptDirector;

        MyFileFilter(String exts, String desc) {
            this(exts, desc, true);
        }

        MyFileFilter(String exts, String desc, boolean acceptDirector) {
            this.acceptDirector = acceptDirector;
            if (exts != null) {
                String[] s = exts.split(",");
                for (int i = 0; i < s.length; ++i) {
                    String buf = s[i].trim().toLowerCase();
                    if (buf.length() <= 0) continue;
                    this.extSet.add(buf);
                }
            }
            this.desc = desc;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return this.acceptDirector;
            }
            String ext = FileChooserUtil.getExtension(f);
            if (ext != null) {
                return this.extSet.contains(ext);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }
}

