/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.worksheet;

import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.pivot.worksheet.Config;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotDataCellItem;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotHierarchyCellItem;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotMemberCellItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class PivotCellRender
implements IBasicRender,
Cloneable {
    static Color bgColorDark = new Color(204, 215, 232);
    static Color bgColor = new Color(240, 240, 240);
    static Color bgColor2 = new Color(225, 225, 225);
    static SimpleTextRender textRender = new SimpleTextRender();
    Config config;

    public PivotCellRender(Config config) {
        this.config = config;
    }

    public void draw(Graphics g, Shape clip, Object object, Style cellStyle) {
        Rectangle bound = clip.getBounds();
        if (object instanceof PivotHierarchyCellItem) {
            PivotHierarchyCellItem cellItem = (PivotHierarchyCellItem)object;
            if (cellItem.inSlicer() || !this.config.showColumnHeaderInTableHeader) {
                Color oldColor = g.getColor();
                g.setColor(bgColorDark);
                g.fillRect(bound.x - 3, bound.y - 2 + 2, bound.width + 6, bound.height + 4 - 4);
                g.setColor(oldColor);
            }
            Font oldFont = g.getFont();
            Font font = oldFont.deriveFont(1);
            g.setFont(font);
            Rectangle clip2 = new Rectangle(bound.x, bound.y, bound.width - 12, bound.height);
            if (object != null && object.toString() != null) {
                textRender.draw(g, (Shape)clip2, object.toString(), cellStyle);
            }
            g.setFont(oldFont);
        } else if (object instanceof PivotMemberCellItem) {
            Color oldColor;
            PivotMemberCellItem mci = (PivotMemberCellItem)object;
            if (mci.inColumns() && !this.config.showColumnHeaderInTableHeader) {
                oldColor = g.getColor();
                if (mci.getBgColor() != null) {
                    g.setColor(mci.getBgColor());
                } else {
                    g.setColor(bgColorDark);
                }
                Font oldFont = g.getFont();
                Font font = oldFont.deriveFont(1);
                g.setFont(font);
                g.fillRect(bound.x - 3, bound.y - 2 + 2, bound.width + 6, bound.height + 4 - 4);
                g.setColor(oldColor);
                g.setFont(oldFont);
            } else if (!mci.inColumns() || !this.config.showColumnHeaderInTableHeader) {
                oldColor = g.getColor();
                if (mci.getBgColor() != null) {
                    g.setColor(mci.getBgColor());
                } else {
                    g.setColor(bgColor);
                }
                g.fillRect(bound.x - 3, bound.y - 2 + 2, bound.width + 6, bound.height + 4 - 4);
                g.setColor(oldColor);
            }
            int hIndent = 6;
            int wIndent = 2;
            if (wIndent > 3) {
                wIndent -= 3;
            }
            if (hIndent > 2) {
                hIndent -= 2;
            }
            Rectangle clip2 = null;
            Color oldColor2 = g.getColor();
            g.setColor(Color.BLACK);
            if (mci.inColumns()) {
                g.setColor(oldColor2);
                int ind = 0;
                clip2 = new Rectangle(bound.x + wIndent + ind, bound.y, bound.width - ind - wIndent, bound.height);
            } else if (mci.inRows()) {
                g.setColor(oldColor2);
                clip2 = new Rectangle(bound.x + wIndent, bound.y + hIndent, bound.width - wIndent, bound.height - hIndent);
            } else {
                clip2 = new Rectangle(bound.x + wIndent, bound.y + hIndent, bound.width - wIndent, bound.height - hIndent);
            }
            Font oldFont = g.getFont();
            Font font = oldFont.deriveFont(1);
            g.setFont(font);
            if (object != null && object.toString() != null) {
                textRender.draw(g, (Shape)clip2, object.toString(), cellStyle);
            }
            g.setFont(oldFont);
        } else if (object instanceof PivotDataCellItem) {
            PivotDataCellItem cellItem = (PivotDataCellItem)object;
            if (cellItem.getBgColor() == null) {
                Member[] members = cellItem.getMemberContext();
                boolean hasTotal = false;
                for (int i = 0; i < members.length; ++i) {
                    if (!members[i].isCalculated()) continue;
                    hasTotal = true;
                }
                if (hasTotal) {
                    Color oldColor = g.getColor();
                    g.setColor(bgColor2);
                    g.fillRect(bound.x - 3, bound.y - 2 + 2, bound.width + 6, bound.height + 4 - 4);
                    g.setColor(oldColor);
                }
            }
            textRender.draw(g, clip, object.toString(), cellStyle);
        } else if (object != null) {
            textRender.draw(g, clip, object.toString(), cellStyle);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }
}

