/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bigobjectcache.BigObjectCacheMap;
import com.kingdee.bos.bigobjectcache.BigObjectCacheMapFactory;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.QueryHelper;
import com.kingdee.bos.dao.query.server.QueryContext;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefDele;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.streamwork.datasource.ColumnBasedDataSource;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.datasource.DataSourceWithCachedPage;
import com.kingdee.bos.streamwork.service.IStreamWorkService;
import com.kingdee.bos.streamwork.service.StreamWorkConfig;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StreamWorkService
implements IStreamWorkService {
    private static boolean ensuredQuerySchemaTable = false;

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this;
    }

    @Override
    public DataSource executeBOSQuery(IMetaDataPK queryPK, EntityViewInfo viewInfo, String[] fields) throws BOSException {
        return this.executeBOSQuery(queryPK, viewInfo, fields, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource executeBOSQuery(IMetaDataPK queryPK, EntityViewInfo viewInfo, String[] fields, boolean getDefaultSchema, String ui) throws BOSException {
        DataSourceWithCachedPage dataSourceWithCachedPage;
        Context ctx = ConfigMDUtil.getContext();
        String sql = null;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            DataSourceWithCachedPage ds;
            int rowCount;
            QueryContext queryCtx = QueryContext.getInstance(viewInfo, new QueryExecuteOption());
            queryCtx.init(ctx, null, queryPK, MetaDataTypeList.BASEQUERY);
            ArrayList selectors = queryCtx.getQuerySqlAccess().select.getSelector();
            sql = queryCtx.getQuerySqlAccess().getSql();
            Map aliasMap = (Map)queryCtx.getQuerySqlAccess().query.getContext().get((Object)"selectorAliasMapping");
            con = EJBFactory.getConnection(ctx);
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            DataSourceWithCachedPage ds0 = null;
            ArrayList<String> cachedPageKeys = new ArrayList<String>();
            BigObjectCacheMap cacheMap = BigObjectCacheMapFactory.getBigCacheMap(StreamWorkService.class);
            int count = 0;
            int rowsPerPage = StreamWorkConfig.DEFAULT_PAGEROWS;
            while ((rowCount = (ds = this.createDataSource(rs, rowsPerPage, fields, selectors, aliasMap)).getRowCount()) > 0) {
                if (count == 0) {
                    ds0 = ds;
                } else {
                    String key;
                    while (cacheMap.containsKey((Object)(key = Uuid.create().toString()))) {
                    }
                    cachedPageKeys.add(key);
                    cacheMap.put((Object)key, (Serializable)ds, StreamWorkConfig.DEFAULT_PAGECACHETIMEOUT);
                }
                if (rowCount < rowsPerPage) break;
                ++count;
            }
            if (ds0 != null) {
                ds = ds0;
            }
            if (!cachedPageKeys.isEmpty()) {
                ds.setCachedPageKeys(cachedPageKeys);
            }
            ds.setProperty("sql", sql);
            if (getDefaultSchema) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("ui", ui);
                String content = this.getDefaultQuerySchemaContent(params);
                if (content != null) {
                    ds.setProperty("defaultQuerySchema", content);
                }
            }
            dataSourceWithCachedPage = ds;
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                DataSource dataSource = null;
                return dataSource;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                SQLUtils.cleanup(rs, stmt, con);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return dataSourceWithCachedPage;
    }

    private DataSourceWithCachedPage createDataSource(ResultSet rs, int limit, String[] fields, ArrayList selectors, Map aliasMap) {
        return new ColumnBasedDataSource(rs, limit, fields, selectors, aliasMap);
    }

    public static Object getObject(ResultSet rs, int col, PropertyUnitDele fld, Map cache, Map enumPkCache) throws SQLException, BOSException {
        if (fld == null) {
            Object obj = rs.getObject(col);
            return obj;
        }
        ConstDataType tp = fld.getReturnType();
        String fldName = fld.getName();
        if (tp.equals((Object)ConstDataType.STRING)) {
            String colVal = rs.getString(col);
            if (colVal == null) {
                return null;
            }
            Boolean isAliableEnum = (Boolean)enumPkCache.get(fldName);
            if (isAliableEnum == null) {
                isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                enumPkCache.put(fldName, isAliableEnum);
            }
            if (isAliableEnum.booleanValue()) {
                String key = fld.getName() + colVal.toString();
                Object value = cache.get(key);
                if (value == null && (value = QueryHelper.getAliasFromEnumValue(StreamWorkService.getEnum(fld), colVal)) != null) {
                    cache.put(key, value);
                }
                return value;
            }
            return colVal.intern();
        }
        if (tp.equals((Object)ConstDataType.BOOLEAN)) {
            int i;
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                return null;
            }
            if (colVal instanceof Boolean) {
                return colVal;
            }
            try {
                i = TypeConversionUtils.objToInt((Object)colVal);
            }
            catch (IllegalConversionException e) {
                throw new BOSException("Field ReturnType Conversion error. Field:" + fldName, (Throwable)e);
            }
            return i != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (tp.equals((Object)ConstDataType.INT)) {
            Object colVal = rs.getObject(col);
            if (colVal instanceof BigDecimal) {
                colVal = ((BigDecimal)colVal).intValue();
            }
            if (colVal instanceof Integer) {
                int i = (Integer)colVal;
                Boolean isAliableEnum = (Boolean)enumPkCache.get(fldName);
                if (isAliableEnum == null) {
                    isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                    enumPkCache.put(fldName, isAliableEnum);
                }
                if (isAliableEnum.booleanValue()) {
                    String key = fld.getName() + colVal.toString();
                    Object value = cache.get(key);
                    if (value == null && (value = QueryHelper.getAliasFromEnumValue(StreamWorkService.getEnum(fld), i)) != null) {
                        cache.put(key, value);
                    }
                    return value;
                }
                return i;
            }
            if (colVal instanceof Long) {
                long l = (Long)colVal;
                Boolean isAliableEnum = (Boolean)enumPkCache.get(fldName);
                if (isAliableEnum == null) {
                    isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                    enumPkCache.put(fldName, isAliableEnum);
                }
                if (isAliableEnum.booleanValue()) {
                    String key = fld.getName() + colVal.toString();
                    Object value = cache.get(key);
                    if (value == null && (value = QueryHelper.getAliasFromEnumValue(StreamWorkService.getEnum(fld), l)) != null) {
                        cache.put(key, value);
                    }
                    return value;
                }
                return l;
            }
            if (colVal instanceof String) {
                Boolean isAliableEnum = (Boolean)enumPkCache.get(fldName);
                if (isAliableEnum == null) {
                    isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                    enumPkCache.put(fldName, isAliableEnum);
                }
                if (isAliableEnum.booleanValue()) {
                    String key = fld.getName() + colVal.toString();
                    Object value = cache.get(key);
                    if (value == null) {
                        try {
                            int intValue = Integer.parseInt(colVal.toString());
                            value = QueryHelper.getAliasFromEnumValue(StreamWorkService.getEnum(fld), intValue);
                        }
                        catch (NumberFormatException intValue) {
                            // empty catch block
                        }
                        if (value != null) {
                            cache.put(key, value);
                        } else {
                            value = colVal;
                        }
                    }
                    return value;
                }
                return colVal;
            }
            return colVal;
        }
        if (tp.equals((Object)ConstDataType.NUMBER)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                return null;
            }
            if (colVal instanceof Float) {
                float f = ((Float)colVal).floatValue();
                Boolean isAliableEnum = (Boolean)enumPkCache.get(fldName);
                if (isAliableEnum == null) {
                    isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                    enumPkCache.put(fldName, isAliableEnum);
                }
                if (isAliableEnum.booleanValue()) {
                    String key = fld.getName() + colVal.toString();
                    Object value = cache.get(key);
                    if (value == null && (value = QueryHelper.getAliasFromEnumValue(StreamWorkService.getEnum(fld), f)) != null) {
                        cache.put(key, value);
                    }
                    return value;
                }
                return Float.valueOf(f);
            }
            if (colVal instanceof Double) {
                double d = (Double)colVal;
                Boolean isAliableEnum = (Boolean)enumPkCache.get(fldName);
                if (isAliableEnum == null) {
                    isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                    enumPkCache.put(fldName, isAliableEnum);
                }
                if (isAliableEnum.booleanValue()) {
                    String key = fld.getName() + colVal.toString();
                    Object value = cache.get(key);
                    if (cache.get(colVal) == null && (value = QueryHelper.getAliasFromEnumValue(StreamWorkService.getEnum(fld), d)) != null) {
                        cache.put(key, value);
                    }
                    return value;
                }
                return d;
            }
            if (colVal instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)colVal;
                return bd;
            }
            if (colVal instanceof String) {
                try {
                    return Float.valueOf((String)colVal);
                }
                catch (Throwable t) {
                    return colVal;
                }
            }
            return colVal;
        }
        if (tp.equals((Object)ConstDataType.DATE)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                return null;
            }
            if (colVal instanceof Date) {
                Date da = (Date)colVal;
                return da;
            }
            if (colVal instanceof Time) {
                Time ti = (Time)colVal;
                return ti;
            }
            if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                return ts;
            }
            return colVal;
        }
        if (tp.equals((Object)ConstDataType.TIME)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                return null;
            }
            if (colVal instanceof Time) {
                Time ti = (Time)colVal;
                return ti;
            }
            if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                return ts;
            }
            return colVal;
        }
        if (tp.equals((Object)ConstDataType.TIMESTAMP)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                return null;
            }
            if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                return ts;
            }
            return colVal;
        }
        return rs.getObject(col);
    }

    private static BizEnumInfo getEnum(PropertyUnitDele fld) throws BOSException {
        PropertyRefDele ref;
        BizEnumInfo bizEnum = null;
        if (fld.getPropertyRefs().size() == 1 && (ref = fld.getPropertyRefs().get(0)).getSubEntity() != null && ref.getRefProperty() != null && ref.getRefProperty() instanceof OwnPropertyInfo && ((OwnPropertyInfo)ref.getRefProperty()).getDataType().equals((Object)DataType.ENUM)) {
            PropertyInfo prop = ref.getRefProperty();
            if (prop instanceof OwnPropertyInfo) {
                String metadataRef = ((OwnPropertyInfo)prop).getMetaDataRef();
                String className = MetaDataUtils.getClassName((String)metadataRef);
                String packageName = MetaDataUtils.getPackageName((String)metadataRef);
                try {
                    bizEnum = StreamWorkService.getBizEnum(MetaDataPK.create((String)packageName, (String)className));
                }
                catch (Exception be) {
                    throw new BOSException((Throwable)be);
                }
            } else {
                throw new BOSException("The type of property is not Ownproperty!");
            }
        }
        if (bizEnum != null) {
            return bizEnum;
        }
        throw new BOSException("Get BizEnumInfo message failed!");
    }

    private static BizEnumInfo getBizEnum(MetaDataPK pk) {
        Context ctx = ConfigMDUtil.getContext();
        return MetaDataLoader.getEnum((Context)ctx, (IMetaDataPK)pk);
    }

    @Override
    public DataSource getCachedDataSourcePage(Object key) {
        return this.getCachedDataSourcePage(key, false);
    }

    @Override
    public DataSource getCachedDataSourcePage(Object key, boolean remove) {
        BigObjectCacheMap cacheMap = BigObjectCacheMapFactory.getBigCacheMap(StreamWorkService.class);
        if (remove) {
            return (DataSource)cacheMap.remove(key);
        }
        return (DataSource)cacheMap.get(key);
    }

    private static synchronized void ensureQuerySchemaTable() {
    }

    @Override
    public void saveQuerySchema(String name, String content, Map params) throws BOSException {
        StreamWorkService.ensureQuerySchemaTable();
        String operate = (String)params.get("operate");
        if ("insert".equalsIgnoreCase(operate)) {
            this.insertQuerySchema(name, content, params);
        } else if ("update".equalsIgnoreCase(operate)) {
            this.updateQuerySchema(name, content, params);
        } else {
            boolean success = false;
            try {
                success = this.insertQuerySchema(name, content, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (success) {
                return;
            }
            this.updateQuerySchema(name, content, params);
        }
    }

    private boolean updateQuerySchema(String name, String content, Map params) throws BOSException {
        Context ctx = ConfigMDUtil.getContext();
        Connection cn = null;
        PreparedStatement ps = null;
        String userId = ctx.getCaller().toString();
        String ui = (String)params.get("ui");
        String sql = "update T_ADTJ_SCHEMA set fcontent=?,fupdatetime=? where fuserid=? and fname=? and fui=?";
        try {
            cn = EJBFactory.getConnection(ctx);
            ps = cn.prepareStatement(sql);
            ps.setString(1, content);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, userId);
            ps.setString(4, name);
            ps.setString(5, ui);
            int i = ps.executeUpdate();
            boolean bl = i > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private boolean insertQuerySchema(String name, String content, Map params) throws BOSException {
        Context ctx = ConfigMDUtil.getContext();
        Connection cn = null;
        PreparedStatement ps = null;
        Object rs = null;
        String userId = ctx.getCaller().toString();
        String ui = (String)params.get("ui");
        String uiTitle = (String)params.get("uiTitle");
        String sql = "insert into T_ADTJ_SCHEMA(fuserid,fui,fuititle,fname,fcontent,fcreatetime,fupdatetime) values(?,?,?,?,?,?,?)";
        try {
            cn = EJBFactory.getConnection(ctx);
            ps = cn.prepareStatement(sql);
            int index = 1;
            ps.setString(index++, userId);
            ps.setString(index++, ui);
            ps.setString(index++, uiTitle);
            ps.setString(index++, name);
            ps.setString(index++, content);
            Timestamp t = new Timestamp(System.currentTimeMillis());
            ps.setTimestamp(index++, t);
            ps.setTimestamp(index++, t);
            int i = ps.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public Map[] listQuerySchema(Map params) throws BOSException {
        StreamWorkService.ensureQuerySchemaTable();
        Context ctx = ConfigMDUtil.getContext();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String userId = ctx.getCaller().toString();
        String ui = (String)params.get("ui");
        try {
            String sql = "select fname,fupdatetime,fisdefault from T_ADTJ_SCHEMA where fuserId =? and fui=? order by fupdatetime desc";
            cn = EJBFactory.getConnection(ctx);
            ps = cn.prepareStatement(sql);
            int index = 1;
            ps.setString(index++, userId);
            ps.setString(index++, ui);
            rs = ps.executeQuery();
            ArrayList list = new ArrayList();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("name", rs.getString(1));
                map.put("updateTime", rs.getTimestamp(2));
                map.put("isdefault", rs.getInt(3) == 1);
                list.add(map);
            }
            Map[] mapArray = list.toArray(new Map[0]);
            return mapArray;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public String getQuerySchemaContent(String name, Map params) throws BOSException {
        StreamWorkService.ensureQuerySchemaTable();
        Context ctx = ConfigMDUtil.getContext();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String userId = ctx.getCaller().toString();
        String ui = (String)params.get("ui");
        try {
            String sql = "select fcontent from T_ADTJ_SCHEMA where fuserId =? and fui=? and fname=?";
            cn = EJBFactory.getConnection(ctx);
            ps = cn.prepareStatement(sql);
            int index = 1;
            ps.setString(index++, userId);
            ps.setString(index++, ui);
            ps.setString(index++, name);
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    @Override
    public void deleteQuerySchema(String name, Map params) throws BOSException {
        Context ctx = ConfigMDUtil.getContext();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String userId = ctx.getCaller().toString();
        String ui = (String)params.get("ui");
        try {
            String sql = "delete from T_ADTJ_SCHEMA where fuserId =? and fui=? and fname=?";
            cn = EJBFactory.getConnection(ctx);
            ps = cn.prepareStatement(sql);
            int index = 1;
            ps.setString(index++, userId);
            ps.setString(index++, ui);
            ps.setString(index++, name);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public String getDefaultQuerySchemaContent(Map params) throws BOSException {
        Context ctx = ConfigMDUtil.getContext();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String userId = ctx.getCaller().toString();
        String ui = (String)params.get("ui");
        try {
            String sql = "select fcontent from T_ADTJ_SCHEMA where fuserId =? and fui=? and fisdefault=1";
            cn = EJBFactory.getConnection(ctx);
            ps = cn.prepareStatement(sql);
            int index = 1;
            ps.setString(index++, userId);
            ps.setString(index++, ui);
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    @Override
    public void setDefaultQuerySchema(String name, Map params) throws BOSException {
        Context ctx = ConfigMDUtil.getContext();
        Connection cn = null;
        PreparedStatement ps = null;
        String userId = ctx.getCaller().toString();
        String ui = (String)params.get("ui");
        String sql = "update T_ADTJ_SCHEMA set fisdefault=0 where fuserid=? and fui=? and fisdefault=1";
        String sql2 = "update T_ADTJ_SCHEMA set fisdefault=1 where fuserid=? and fui=? and fname=?";
        try {
            cn = EJBFactory.getConnection(ctx);
            ps = cn.prepareStatement(sql);
            int index = 1;
            ps.setString(index++, userId);
            ps.setString(index++, ui);
            ps.executeUpdate();
            ps.close();
            ps = cn.prepareStatement(sql2);
            index = 1;
            ps.setString(index++, userId);
            ps.setString(index++, ui);
            ps.setString(index++, name);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

