/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.threadcache;

import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.rpc.ThreadListener;
import com.kingdee.bos.rpc.ThreadListenerManager;
import com.kingdee.bos.threadcache.ThreadCacheManager;
import com.kingdee.bos.threadcache.ThreadLocalable;
import com.kingdee.bos.threadcache.ormapping.OrmappingDAOThreadCacheProxy;
import com.kingdee.bos.threadcache.ormapping.OrmappingDAOThreadLocalObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ThreadCacheFactory {
    private static final ThreadLocal<Map<String, OrmappingDAOThreadLocalObject>> threadLocal = new ThreadLocal();
    private static final HashMap<Thread, ArrayList<ThreadLocalable>> threadLocalObjects = new HashMap();

    public static synchronized IORMappingDAO getORMappingDAOProxy(IORMappingDAO dao) {
        String key;
        OrmappingDAOThreadLocalObject threadLocalObject;
        Map<String, OrmappingDAOThreadLocalObject> map = threadLocal.get();
        if (map == null) {
            map = new HashMap<String, OrmappingDAOThreadLocalObject>();
            threadLocal.set(map);
        }
        if ((threadLocalObject = map.get(key = "ORMAPPING")) == null) {
            threadLocalObject = new OrmappingDAOThreadLocalObject();
            ThreadCacheFactory.registerThreadLocalable(threadLocalObject);
            map.put(key, threadLocalObject);
        }
        dao = new OrmappingDAOThreadCacheProxy(dao, threadLocalObject);
        return dao;
    }

    private static synchronized void registerThreadLocalable(ThreadLocalable threadLocalObject) {
        Thread thread = Thread.currentThread();
        ArrayList<ThreadLocalable> list = threadLocalObjects.get(thread);
        if (list == null) {
            list = new ArrayList();
            threadLocalObjects.put(thread, list);
        }
        list.add(threadLocalObject);
    }

    public static void recycleThread(Thread thread) {
        ArrayList<ThreadLocalable> list = threadLocalObjects.get(thread);
        if (list == null) {
            return;
        }
        Iterator<ThreadLocalable> iter = list.iterator();
        while (iter.hasNext()) {
            iter.next().recycle();
        }
        ThreadCacheManager.recycleThread(thread);
        list = null;
    }

    static {
        ThreadListenerManager.addListener((ThreadListener)new ThreadListener(){

            public void threadStarted(Thread thread) {
            }

            public void threadRecycled(Thread thread) {
            }

            public void threadFinished(Thread thread) {
            }

            public void threadRemoved(Thread thread) {
                ThreadCacheFactory.recycleThread(thread);
            }
        });
    }
}

