/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction;

import com.kingdee.bos.transaction.BOSTransactionAttribute;
import com.kingdee.bos.transaction.springframework.beans.factory.InitializingBean;
import com.kingdee.bos.transaction.springframework.transaction.NoTransactionException;
import com.kingdee.bos.transaction.springframework.transaction.PlatformTransactionManager;
import com.kingdee.bos.transaction.springframework.transaction.TransactionStatus;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.TransactionAttribute;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.TransactionAttributeSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AbstractTransactionInterceptor
implements InitializingBean,
Serializable {
    protected static ThreadLocal currentTransactionInfo = new ThreadLocal();
    protected transient Logger logger = Logger.getLogger(this.getClass());
    protected PlatformTransactionManager transactionManager;
    protected TransactionAttributeSource transactionAttributeSource;
    protected BOSTransactionAttribute transactionProperties;

    public static TransactionStatus currentTransactionStatus() throws NoTransactionException {
        return AbstractTransactionInterceptor.currentTransactionInfo().transactionStatus;
    }

    protected static TransactionInfo currentTransactionInfo() throws NoTransactionException {
        TransactionInfo info = (TransactionInfo)currentTransactionInfo.get();
        if (info == null) {
            throw new NoTransactionException("No transaction aspect-managed TransactionStatus in scope");
        }
        return info;
    }

    public static void tryRollback() {
        TransactionInfo info = (TransactionInfo)currentTransactionInfo.get();
        if (info != null && info.hasTransaction()) {
            info.transactionStatus.setRollbackOnly();
        }
    }

    public static boolean isRollbackOnly() {
        TransactionInfo info = (TransactionInfo)currentTransactionInfo.get();
        if (info != null && info.hasTransaction()) {
            return info.transactionStatus.isRollbackOnly();
        }
        throw new NoTransactionException("No Transaction,Can not get rollback obly status");
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        NameMatchTransactionAttributeSource tas = new NameMatchTransactionAttributeSource();
        tas.setProperties(transactionAttributes);
        this.transactionAttributeSource = tas;
    }

    public void setTransactionProperties(BOSTransactionAttribute transactionAttributes) {
        this.transactionProperties = transactionAttributes;
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    public TransactionAttributeSource getTransactionAttributeSource() {
        return this.transactionAttributeSource;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("transactionManager is required");
        }
        if (this.transactionAttributeSource == null) {
            throw new IllegalArgumentException("Either 'transactionAttributeSource' or 'transactionAttributes' is required: If there are no transactional methods, don't use a TransactionInterceptor respectively a transactional proxy.");
        }
    }

    protected TransactionInfo createTransactionIfNecessary(Method method, Class targetClass) {
        TransactionAttribute transAtt = this.transactionAttributeSource.getTransactionAttribute(method, targetClass);
        TransactionInfo txInfo = new TransactionInfo(transAtt, method);
        if (transAtt != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting transaction for " + txInfo.joinpointIdentification()));
            }
            txInfo.newTransactionStatus(this.transactionManager.getTransaction(transAtt));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Don't need to create transaction for " + this.methodIdentification(method) + ": this method isn't transactional"));
        }
        txInfo.bindToThread();
        return txInfo;
    }

    protected TransactionInfo createTransactionIfNecessary(Method method) {
        TransactionAttribute transAtt = this.transactionProperties.get(method);
        TransactionInfo txInfo = new TransactionInfo(transAtt, method);
        if (transAtt != null) {
            txInfo.newTransactionStatus(this.transactionManager.getTransaction(transAtt));
        }
        txInfo.bindToThread();
        return txInfo;
    }

    protected String methodIdentification(Method method) {
        return "method '" + method.getName() + "' in class [" + method.getDeclaringClass().getName() + "]";
    }

    protected void doCommitTransactionAfterReturning(TransactionInfo txInfo) {
        if (txInfo != null && txInfo.hasTransaction()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking commit for transaction on " + txInfo.joinpointIdentification()));
            }
            this.transactionManager.commit(txInfo.getTransactionStatus());
        }
    }

    protected void doCloseTransactionAfterThrowing(TransactionInfo txInfo, Throwable ex) {
        if (txInfo.hasTransaction()) {
            if (txInfo.transactionAttribute.rollbackOn(ex)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking rollback for transaction on " + txInfo.joinpointIdentification() + " due to throwable [" + ex + "]"));
                }
                try {
                    this.transactionManager.rollback(txInfo.getTransactionStatus());
                }
                catch (RuntimeException ex2) {
                    this.logger.error((Object)"Application exception overridden by rollback exception", ex);
                    throw ex2;
                }
                catch (Error err) {
                    this.logger.error((Object)"Application exception overridden by rollback error", ex);
                    throw err;
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(txInfo.joinpointIdentification() + " threw throwable [" + ex + "] but this does not force transaction rollback"));
                }
                this.transactionManager.commit(txInfo.getTransactionStatus());
            }
        }
    }

    protected void doFinally(TransactionInfo txInfo) {
        if (txInfo != null) {
            txInfo.restoreThreadLocalStatus();
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        try {
            ois.defaultReadObject();
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Failed to deserialize Spring AOP transaction aspect:Check that Spring AOP libraries are available on the client side");
        }
        this.logger = Logger.getLogger(this.getClass());
    }

    protected class TransactionInfo {
        protected final TransactionAttribute transactionAttribute;
        private final Method method;
        protected TransactionStatus transactionStatus;
        private TransactionInfo oldTransactionInfo;

        protected TransactionInfo(TransactionAttribute transactionAttribute, Method method) {
            this.transactionAttribute = transactionAttribute;
            this.method = method;
        }

        public boolean hasTransaction() {
            return this.transactionStatus != null;
        }

        public String joinpointIdentification() {
            return AbstractTransactionInterceptor.this.methodIdentification(this.method);
        }

        public void newTransactionStatus(TransactionStatus status) {
            this.transactionStatus = status;
        }

        protected void bindToThread() {
            this.oldTransactionInfo = (TransactionInfo)currentTransactionInfo.get();
            currentTransactionInfo.set(this);
        }

        protected void restoreThreadLocalStatus() {
            currentTransactionInfo.set(this.oldTransactionInfo);
        }

        public TransactionStatus getTransactionStatus() {
            return this.transactionStatus;
        }

        public TransactionAttribute getTransactionAttribute() {
            return this.transactionAttribute;
        }
    }
}

