/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.DefaultTransactionAttribute;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.TransactionAttribute;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOSTransactionAttribute {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.transaction.BOSTransactionAttribute");
    protected Map<Method, TransactionAttribute> map = new HashMap<Method, TransactionAttribute>(3);
    private BOSObjectType parentType = null;
    private Context ctx;
    private static final String NULL = "";
    private String infoGet = null;
    private String colGet = null;
    private static Map<Object, BOSTransactionAttribute> caches = new HashMap<Object, BOSTransactionAttribute>(100);

    private BOSTransactionAttribute(Context ctx, BOSObjectType type) {
        this(ctx, type, null);
    }

    private BOSTransactionAttribute(Context ctx, BOSObjectType type, IMetaDataPK pk) {
        try {
            BusinessObjectInfo model = null;
            model = pk == null ? EJBFactory.getBOFromCache(ctx, type) : EJBFactory.getBOFromCache(ctx, pk);
            this.ctx = ctx;
            String ctrName = model.getBusinessControllerName();
            Class<?> clazz = Class.forName(ctrName);
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                com.kingdee.bos.metadata.bo.TransactionAttribute tx = this.getTxAttr(model, method);
                if (tx == null) continue;
                this.map.put(method, Bos2Spring.mappingTxAttribute(tx));
            }
            if (model.getParent() == null) {
                Method[] ms = BizController.class.getDeclaredMethods();
                for (int i = 0; i < ms.length; ++i) {
                    if (!"batchingExecute".equals(ms[i].getName())) continue;
                    this.map.put(ms[i], new DefaultTransactionAttribute(0));
                }
            } else {
                this.parentType = model.getParent().getType();
            }
        }
        catch (Exception e) {
            logger.error((Object)("new BOSTransactionAttribute encounter ERROR, type: [" + type + "], pk: " + pk), (Throwable)e);
        }
    }

    private BOSTransactionAttribute(Context ctx, IMetaDataPK pk) {
        this(ctx, null, pk);
    }

    private com.kingdee.bos.metadata.bo.TransactionAttribute getTxAttr(BusinessObjectInfo bo, Method method) {
        MethodCollection mc = bo.getMethods();
        for (int i = 0; i < mc.size(); ++i) {
            String name2;
            MethodInfo mi = mc.get(i);
            int count = mi.getParameters().size() + 1;
            if (count != method.getParameterTypes().length) continue;
            String name1 = mi.getName();
            if (name1.equals(name2 = method.getName())) {
                return mi.getTransactionAttribute();
            }
            if (!("getValue".equals(name1) ? name2.equals(this.getMethodName4Info(bo)) : "getCollection".equals(name1) && name2.equals(this.getMethodName4Collection(bo)))) continue;
            return mi.getTransactionAttribute();
        }
        return com.kingdee.bos.metadata.bo.TransactionAttribute.SUPPORTS;
    }

    private String getMethodName4Info(BusinessObjectInfo bo) {
        if (this.infoGet == null) {
            if (bo instanceof EntityObjectInfo) {
                EntityObjectInfo entity = (EntityObjectInfo)bo;
                String className = entity.getObjectValueClassRuntime();
                int pos = className.lastIndexOf(46);
                this.infoGet = "get" + className.substring(pos + 1);
            } else {
                this.infoGet = NULL;
            }
        }
        return this.infoGet;
    }

    private String getMethodName4Collection(BusinessObjectInfo bo) {
        if (this.colGet == null) {
            if (bo instanceof EntityObjectInfo) {
                EntityObjectInfo entity = (EntityObjectInfo)bo;
                String className = entity.getObjectCollectionClassRuntime();
                int pos = className.lastIndexOf(46);
                this.colGet = "get" + className.substring(pos + 1);
            } else {
                this.colGet = NULL;
            }
        }
        return this.colGet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOSTransactionAttribute getAttribute(Context ctx, BOSObjectType type) {
        BOSTransactionAttribute obj = caches.get(type);
        if (obj == null) {
            Map<Object, BOSTransactionAttribute> map = caches;
            synchronized (map) {
                obj = caches.get(type);
                if (obj == null) {
                    obj = new BOSTransactionAttribute(ctx, type);
                    caches.put(type, obj);
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOSTransactionAttribute getAttribute(Context ctx, IMetaDataPK pk) {
        BOSTransactionAttribute obj = caches.get(pk);
        if (obj == null) {
            Map<Object, BOSTransactionAttribute> map = caches;
            synchronized (map) {
                obj = caches.get(pk);
                if (obj == null) {
                    obj = new BOSTransactionAttribute(ctx, pk);
                    caches.put(pk, obj);
                }
            }
        }
        return obj;
    }

    public TransactionAttribute get(Method key) {
        TransactionAttribute rtv = this.map.get(key);
        if (rtv == null && this.parentType != null) {
            rtv = BOSTransactionAttribute.getAttribute(this.ctx, this.parentType).get(key);
        }
        return rtv;
    }

    private static class Bos2Spring {
        private static final Map<com.kingdee.bos.metadata.bo.TransactionAttribute, DefaultTransactionAttribute> bos2Spring;

        private Bos2Spring() {
        }

        public static TransactionAttribute mappingTxAttribute(com.kingdee.bos.metadata.bo.TransactionAttribute bosTx) {
            return bos2Spring.get(bosTx);
        }

        static {
            HashMap<com.kingdee.bos.metadata.bo.TransactionAttribute, DefaultTransactionAttribute> temp = new HashMap<com.kingdee.bos.metadata.bo.TransactionAttribute, DefaultTransactionAttribute>(6);
            temp.put(com.kingdee.bos.metadata.bo.TransactionAttribute.SUPPORTS, new DefaultTransactionAttribute(1));
            temp.put(com.kingdee.bos.metadata.bo.TransactionAttribute.REQUIRED, new DefaultTransactionAttribute(0));
            temp.put(com.kingdee.bos.metadata.bo.TransactionAttribute.REQUIRESNEW, new DefaultTransactionAttribute(3));
            temp.put(com.kingdee.bos.metadata.bo.TransactionAttribute.MANDATORY, new DefaultTransactionAttribute(2));
            temp.put(com.kingdee.bos.metadata.bo.TransactionAttribute.NOTSUPPORTED, new DefaultTransactionAttribute(4));
            temp.put(com.kingdee.bos.metadata.bo.TransactionAttribute.NEVER, new DefaultTransactionAttribute(5));
            bos2Spring = Collections.unmodifiableMap(temp);
        }
    }
}

