/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction.springframework.jndi;

import com.kingdee.bos.transaction.springframework.jndi.JndiCallback;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JndiTemplate {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties environment;

    public JndiTemplate() {
    }

    public JndiTemplate(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JndiCallback contextCallback) throws NamingException {
        Context ctx = this.createInitialContext();
        try {
            Object object = contextCallback.doInContext(ctx);
            return object;
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException ex) {
                this.logger.warn((Object)"Could not close JNDI InitialContext", (Throwable)ex);
            }
        }
    }

    protected Context createInitialContext() throws NamingException {
        return new InitialContext(this.getEnvironment());
    }

    public Object lookup(final String name) throws NamingException {
        return this.execute(new JndiCallback(){

            @Override
            public Object doInContext(Context ctx) throws NamingException {
                JndiTemplate.this.logger.debug((Object)("Looking up JNDI object with name '" + name + "'"));
                Object located = ctx.lookup(name);
                if (located == null) {
                    throw new NamingException("JNDI object with '" + name + "' not found: JNDI implementation returned null");
                }
                return located;
            }
        });
    }

    public void bind(final String name, final Object object) throws NamingException {
        this.execute(new JndiCallback(){

            @Override
            public Object doInContext(Context ctx) throws NamingException {
                JndiTemplate.this.logger.debug((Object)("Binding JNDI object with name '" + name + "'"));
                ctx.bind(name, object);
                return null;
            }
        });
    }

    public void unbind(final String name) throws NamingException {
        this.execute(new JndiCallback(){

            @Override
            public Object doInContext(Context ctx) throws NamingException {
                JndiTemplate.this.logger.debug((Object)("Unbinding JNDI object with name '" + name + "'"));
                ctx.unbind(name);
                return null;
            }
        });
    }
}

