/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction.springframework.transaction.interceptor;

import com.kingdee.bos.transaction.springframework.transaction.interceptor.TransactionAttribute;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.TransactionAttributeEditor;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.TransactionAttributeSource;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NameMatchTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    protected static final Log logger = LogFactory.getLog(NameMatchTransactionAttributeSource.class);
    private Map nameMap = new HashMap();

    public void setNameMap(Map nameMap) {
        this.nameMap = nameMap;
    }

    public void setProperties(Properties transactionAttributes) {
        TransactionAttributeEditor tae = new TransactionAttributeEditor();
        for (String string : transactionAttributes.keySet()) {
            String value = transactionAttributes.getProperty(string);
            tae.setAsText(value);
            TransactionAttribute attr = (TransactionAttribute)tae.getValue();
            this.addTransactionalMethod(string, attr);
        }
    }

    public void addTransactionalMethod(String methodName, TransactionAttribute attr) {
        logger.debug((Object)("Adding transactional method [" + methodName + "] with attribute [" + attr + "]"));
        this.nameMap.put(methodName, attr);
    }

    @Override
    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        String methodName = method.getName();
        TransactionAttribute attr = (TransactionAttribute)this.nameMap.get(methodName);
        if (attr != null) {
            return attr;
        }
        String bestNameMatch = null;
        for (String mappedName : this.nameMap.keySet()) {
            if (!this.isMatch(methodName, mappedName) || bestNameMatch != null && bestNameMatch.length() > mappedName.length()) continue;
            attr = (TransactionAttribute)this.nameMap.get(mappedName);
            bestNameMatch = mappedName;
        }
        return attr;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return mappedName.endsWith("*") && methodName.startsWith(mappedName.substring(0, mappedName.length() - 1)) || mappedName.startsWith("*") && methodName.endsWith(mappedName.substring(1, mappedName.length()));
    }
}

