/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction.springframework.transaction.interceptor;

import com.kingdee.bos.transaction.springframework.transaction.interceptor.DefaultTransactionAttribute;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.RollbackRuleAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleBasedTransactionAttribute
extends DefaultTransactionAttribute {
    protected static final Log logger = LogFactory.getLog(RuleBasedTransactionAttribute.class);
    private List rollbackRules;

    public RuleBasedTransactionAttribute() {
        this.rollbackRules = new ArrayList();
    }

    public RuleBasedTransactionAttribute(int propagationBehavior, List rollbackRules) {
        super(propagationBehavior);
        this.rollbackRules = rollbackRules;
    }

    public void setRollbackRules(List rollbackRules) {
        this.rollbackRules = rollbackRules;
    }

    public List getRollbackRules() {
        return this.rollbackRules;
    }

    @Override
    public boolean rollbackOn(Throwable t) {
        logger.debug((Object)("Applying rules to determine whether transaction should rollback on " + t));
        RollbackRuleAttribute winner = null;
        int deepest = Integer.MAX_VALUE;
        if (this.rollbackRules != null) {
            for (RollbackRuleAttribute rule : this.rollbackRules) {
                int depth = rule.getDepth(t);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                winner = rule;
            }
        }
        logger.debug((Object)("Winning rollback rule is: " + winner));
        if (winner == null) {
            logger.debug((Object)"No relevant rollback rule found: applying superclass default");
            return super.rollbackOn(t);
        }
        return !(winner instanceof NoRollbackRuleAttribute);
    }

    @Override
    public String toString() {
        StringBuffer result = this.getDefinitionDescription();
        TreeSet<String> rules = new TreeSet<String>();
        for (RollbackRuleAttribute rule : this.rollbackRules) {
            String sign = rule instanceof NoRollbackRuleAttribute ? "+" : "-";
            rules.add(sign + rule.getExceptionName());
        }
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            result.append(',');
            result.append(it.next());
        }
        return result.toString();
    }
}

