/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction.springframework.transaction.jta;

import com.kingdee.bos.transaction.springframework.transaction.TransactionSystemException;
import com.kingdee.bos.transaction.springframework.transaction.TransactionUsageException;
import com.kingdee.bos.transaction.springframework.transaction.jta.JtaTransactionManager;
import java.lang.reflect.Method;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class WebLogicJtaTransactionManager
extends JtaTransactionManager {
    public static final String DEFAULT_TRANSACTION_MANAGER_NAME = "javax.transaction.TransactionManager";
    private static final String TRANSACTION_MANAGER_CLASS_NAME = "weblogic.transaction.TransactionManager";
    private final Method forceResumeMethod;

    public WebLogicJtaTransactionManager() {
        this.setTransactionManagerName(DEFAULT_TRANSACTION_MANAGER_NAME);
        try {
            Class<?> transactionManagerClass = this.getClass().getClassLoader().loadClass(TRANSACTION_MANAGER_CLASS_NAME);
            this.forceResumeMethod = transactionManagerClass.getMethod("forceResume", Transaction.class);
        }
        catch (Exception ex) {
            throw new TransactionUsageException("Couldn't initialize WebLogicJtaTransactionManager because WebLogic API classes are not available", ex);
        }
    }

    @Override
    protected void doJtaResume(Transaction suspendedTransaction) throws SystemException {
        try {
            this.getTransactionManager().resume(suspendedTransaction);
        }
        catch (InvalidTransactionException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Standard JTA resume threw InvalidTransactionException: " + ex.getMessage() + " - trying WebLogic JTA forceResume"));
            }
            try {
                this.forceResumeMethod.invoke((Object)this.getTransactionManager(), suspendedTransaction);
            }
            catch (Exception ex2) {
                throw new TransactionSystemException("Could not invoke WebLogic's forceResume method", ex2);
            }
        }
    }
}

