/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction.springframework.transaction.support;

import com.kingdee.bos.transaction.springframework.transaction.support.TransactionSynchronization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TransactionSynchronizationManager {
    private static final Log logger = LogFactory.getLog(TransactionSynchronizationManager.class);
    private static ThreadLocal resources = new ThreadLocal();
    private static final ThreadLocal synchronizations = new ThreadLocal();

    public static Map getResourceMap() {
        HashMap map = (HashMap)resources.get();
        if (map == null) {
            map = new HashMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public static boolean hasResource(Object key) {
        Map map = (Map)resources.get();
        return map != null && map.containsKey(key);
    }

    public static Object getResource(Object key) {
        Map map = (Map)resources.get();
        if (map == null) {
            return null;
        }
        Object value = map.get(key);
        if (value != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved value [" + value + "] for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    public static void bindResource(Object key, Object value) throws IllegalStateException {
        HashMap<Object, Object> map = (HashMap<Object, Object>)resources.get();
        if (map == null) {
            map = new HashMap<Object, Object>();
            resources.set(map);
        }
        if (map.containsKey(key)) {
            throw new IllegalStateException("Already value [" + map.get(key) + "] for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        map.put(key, value);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound value [" + value + "] for key [" + key + "] to thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    public static Object unbindResource(Object key) throws IllegalStateException {
        Map map = (Map)resources.get();
        if (map == null || !map.containsKey(key)) {
            throw new IllegalStateException("No value for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        Object value = map.remove(key);
        if (map.isEmpty()) {
            resources.set(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed value [" + value + "] for key [" + key + "] from thread [" + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    public static boolean isSynchronizationActive() {
        return synchronizations.get() != null;
    }

    public static void initSynchronization() throws IllegalStateException {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot activate transaction synchronization - already active");
        }
        logger.debug((Object)"Initializing transaction synchronization");
        synchronizations.set(new ArrayList());
    }

    public static void registerSynchronization(TransactionSynchronization synchronization) throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        ((List)synchronizations.get()).add(synchronization);
    }

    public static List getSynchronizations() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        return Collections.unmodifiableList(new ArrayList((List)synchronizations.get()));
    }

    public static void clearSynchronization() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot deactivate transaction synchronization - not active");
        }
        logger.debug((Object)"Clearing transaction synchronization");
        synchronizations.set(null);
    }
}

