/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util.rpc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.rpc.AjaxFacadeFactory;
import com.kingdee.bos.util.rpc.IAjaxFacade;
import com.kingdee.bos.util.rpc.WebProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Ajax {
    public static final int MAX_LEVEL = 16;
    private static Logger log = Logger.getLogger((String)Ajax.class.getName());
    private static String AJAX_SCRIPT;
    private static Hashtable proxies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String register(Class target, String namespace) throws BOSException {
        String name = target.getName();
        WebProxy proxy = (WebProxy)proxies.get(name);
        if (proxy == null) {
            Hashtable hashtable = proxies;
            synchronized (hashtable) {
                proxy = (WebProxy)proxies.get(name);
                if (proxy == null) {
                    proxy = new WebProxy(target);
                    proxies.put(name, proxy);
                    proxies.put(proxy.getUuid(), proxy);
                }
            }
        }
        if (namespace == null || namespace.length() == 0) {
            int i = name.lastIndexOf(46);
            i = i < 0 ? 0 : ++i;
            namespace = name.substring(i);
        }
        return proxy.getUuid() + "," + namespace;
    }

    public static String register(Class[] targets, String[] namespaces) throws BOSException {
        StringBuffer sb = new StringBuffer();
        if (namespaces == null) {
            namespaces = new String[targets.length];
        }
        for (int i = 0; i < targets.length; ++i) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(Ajax.register(targets[i], namespaces[i]));
        }
        return sb.toString();
    }

    public static void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain; charset=utf-8");
        response.setHeader("X-xss-protection", "1;mode=block");
        PrintWriter out = response.getWriter();
        out.println(AJAX_SCRIPT);
        out.print("_$$_ajax_url='");
        String url = request.getRequestURL().toString();
        int k = url.indexOf(47, 7);
        out.print(url.substring(k));
        out.print("';\r\n\r\n");
        String[] uuids = request.getQueryString().split(";");
        for (int i = 0; i < uuids.length; ++i) {
            String tmp = uuids[i];
            int j = tmp.indexOf(44);
            String uuid = tmp.substring(0, j);
            WebProxy proxy = (WebProxy)proxies.get(uuid);
            if (proxy == null) continue;
            out.print(proxy.getJavaScript());
            String ns = tmp.substring(j + 1);
            out.print("\r\n var " + ns + "=" + proxy.getNameSpace() + ";\r\n");
        }
    }

    public static void doPost(HttpServletRequest request, HttpServletResponse response, Context ctx) throws IOException {
        response.setContentType("text/xml; charset=utf-8");
        PrintWriter out = response.getWriter();
        WebProxy proxy = null;
        String methodName = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse((InputStream)request.getInputStream());
            NodeList nodes = doc.getDocumentElement().getElementsByTagName("P");
            Object[] parameters = new Object[nodes.getLength()];
            int j = nodes.getLength();
            for (int i = 0; i < j; ++i) {
                Node node = nodes.item(i).getFirstChild();
                parameters[i] = node != null ? Ajax.toObject(node.getNodeValue()) : null;
            }
            String methodId = request.getQueryString();
            int i = methodId.indexOf("$");
            methodName = methodId.substring(i + 1);
            proxy = (WebProxy)proxies.get(methodId.substring(0, i));
            Object result = null;
            IAjaxFacade ajaxfacade = AjaxFacadeFactory.createRemoteAjaxFacade();
            result = ajaxfacade.invoke(proxy.getTarget(), methodName, parameters);
            out.print("OK:");
            String s = Ajax.toString(result);
            out.print(s);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append("ajax invoke failed!");
            if (proxy != null) {
                sb.append(" calss=").append(proxy.getTarget());
            }
            if (methodName != null) {
                sb.append(" method=").append(methodName);
            }
            log.error((Object)sb.toString(), (Throwable)e);
            Throwable t = e.getCause();
            if (t == null) {
                t = e;
            }
            out.print("FAILED:see server log for details");
        }
    }

    static WebProxy getProxy(String proxyId) {
        return (WebProxy)proxies.get(proxyId);
    }

    public static String escape(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        int j = s.length();
        block8: for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    public static String toString(Object o) {
        StringBuffer sb = new StringBuffer();
        Ajax.toString(o, sb, 0);
        return sb.toString();
    }

    public static StringBuffer toString(Object o, StringBuffer buffer, int level) {
        if (level >= 16) {
            throw new RuntimeException("Collection or Map nested level is too deep, and there may be exist a recursive reference.");
        }
        if (o == null) {
            return buffer.append("null");
        }
        if (o instanceof Object[]) {
            return Ajax.toString((Object[])o, buffer, level + 1);
        }
        if (o instanceof Collection) {
            return Ajax.toString((Collection)o, buffer, level + 1);
        }
        if (o instanceof Map) {
            return Ajax.toString((Map)o, buffer, level + 1);
        }
        if (o instanceof Date) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)o);
            return buffer.append("new Date(").append(c.get(1)).append(",").append(c.get(2)).append(",").append(c.get(5)).append(",").append(c.get(10)).append(",").append(c.get(12)).append(",").append(c.get(13)).append(")");
        }
        if (o instanceof Integer) {
            return buffer.append(o);
        }
        if (o instanceof Number) {
            return buffer.append("new Number(").append(o.toString()).append(")");
        }
        if (o instanceof Boolean) {
            return buffer.append(o.toString());
        }
        return buffer.append(Ajax.escape(o.toString()));
    }

    public static StringBuffer toString(Collection l, StringBuffer buffer, int level) {
        buffer.append("([");
        Iterator it = l.iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            Ajax.toString(it.next(), buffer, level + 1);
        }
        buffer.append("])");
        return buffer;
    }

    public static StringBuffer toString(Object[] a, StringBuffer buffer, int level) {
        buffer.append("([");
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            Ajax.toString(a[i], buffer, level + 1);
        }
        buffer.append("])");
        return buffer;
    }

    public static StringBuffer toString(Map m, StringBuffer buffer, int level) {
        Iterator it = m.keySet().iterator();
        buffer.append("({");
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            Object key = it.next();
            Ajax.toString(key, buffer, level + 1);
            buffer.append(":");
            Object value = m.get(key);
            Ajax.toString(value, buffer, level + 1);
        }
        buffer.append("})");
        return buffer;
    }

    public static Object toObject(String json) throws IOException {
        StringReader sr = new StringReader(json);
        return Ajax.asObject(sr);
    }

    private static Object asObject(StringReader sr) throws IOException {
        int i = sr.read();
        if (i == 40) {
            i = sr.read();
        }
        switch (i) {
            case 34: 
            case 42: 
            case 91: 
            case 123: {
                return Ajax.asObject(sr, i);
            }
        }
        throw new RuntimeException("invalid json format");
    }

    private static Object asObject(StringReader sr, int priorChar) throws IOException {
        switch (priorChar) {
            case 34: {
                return Ajax.asString(sr);
            }
            case 91: {
                return Ajax.asList(sr);
            }
            case 123: {
                return Ajax.asMap(sr);
            }
            case 42: {
                return null;
            }
        }
        throw new RuntimeException("invalid json format");
    }

    private static Object asString(StringReader s) throws IOException {
        StringBuffer sb = new StringBuffer();
        int c = s.read();
        while (c >= 0) {
            block0 : switch (c) {
                case 34: {
                    return sb.toString();
                }
                case 92: {
                    c = s.read();
                    switch (c) {
                        case 114: {
                            sb.append("\r");
                            break block0;
                        }
                        case 110: {
                            sb.append("\n");
                            break block0;
                        }
                        case 39: {
                            sb.append("'");
                            break block0;
                        }
                        case 34: {
                            sb.append("\"");
                            break block0;
                        }
                        case 116: {
                            sb.append("\t");
                            break block0;
                        }
                        case 92: {
                            sb.append("\\");
                            break block0;
                        }
                    }
                    throw new RuntimeException("\\" + (char)c + " is not valid char.");
                }
                default: {
                    sb.append((char)c);
                }
            }
            c = s.read();
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private static ArrayList asList(StringReader s) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int c = s.read();
        while (c >= 0) {
            switch (c) {
                case 93: {
                    return list;
                }
                case 40: 
                case 41: 
                case 44: {
                    break;
                }
                case 34: 
                case 42: 
                case 91: 
                case 123: {
                    list.add(Ajax.asObject(s, c));
                    break;
                }
                default: {
                    throw new RuntimeException("char {" + (char)c + "} is an invalid char.");
                }
            }
            c = s.read();
        }
        return list;
    }

    private static HashMap asMap(StringReader s) throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int c = s.read();
        while (c >= 0) {
            switch (c) {
                case 125: {
                    return map;
                }
                case 40: 
                case 41: 
                case 44: {
                    break;
                }
                case 34: 
                case 42: 
                case 91: 
                case 123: {
                    Object key = Ajax.asObject(s, c);
                    s.read();
                    Object value = Ajax.asObject(s);
                    map.put(key, value);
                    break;
                }
                default: {
                    throw new RuntimeException("char {" + (char)c + "} is an invalid char.");
                }
            }
            c = s.read();
        }
        return map;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value1");
        map.put("key2", "value2");
        map.put("key3", "value3");
        Object[] array = new Object[]{"1", "2", new String[]{"s1", "s2"}, map, "xx"};
        String s = Ajax.toString(array);
        Object o = Ajax.toObject(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            String s;
            ClassLoader loader = Ajax.class.getClassLoader();
            String file = Ajax.class.getPackage().getName().replace('.', '/') + "/ajax.js";
            URL url = loader.getResource(file);
            is = url.openConnection().getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "gb2312"));
            StringBuffer sb = new StringBuffer();
            while ((s = reader.readLine()) != null) {
                sb.append(s).append("\r\n");
            }
            AJAX_SCRIPT = sb.toString();
        }
        catch (Exception e) {
            log.error((Object)"ajax initiated failed!", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"close is inputStream error!", (Throwable)e);
            }
        }
        proxies = new Hashtable();
    }
}

