/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util.rpc;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.rpc.IRpcProxy;
import com.kingdee.bos.util.rpc.ObjectFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class RpcProxy
extends AbstractBOSObject
implements IRpcProxy {
    private static final long serialVersionUID = 2190482382954068157L;
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"RPCWRAP");

    public static Object wrapNoSupport(Class _interface) {
        if (!_interface.isInterface()) {
            throw new RuntimeException(_interface + " isn't an interface.");
        }
        return Proxy.newProxyInstance(_interface.getClassLoader(), new Class[]{_interface}, (InvocationHandler)new Bridge(_interface, false));
    }

    public static Object wrapNoSupport(Class _interface, String implClass) {
        if (!_interface.isInterface()) {
            throw new RuntimeException(_interface + " isn't a interface.");
        }
        return Proxy.newProxyInstance(_interface.getClassLoader(), new Class[]{_interface}, (InvocationHandler)new Bridge(implClass, false));
    }

    public static Object wrapRequired(Class _interface) {
        if (!_interface.isInterface()) {
            throw new RuntimeException(_interface + " isn't a interface.");
        }
        return Proxy.newProxyInstance(_interface.getClassLoader(), new Class[]{_interface}, (InvocationHandler)new Bridge(_interface, true));
    }

    public static Object wrapRequired(Class _interface, String implClass) {
        if (!_interface.isInterface()) {
            throw new RuntimeException(_interface + " isn't a interface.");
        }
        return Proxy.newProxyInstance(_interface.getClassLoader(), new Class[]{_interface}, (InvocationHandler)new Bridge(implClass, true));
    }

    public RpcProxy() {
        super.registerInterface(IRpcProxy.class, (Object)this);
    }

    public RpcProxy(Context ctx) {
        super(ctx);
        super.registerInterface(IRpcProxy.class, (Object)this);
    }

    @Override
    public Object invokeNotSupport(String className, String method, String[] types, Object[] params) throws BOSException {
        return this.invoke(className, method, types, params, false);
    }

    @Override
    public Object invokeRequired(String className, String method, String[] types, Object[] params) throws BOSException {
        return this.invoke(className, method, types, params, true);
    }

    private Object invoke(String className, String method, String[] types, Object[] params, boolean transactional) throws BOSException {
        Class cls = ObjectFactory.getClass(className);
        Class[] ptypes = new Class[types.length];
        for (int i = 0; i < ptypes.length; ++i) {
            ptypes[i] = ObjectFactory.getClass(types[i]);
        }
        Method m = ObjectFactory.getMethod(cls, method, ptypes);
        Object o = ObjectFactory.newInstance(cls, new Class[]{Context.class}, new Object[]{this.getContext()});
        if (transactional) {
            return ObjectFactory.invokeRequired(o, m, params);
        }
        return ObjectFactory.invoke(o, m, params);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    private static IRpcProxy getRemoteInstance() throws BOSException {
        IRpcProxy svc = (IRpcProxy)BOSObjectFactory.createRemoteBOSObject((String)RpcProxy.class.getName(), IRpcProxy.class);
        return svc;
    }

    private static class Bridge
    implements InvocationHandler {
        private IRpcProxy rpc = null;
        private String remoteClass;
        private boolean transactional;

        Bridge() {
            try {
                this.rpc = RpcProxy.getRemoteInstance();
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
        }

        Bridge(Class _interface, boolean transactional) {
            this();
            String tmp = _interface.getName();
            int i = tmp.lastIndexOf(".");
            this.remoteClass = tmp.substring(0, i) + ".app." + tmp.substring(i + 2);
            this.transactional = transactional;
        }

        Bridge(String remoteClass, boolean transactional) {
            this();
            this.remoteClass = remoteClass;
            this.transactional = transactional;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?>[] types = method.getParameterTypes();
            String[] s_types = new String[types.length];
            for (int i = 0; i < s_types.length; ++i) {
                s_types[i] = types[i].getName();
            }
            if (this.transactional) {
                return this.rpc.invokeRequired(this.remoteClass, method.getName(), s_types, args);
            }
            return this.rpc.invokeNotSupport(this.remoteClass, method.getName(), s_types, args);
        }
    }
}

