package com.kingdee.bos.streamwork.calculator;
import java_cup.runtime.Symbol;

%%

%eofval{
  return new Symbol(sym.EOF, null);
%eofval}

//%class Flexer
%cup
%unicode

AND=[Aa][Nn][Dd]
OR=[Oo][Rr]
NOT=[Nn][Oo][Tt]
XOR=[Xx][Oo][Rr]
TRUE=[Tt][Rr][Uu][Ee]
FALSE=[Ff][Aa][Ll][Ss][Ee]
NULL=[Nn][Uu][Ll][Ll]
ALPHA = [a-zA-Z]
ALNUM = [a-zA-Z_0-9]
IDENT = {ALPHA}{ALNUM}*
BRACKETID = \[[^\]\n\f\r\t]*\]
INSTRING = [^\"\n\f\r\t]
INSTRING2 = [^'\n\f\r\t]
DIGIT=[0-9]
//INTEGER=(-)?{DIGIT}+
INTEGER={DIGIT}+
EXP = ([eE](\+|\-)?{DIGIT}+)
FLOAT = ({DIGIT}+\.{DIGIT}*{EXP}?|{DIGIT}*\.{DIGIT}+{EXP}?|{DIGIT}+{EXP})
LINETEMINATOR=[\r|\n|\r\n]
INPUTCHARACTER=[^\r\n]
WHITESPACE={LINETEMINATOR}|[ \t\f]

%cup
%unicode


%state AFTER_AS1
%state AFTER_AS2

%%
	{AND} { return new Symbol(sym.AND, yytext()); }
	{OR} { return new Symbol(sym.OR, yytext()); }
	{XOR} { return new Symbol(sym.XOR, yytext()); }
	{NOT} { return new Symbol(sym.NOT, yytext()); }
	{TRUE} { return new Symbol(sym.TRUE, yytext()); }
	{FALSE} { return new Symbol(sym.FALSE, yytext()); }
	{NULL} { return new Symbol(sym.NULL, yytext()); }
	":" { return new Symbol(sym.COLON, ":"); }
	"?" { return new Symbol(sym.QUESTION, "?"); }
	";" { return new Symbol(sym.SIMICOLON, ";"); }
	"," { return new Symbol(sym.COMMA, ","); }
	"=" { return new Symbol(sym.EQ, "="); }
	"<>" { return new Symbol(sym.NE, "<>"); }
	"<=" { return new Symbol(sym.LE, "<="); }
	"<" { return new Symbol(sym.LT, "<"); }
	">=" { return new Symbol(sym.GE, ">="); }
	">" { return new Symbol(sym.GT, ">"); }
	"{" { return new Symbol(sym.LBRACE, "{"); }
	"(" { return new Symbol(sym.LPAREN, "("); }
	"}" { return new Symbol(sym.RBRACE, "}"); }
	")" { return new Symbol(sym.RPAREN, ")"); }
	"+" { return new Symbol(sym.PLUS, "+"); }
	"-" { return new Symbol(sym.MINUS, "-"); }
	"*" { return new Symbol(sym.ASTERISK, "*"); }
	"/" { return new Symbol(sym.SOLIDUS, "/"); }
	"&" { return new Symbol(sym.CONCAT, "&"); }
	"." { return new Symbol(sym.DOT, "."); }

	{INTEGER} { Integer i = new Integer(yytext()); return new Symbol(sym.INTEGER, i); }
	{FLOAT} { Double d = new Double(yytext()); return new Symbol(sym.NUMBER, d); }
	{IDENT} { return new Symbol(sym.ID, yytext()); }
	{BRACKETID} { return new Symbol(sym.QUOTED_ID, yytext()); }
	"\""{INSTRING}*"\"" { return new Symbol(sym.STRING, yytext()); }
	"'"{INSTRING2}*"'" { return new Symbol(sym.STRING, yytext()); }
	{WHITESPACE} { /* ignore white space. */ }