/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.CacheEvent;
import com.kingdee.bos.cache.CacheEventListener;
import com.kingdee.bos.cache.CacheReference;
import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.cache.LockHandle;
import com.kingdee.bos.cache.impl.ObjectBase;
import com.kingdee.bos.cache.impl.Region;
import com.kingdee.bos.cache.impl.RegionReference;
import com.kingdee.bos.cache.impl.Value;
import com.kingdee.bos.cache.impl.util;
import java.util.Vector;

class BaseReference
implements CacheReference {
    ObjectBase obj;
    protected Vector locks = new Vector();
    private Object releaseTrace = util.traceRelease("CacheObject or Region");

    BaseReference(ObjectBase _obj) {
        this.obj = _obj;
    }

    protected Region region() {
        return (Region)this.obj;
    }

    protected Value object() {
        return (Value)this.obj;
    }

    @Override
    public boolean isRegion() {
        return this.obj instanceof Region;
    }

    @Override
    public boolean isObject() {
        return this.obj instanceof Value;
    }

    @Override
    public void addEventListener(CacheEventListener l) {
        this.obj.addEventListener(l);
    }

    @Override
    public void removeEventListener(CacheEventListener l) {
        this.obj.removeEventListener(l);
    }

    @Override
    public void notifyEvent(CacheEvent e) {
        this.obj.notifyEvent(e);
    }

    @Override
    public Object getName() {
        return this.obj.getName();
    }

    @Override
    public Object[] getPath() {
        return this.obj.getPath().names;
    }

    @Override
    public CacheRegion getParent() {
        if (this.obj.parent == null) {
            return null;
        }
        return new RegionReference(this.obj.parent);
    }

    @Override
    public void enable(boolean b) {
        this.obj.enabled(b);
    }

    @Override
    public void invalidate() {
        this.obj.invalidate();
    }

    @Override
    public void destroy() {
        this.obj.destroy(true, true);
    }

    @Override
    public boolean isDisabled() {
        return this.obj.isDisabled();
    }

    @Override
    public boolean isInvalid() {
        return this.obj.isInvalid();
    }

    @Override
    public boolean isDestroyed() {
        return this.obj.isDestroyed();
    }

    @Override
    public long getLiveTime() {
        return this.obj.getLiveTime();
    }

    @Override
    public long getIdleTime() {
        return this.obj.getIdleTime();
    }

    @Override
    public LockHandle lockRead(long timeout) {
        return this.createLockHandle(this.obj.lock(1, timeout));
    }

    @Override
    public LockHandle lockRead() {
        return this.createLockHandle(this.obj.lock(1));
    }

    @Override
    public LockHandle lockWrite(long timeout) {
        return this.createLockHandle(this.obj.lock(2, timeout));
    }

    @Override
    public LockHandle lockWrite() {
        return this.createLockHandle(this.obj.lock(2));
    }

    private LockHandle createLockHandle(LockHandle handle) {
        return new _LockHandle(handle);
    }

    @Override
    public void release() {
        if (this.locks != null) {
            for (int i = this.locks.size() - 1; i >= 0; --i) {
                try {
                    ((LockHandle)this.locks.elementAt(i)).unlock();
                    continue;
                }
                catch (Throwable e) {
                    util.logError(e);
                }
            }
            this.locks = null;
        }
        this.obj = null;
    }

    protected void finalize() throws Throwable {
        if (this.locks != null && this.locks.size() > 0) {
            this.release();
            util.logError(this.releaseTrace.toString());
        }
    }

    @Override
    public Object getTreeAttribute(int index) {
        return this.obj.getTreeAttribute(index);
    }

    @Override
    public Object getCurrentAttribute(int index) {
        return this.obj.getCurrentAttribute(index);
    }

    private class _LockHandle
    implements LockHandle {
        LockHandle handle;

        _LockHandle(LockHandle _handle) {
            this.handle = _handle;
            BaseReference.this.locks.addElement(this.handle);
        }

        @Override
        public void unlock() {
            if (this.handle != null) {
                this.handle.unlock();
                BaseReference.this.locks.removeElement(this.handle);
                this.handle = null;
            }
        }
    }
}

