/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.cache.LockHandle;
import com.kingdee.bos.cache.impl.DistributeService;
import com.kingdee.bos.cache.impl.MultiAccess;
import com.kingdee.bos.cache.impl.ObjectBase;
import com.kingdee.bos.cache.impl.ObjectPath;
import com.kingdee.bos.cache.impl.RemoteValue;
import com.kingdee.bos.cache.impl.ServiceImpl;
import com.kingdee.bos.cache.impl.Value;
import com.kingdee.bos.cache.impl.util;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.WeakHashMap;

public class DistributeServiceImpl
implements DistributeService {
    static WeakHashMap globalOwners = new WeakHashMap();
    static Hashtable lockHandles = new Hashtable();
    static WeakHashMap owners = new WeakHashMap();
    static Hashtable remoteLocks = new Hashtable();

    @Override
    public String getIdentity() {
        return ServiceImpl.getIdentity();
    }

    @Override
    public void test() {
    }

    @Override
    public void addService(DistributeService service) {
        ServiceImpl.addService(service);
    }

    @Override
    public void removeService(String identity) {
        ServiceImpl.removeService(identity);
    }

    @Override
    public Object lockObject(String serviceId, Object owner, ObjectPath path, int type, long timeout) {
        ObjectBase obj = ServiceImpl.getObject(path);
        if (obj == null || !obj.isDistributed()) {
            return null;
        }
        LockHandle handle = obj.lock(DistributeServiceImpl.getGlobalOwner(owner), type, timeout, false);
        return DistributeServiceImpl.addLockHandle(serviceId, handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getGlobalOwner(Object owner) {
        WeakHashMap weakHashMap = globalOwners;
        synchronized (weakHashMap) {
            Object x = globalOwners.get(owner);
            if (x == null) {
                x = owner;
                globalOwners.put(owner, owner);
            }
            return x;
        }
    }

    @Override
    public void unlockObject(String serviceId, Object handle) {
        DistributeServiceImpl.unlockHandle(serviceId, handle);
    }

    static void distributeLock(MultiAccess handle, ObjectPath path, Object owner, int type) {
        try {
            DistributeService[] services = ServiceImpl.getRemoteServices();
            for (int i = 0; i < services.length; ++i) {
                DistributeServiceImpl.remoteLock(services[i], handle, path, owner, type);
            }
        }
        catch (Throwable e) {
            handle.unlock();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CacheException("Distribute lock failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hashtable getLockHandles(String serviceId) {
        Hashtable hashtable = lockHandles;
        synchronized (hashtable) {
            Hashtable locks = (Hashtable)lockHandles.get(serviceId);
            if (locks == null) {
                locks = new Hashtable();
                lockHandles.put(serviceId, locks);
            }
            return locks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object addLockHandle(String serviceId, LockHandle handle) {
        Hashtable locks = DistributeServiceImpl.getLockHandles(serviceId);
        Object key = util.uniqueKey();
        Hashtable hashtable = locks;
        synchronized (hashtable) {
            locks.put(key, handle);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unlockHandle(String serviceId, Object key) {
        Hashtable locks;
        Hashtable hashtable = locks = DistributeServiceImpl.getLockHandles(serviceId);
        synchronized (hashtable) {
            LockHandle handle = (LockHandle)locks.get(key);
            if (handle != null) {
                handle.unlock();
            } else {
                util.logError(new Error("LockHandle not exists '" + serviceId + key + "'"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearLockHandles(String serviceId) {
        Hashtable locks;
        Hashtable hashtable = locks = DistributeServiceImpl.getLockHandles(serviceId);
        synchronized (hashtable) {
            Object[] hs = locks.values().toArray();
            for (int i = 0; i < hs.length; ++i) {
                ((LockHandle)hs[i]).unlock();
            }
            locks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearRemoteLocks(String serviceId) {
        Hashtable hashtable = remoteLocks;
        synchronized (hashtable) {
            if (serviceId == null) {
                remoteLocks.clear();
            } else {
                remoteLocks.remove(serviceId);
            }
        }
        hashtable = lockHandles;
        synchronized (hashtable) {
            if (serviceId != null) {
                DistributeServiceImpl.clearLockHandles(serviceId);
                lockHandles.remove(serviceId);
            } else {
                Object[] keys = lockHandles.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    DistributeServiceImpl.clearLockHandles((String)keys[i]);
                }
                lockHandles.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getOwner(Object owner) {
        WeakHashMap weakHashMap = owners;
        synchronized (weakHashMap) {
            Object key = owners.get(owner);
            if (key == null) {
                key = new ThreadOwner(owner.toString(), util.uniqueKey());
                owners.put(owner, key);
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hashtable getRemoteLocks(String serviceId, Object owner) {
        Hashtable hashtable = remoteLocks;
        synchronized (hashtable) {
            Hashtable locks1;
            WeakHashMap locks = (WeakHashMap)remoteLocks.get(serviceId);
            if (locks == null) {
                locks = new WeakHashMap();
                remoteLocks.put(serviceId, locks);
            }
            if ((locks1 = (Hashtable)locks.get(owner)) == null) {
                locks1 = new Hashtable();
                locks.put(owner, locks1);
            }
            return locks1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remoteLock(DistributeService service, MultiAccess handle, ObjectPath path, Object owner, int type) {
        Hashtable locks;
        LockKey key = new LockKey(path, type);
        Hashtable hashtable = locks = DistributeServiceImpl.getRemoteLocks(service.getIdentity(), owner);
        synchronized (hashtable) {
            LockRef ref = (LockRef)locks.get(key);
            if (ref == null) {
                Object h = service.lockObject(ServiceImpl.getIdentity(), DistributeServiceImpl.getOwner(owner), path, type, handle.getTimeout());
                if (h == null) {
                    return;
                }
                ref = new LockRef(service, h);
                locks.put(key, ref);
            }
            ref.addRef();
            handle.addLockHandle(ref);
        }
    }

    @Override
    public void enabled(ObjectPath path, boolean b) {
        ObjectBase obj = ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            obj.enabledThis(b);
        }
    }

    @Override
    public void invalidate(ObjectPath path) {
        ObjectBase obj = ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            obj.invalidateThis();
        }
    }

    @Override
    public void destroy(ObjectPath path) {
        ObjectBase obj = ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            obj.destroyThis();
        }
    }

    @Override
    public RemoteValue search(ObjectPath path) {
        Value obj = (Value)ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            return obj.getRemoteValue();
        }
        return null;
    }

    @Override
    public void prepareUpdate(ObjectPath path, Object args) throws Exception {
        Value obj = (Value)ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            obj.prepareUpdate(args, false);
        }
    }

    @Override
    public void finishUpdate(ObjectPath path) {
        Value obj = (Value)ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            obj.finishUpdate(false);
        }
    }

    @Override
    public void cancelUpdate(ObjectPath path) {
        Value obj = (Value)ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            obj.cancelUpdate(false);
        }
    }

    @Override
    public Object remoteLoad(ObjectPath path) throws NullPointerException {
        Value obj = (Value)ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            return obj.get();
        }
        throw new NullPointerException();
    }

    @Override
    public void reload(ObjectPath path) {
        Value obj = (Value)ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            obj.reloadThis();
        }
    }

    @Override
    public void replace(ObjectPath path, Object x) {
        Value obj = (Value)ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            obj.replaceThis(x);
        }
    }

    @Override
    public void setWeak(ObjectPath path, boolean b) {
        Value obj = (Value)ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            obj.setWeakThis(b);
        }
    }

    @Override
    public void discard(ObjectPath path) {
        Value obj = (Value)ServiceImpl.getObject(path);
        if (obj != null && obj.isDistributed()) {
            obj.discardThis();
        }
    }

    static class LockRef
    implements LockHandle {
        int refs;
        Object handle;
        DistributeService service;

        LockRef(DistributeService _service, Object _handle) {
            this.service = _service;
            this.handle = _handle;
            this.refs = 0;
        }

        public synchronized int addRef() {
            ++this.refs;
            return this.refs;
        }

        public synchronized int release() {
            --this.refs;
            if (this.refs == 0) {
                this.service.unlockObject(ServiceImpl.getIdentity(), this.handle);
            }
            return this.refs;
        }

        @Override
        public void unlock() {
            this.release();
        }
    }

    static class LockKey {
        ObjectPath path;
        int type;
        int h;

        LockKey(ObjectPath _path, int _type) {
            this.path = _path;
            this.type = _type;
            this.h = this.path.hashCode();
            this.h = this.h + (this.h << 5) + this.type;
        }

        public int hashCode() {
            return this.h;
        }

        public boolean equals(Object x) {
            if (x == null) {
                return false;
            }
            if (x instanceof LockKey) {
                LockKey ref = (LockKey)x;
                return ref.type == this.type && ref.path.equals(this.path);
            }
            return false;
        }
    }

    static class ThreadOwner
    implements Serializable {
        String id = ServiceImpl.getIdentity();
        Object key;
        String name;

        ThreadOwner(String _name, Object _key) {
            this.key = _key;
            this.name = _name;
        }

        public String toString() {
            return this.id + "." + this.name;
        }

        public boolean equals(Object x) {
            if (x == null || !(x instanceof ThreadOwner)) {
                return false;
            }
            ThreadOwner to = (ThreadOwner)x;
            return to.id.equals(this.id) && to.key.equals(this.key);
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.key.hashCode();
        }
    }
}

