/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.cache.CacheObject;
import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.cache.ObjectAttributes;
import com.kingdee.bos.cache.ObjectMonitor;
import com.kingdee.bos.cache.RegionAttributes;
import com.kingdee.bos.cache.ServiceAttributes;
import com.kingdee.bos.cache.impl.DistributeService;
import com.kingdee.bos.cache.impl.DistributeServiceCreator;
import com.kingdee.bos.cache.impl.DistributeServiceImpl;
import com.kingdee.bos.cache.impl.ObjectBase;
import com.kingdee.bos.cache.impl.ObjectPath;
import com.kingdee.bos.cache.impl.Region;
import com.kingdee.bos.cache.impl.ServiceListener;
import com.kingdee.bos.cache.impl.ServiceMonitor;
import com.kingdee.bos.cache.impl.Value;
import com.kingdee.bos.cache.impl.util;
import java.util.Hashtable;
import java.util.Vector;

public class ServiceImpl {
    public static final String LOCAL_ROOT = "LOCAL_ROOT";
    static ServiceAttributes config = null;
    private static ServiceMonitor monitor = null;
    private static Hashtable objects;
    private static Vector monitors;
    private static Region rootRegion;
    private static Region localRootRegion;
    static Hashtable url2ids;
    static volatile DistributeServiceCreator remoteCreator;
    static Hashtable remotes;

    public static ServiceAttributes getServiceAttributes() {
        return config;
    }

    public static boolean isServiceStarted() {
        return monitor != null;
    }

    public static synchronized void startService(ServiceAttributes _config) {
        if (rootRegion != null) {
            throw new CacheException("Cache Service already started.");
        }
        if (_config == null) {
            _config = new ServiceAttributes();
        }
        config = _config;
        String[] remoteUrls = config.getDistributeServices();
        rootRegion = new Region(config.getRootName(), null, config.getRootRegionAttributes(), config.getRootRegionDefaultObjectAttributes());
        if (remoteUrls != null) {
            for (int i = 0; i < remoteUrls.length; ++i) {
                try {
                    ServiceImpl.addDistributeService(remoteUrls[i]);
                    continue;
                }
                catch (Throwable e) {
                    util.logError(e);
                }
            }
        }
        util.logInfo("Cache Service '" + ServiceImpl.getIdentity() + "' started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stopService() {
        ServiceImpl.checkService();
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                services[i].removeService(ServiceImpl.getIdentity());
                continue;
            }
            catch (Throwable e) {
                util.logDebug(e);
            }
        }
        Hashtable hashtable = remotes;
        synchronized (hashtable) {
            remotes.clear();
        }
        url2ids.clear();
        DistributeServiceImpl.clearRemoteLocks(null);
        rootRegion.destroy(true, true);
        rootRegion = null;
    }

    static DistributeServiceCreator getRemoteCreator() {
        if (remoteCreator == null) {
            try {
                remoteCreator = (DistributeServiceCreator)Class.forName("com.kingdee.bos.cache.impl.remote.Creator").newInstance();
            }
            catch (Exception ce) {
                throw new CacheException(ce);
            }
        }
        return remoteCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addDistributeService(String serverUrl) {
        ServiceImpl.checkService();
        String id = (String)url2ids.get(serverUrl);
        if (id != null) {
            Hashtable hashtable = remotes;
            synchronized (hashtable) {
                if (remotes.containsKey(id)) {
                    return;
                }
            }
        }
        DistributeService service = ServiceImpl.getRemoteCreator().createRemote(serverUrl);
        id = service.getIdentity();
        Hashtable hashtable = remotes;
        synchronized (hashtable) {
            if (!remotes.containsKey(id)) {
                ServiceImpl.addService(service);
                url2ids.put(serverUrl, id);
                service.addService(new DistributeServiceImpl());
            }
        }
    }

    public static String getIdentity() {
        return config.getString(1, util.getGlobalIdentity());
    }

    public static synchronized void removeDistributeService(String serverUrl) {
        DistributeService service;
        ServiceImpl.checkService();
        String id = (String)url2ids.get(serverUrl);
        if (id != null && (service = ServiceImpl.getService(id)) != null) {
            ServiceImpl.removeService(id);
            try {
                service.removeService(ServiceImpl.getIdentity());
            }
            catch (Throwable e) {
                util.logDebug(e);
            }
            DistributeServiceImpl.clearRemoteLocks(id);
        }
        url2ids.remove(serverUrl);
    }

    static void checkService() {
        if (rootRegion == null) {
            throw new CacheException("Cache Service not start.");
        }
    }

    public static synchronized CacheRegion getRootRegion() {
        ServiceImpl.checkService();
        return (CacheRegion)rootRegion.getReference();
    }

    public static synchronized CacheRegion getLocalRootRegion() {
        return (CacheRegion)localRootRegion.getReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheRegion getRegion(Object[] names) {
        ObjectPath path = new ObjectPath(names, true);
        Hashtable hashtable = objects;
        synchronized (hashtable) {
            Region region = (Region)objects.get(path);
            if (region == null) {
                return null;
            }
            return (CacheRegion)region.getReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheObject getObject(Object[] names) {
        ObjectPath path = new ObjectPath(names, true);
        Hashtable hashtable = objects;
        synchronized (hashtable) {
            Value v = (Value)objects.get(path);
            if (v == null) {
                return null;
            }
            return (CacheObject)v.getReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addService(DistributeService service) {
        Hashtable hashtable = remotes;
        synchronized (hashtable) {
            String id = service.getIdentity();
            util.logInfo("addDistributeService '" + id + "'");
            remotes.put(service.getIdentity(), service);
            ServiceImpl.getRemoteCreator().installEventListener(service, new ServiceEvent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeService(String identity) {
        Hashtable hashtable = remotes;
        synchronized (hashtable) {
            util.logInfo("removeDistributeService '" + identity + "'");
            remotes.remove(identity);
            DistributeServiceImpl.clearRemoteLocks(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DistributeService getService(String id) {
        Hashtable hashtable = remotes;
        synchronized (hashtable) {
            return (DistributeService)remotes.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DistributeService[] getRemoteServices() {
        Vector<DistributeService> services = new Vector<DistributeService>();
        Object[] keys = null;
        Hashtable hashtable = remotes;
        synchronized (hashtable) {
            keys = remotes.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            DistributeService service = ServiceImpl.getService((String)keys[i]);
            try {
                if (service == null) continue;
                service.test();
                services.addElement(service);
                continue;
            }
            catch (Throwable e) {
                ServiceImpl.removeService((String)keys[i]);
            }
        }
        Object[] ss = new DistributeService[services.size()];
        services.copyInto(ss);
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectBase getObject(ObjectPath path) {
        Hashtable hashtable = objects;
        synchronized (hashtable) {
            return (ObjectBase)objects.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addObject(ObjectBase obj) {
        util.logInfo("new " + obj.getPath().toString());
        Hashtable hashtable = objects;
        synchronized (hashtable) {
            objects.put(obj.getPath(), obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeObject(ObjectPath path) {
        util.logInfo("remove " + path.toString());
        Hashtable hashtable = objects;
        synchronized (hashtable) {
            objects.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectBase[] getObjects() {
        Hashtable hashtable = objects;
        synchronized (hashtable) {
            ObjectBase[] objs = new ObjectBase[objects.size()];
            objects.values().toArray(objs);
            return objs;
        }
    }

    public static synchronized void addMonitor(ObjectMonitor monitor) {
        monitors.addElement(monitor);
    }

    public static synchronized void remoteMonitor(ObjectMonitor monitor) {
        monitors.removeElement(monitor);
    }

    public static synchronized ObjectMonitor[] getMonitors() {
        Object[] ms = new ObjectMonitor[monitors.size()];
        monitors.copyInto(ms);
        return ms;
    }

    static {
        rootRegion = null;
        objects = new Hashtable();
        monitors = new Vector();
        localRootRegion = new Region(LOCAL_ROOT, null, new RegionAttributes(), new ObjectAttributes());
        ServiceImpl.localRootRegion.distributed = false;
        monitor = new ServiceMonitor();
        monitor.start();
        url2ids = new Hashtable();
        remoteCreator = null;
        remotes = new Hashtable();
    }

    private static class ServiceEvent
    implements ServiceListener {
        boolean used = true;

        private ServiceEvent() {
        }

        @Override
        public void serviceClosed(String id) {
            if (this.used) {
                ServiceImpl.removeService(id);
            }
        }
    }
}

