/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.impl.OperationTrace;
import com.kingdee.bos.util.ThreadPool;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class util {
    private static final Logger l = Logger.getLogger((String)"com.kingdee.bos.cache.impl.util");
    private static DatagramSocket name_sock = null;
    private static String name_prefix = null;
    private static int name_index = 0;
    private static ThreadPool threadPool = new ThreadPool("Cache Service", 1, 5);
    private static long long_seq = 0L;
    private static Object long_seq_lock = new Object();

    public static void logWarning(String msg) {
        l.log(Priority.WARN, (Object)msg);
    }

    public static void logInfo(String msg) {
        l.log(Priority.INFO, (Object)msg);
    }

    public static void logDebug(String msg) {
        l.log(Priority.DEBUG, (Object)msg);
    }

    public static void logDebug(String msg, Throwable e) {
        l.log(Priority.DEBUG, (Object)msg, e);
    }

    public static void logDebug(Throwable e) {
        util.logDebug(e.getMessage(), e);
    }

    public static void logError(String msg) {
        l.log(Priority.ERROR, (Object)msg);
    }

    public static void logError(String msg, Throwable e) {
        l.log(Priority.ERROR, (Object)msg, e);
    }

    public static void logError(Throwable e) {
        util.logError(e.getMessage(), e);
    }

    public static Object traceRelease(String name) {
        name = name + " not released. must release following object manually.";
        if (l.isDebugEnabled()) {
            return new OperationTrace(name);
        }
        return name + " enable debug option in log4j for more information.";
    }

    static synchronized String getGlobalIdentity() {
        if (name_sock == null) {
            try {
                name_sock = new DatagramSocket();
                name_prefix = InetAddress.getLocalHost().getHostName() + "_" + name_sock.getLocalPort();
            }
            catch (Exception e) {
                l.warn((Object)e, (Throwable)e);
            }
        }
        return name_prefix;
    }

    static synchronized String newName() {
        return util.getGlobalIdentity() + "_" + ++name_index;
    }

    public static void startThread(Runnable runner) {
        threadPool.run(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object uniqueKey() {
        Object object = long_seq_lock;
        synchronized (object) {
            return long_seq++;
        }
    }

    static void assertThat(boolean b, String failedReason) {
        if (!b) {
            throw new Error("assert failed, resion : " + failedReason);
        }
    }

    static void assertThat(boolean b) {
        util.assertThat(b, "");
    }

    public static String[] splitString(String path, int seperator) {
        Vector<String> v = new Vector<String>();
        while (true) {
            int i;
            if ((i = path.indexOf(seperator)) < 0) {
                if (path.length() <= 0) break;
                v.addElement(path);
                break;
            }
            v.addElement(path.substring(0, i));
            path = path.substring(i + 1);
        }
        Object[] names = new String[v.size()];
        v.copyInto(names);
        return names;
    }
}

