/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache;

import com.kingdee.bos.jcache.CacheException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class Event
implements Serializable {
    public static final int CREATE = 101;
    public static final int DESTROY = 102;
    public static final int VALUE_CHANGED = 201;
    public static final int SEND_NOTIFY_CHANGE = 301;
    public static final int RECEIVE_NOTIFY_CHANGE = 302;
    public static final int MONITOR = 401;
    public static final int USER_DEFINED = 1001;
    public final int id;
    public final Object source;
    public final Object parameter;
    public Object returnValue = null;
    private String name = null;

    public Event(int id, Object source, Object parameter) {
        this.id = id;
        this.source = source;
        this.parameter = parameter;
    }

    public void cancel() {
        throw new CacheException(106, "");
    }

    private Object ps() {
        if (this.parameter == null) {
            return null;
        }
        if (this.parameter.getClass().isArray()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            for (int i = 0; i < Array.getLength(this.parameter); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Array.get(this.parameter, i));
            }
            sb.append("}");
            return sb.toString();
        }
        return this.parameter;
    }

    public String name() {
        if (this.name == null) {
            Class<?> cls = this.getClass();
            Field[] fds = cls.getFields();
            for (int i = 0; i < fds.length; ++i) {
                Field f = fds[i];
                int m = f.getModifiers();
                if (!Modifier.isStatic(m) || !Modifier.isPublic(m) || !Modifier.isFinal(m) || !f.getType().equals(Integer.TYPE)) continue;
                try {
                    int val = (Integer)f.get(null);
                    if (val != this.id) continue;
                    this.name = f.getName();
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.name == null) {
                this.name = "(" + this.id + ")";
            }
        }
        return this.name;
    }

    public String toString() {
        return "Event(id=" + this.name() + ", source=" + this.source + ", parameter=" + this.ps() + ")";
    }
}

