/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache;

import com.kingdee.bos.jcache.CacheException;
import com.kingdee.bos.jcache.ObjectRef;
import java.lang.ref.WeakReference;
import org.apache.log4j.Logger;

public abstract class ObjectHandler {
    private static final Logger logger = Logger.getLogger(ObjectHandler.class);
    Meta meta = new Meta();

    public synchronized void init(ObjectRef ref) {
        if (this.meta.ref != null) {
            throw new CacheException(111, ref.toString() + " handler reused (" + this.meta.ref.toString() + ")");
        }
        this.meta.ref = ref;
    }

    public boolean isWeak() {
        return false;
    }

    public synchronized long getLiveTime() {
        if (this.meta.liveStartTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.meta.liveStartTime;
    }

    public synchronized long getIdleTime() {
        if (this.meta.idleStartTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.meta.idleStartTime;
    }

    public synchronized void enterUse() {
        ++this.meta.useCount;
    }

    public synchronized void leaveUse() {
        --this.meta.useCount;
        this.notifyUse();
    }

    public synchronized void notifyUse() {
        if (this.meta.idleStartTime != 0L) {
            this.meta.idleStartTime = System.currentTimeMillis();
        }
    }

    public synchronized boolean isInUse() {
        return this.meta.useCount > 0;
    }

    protected long getTimeout(ObjectRef ref, boolean checkExists) {
        long timeout = ref.attributes().getLong("timeout", Long.MAX_VALUE);
        if (timeout == Long.MAX_VALUE && checkExists) {
            logger.error((Object)"timeout value not set.", (Throwable)new Exception());
        }
        return timeout;
    }

    public synchronized boolean isNull() {
        return this.get() == null;
    }

    protected void resetTime() {
        if (this.isNull()) {
            this.meta.liveStartTime = 0L;
            this.meta.idleStartTime = 0L;
        } else {
            this.meta.idleStartTime = this.meta.liveStartTime = System.currentTimeMillis();
        }
    }

    public abstract Object get();

    public abstract void set(Object var1);

    public abstract void check(ObjectRef var1);

    public static abstract class Multi
    extends ObjectHandler {
        public final ObjectHandler[] handlers;
        public boolean refreshWhenUse;
        protected int index = 0;

        public Multi(ObjectHandler[] handlers, boolean refreshWhenUse) {
            this.handlers = handlers;
            this.refreshWhenUse = refreshWhenUse;
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].meta = this.meta;
            }
        }

        @Override
        public Object get() {
            return this.handlers[this.index].get();
        }

        @Override
        public void set(Object val) {
            this.handlers[this.index].set(null);
            this.handlers[0].set(val);
            this.resetTime();
        }

        @Override
        public boolean isWeak() {
            return this.handlers[this.index].isWeak();
        }

        @Override
        public synchronized void notifyUse() {
            Object val;
            if (this.refreshWhenUse && this.index > 0 && (val = this.handlers[this.index].get()) != null) {
                long time = this.meta.liveStartTime;
                this.handlers[this.index].set(null);
                this.index = 0;
                this.handlers[this.index].set(val);
                this.meta.liveStartTime = time;
            }
            super.notifyUse();
        }

        @Override
        public synchronized void check(ObjectRef ref) {
            Object val = this.handlers[this.index].get();
            if (val != null) {
                this.handlers[this.index].check(ref);
                if (this.index < this.handlers.length - 1 && this.handlers[this.index].isNull()) {
                    ++this.index;
                    long liveStartTime = this.meta.liveStartTime;
                    this.handlers[this.index].set(val);
                    this.meta.liveStartTime = liveStartTime;
                }
            }
        }
    }

    public static class IdleTimeoutToWeak
    extends Multi {
        public IdleTimeoutToWeak() {
            super(new ObjectHandler[]{new IdleTimeout(), new Weak()}, true);
        }
    }

    public static class LiveTimeoutToWeak
    extends Multi {
        public LiveTimeoutToWeak() {
            super(new ObjectHandler[]{new LiveTimeout(), new Weak()}, false);
        }
    }

    public static class Weak
    extends ObjectHandler {
        WeakReference ref = null;

        @Override
        public Object get() {
            return this.ref == null ? null : this.ref.get();
        }

        @Override
        public void set(Object val) {
            this.ref = val == null ? null : new WeakReference<Object>(val);
            this.resetTime();
        }

        @Override
        public boolean isWeak() {
            return true;
        }

        @Override
        public synchronized void check(ObjectRef _ref) {
            if (this.ref != null && this.ref.get() == null) {
                this.ref = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(_ref + " WeakReference cleard."));
                }
            }
        }
    }

    public static class IdleTimeout
    extends Live {
        @Override
        public synchronized void check(ObjectRef ref) {
            if (this.getIdleTime() > this.getTimeout(ref, true)) {
                this.set(null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(ref + " idle timeout."));
                }
            }
        }
    }

    public static class LiveTimeout
    extends Live {
        @Override
        public synchronized void check(ObjectRef ref) {
            if (this.getLiveTime() > this.getTimeout(ref, true)) {
                this.set(null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(ref + " live timeout."));
                }
            }
        }
    }

    public static class Live
    extends ObjectHandler {
        Object value = null;

        @Override
        public synchronized Object get() {
            return this.value;
        }

        @Override
        public synchronized void set(Object val) {
            this.value = val;
            this.resetTime();
        }

        @Override
        public synchronized void check(ObjectRef ref) {
        }
    }

    static class Meta {
        long liveStartTime = 0L;
        long idleStartTime = 0L;
        int useCount = 0;
        ObjectRef ref = null;

        Meta() {
        }
    }
}

