/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache.impl;

import com.kingdee.bos.jcache.CacheException;
import com.kingdee.bos.jcache.Event;
import com.kingdee.bos.jcache.EventListener;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EventManager {
    private static final Logger logger = Logger.getLogger(EventManager.class);
    private final ArrayList listeners = new ArrayList();
    private Listener[] _listeners = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(int from, int to, EventListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(new Listener(from, to, listener));
            this._listeners = null;
        }
    }

    public void addEventListener(int eventId, EventListener listener) {
        this.addEventListener(eventId, eventId, listener);
    }

    public void addEventListener(EventListener listener) {
        this.addEventListener(Integer.MIN_VALUE, Integer.MAX_VALUE, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(EventListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (((Listener)this.listeners.get((int)i)).listener != listener) continue;
                this.listeners.remove(i);
                break;
            }
            this._listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processEvent(Event event) {
        Listener[] ls;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (this._listeners == null) {
                this._listeners = this.listeners.toArray(new Listener[this.listeners.size()]);
            }
            ls = this._listeners;
        }
        for (int i = 0; i < ls.length; ++i) {
            if (!ls[i].fireEvent(event)) continue;
            return true;
        }
        return false;
    }

    private static class Listener {
        final int from;
        final int to;
        final EventListener listener;

        Listener(int from, int to, EventListener listener) {
            this.from = from;
            this.to = to;
            this.listener = listener;
        }

        boolean fireEvent(Event event) {
            if (event.id >= this.from && event.id <= this.to && this.listener != null) {
                try {
                    this.listener.onEvent(event);
                }
                catch (Throwable e) {
                    if (CacheException.getErrorCode(e) == 106) {
                        return false;
                    }
                    logger.error((Object)"Exception not catched in EventListener", e);
                }
            }
            return true;
        }
    }
}

