/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache.impl;

import com.kingdee.bos.jcache.Attributes;
import com.kingdee.bos.jcache.CacheException;
import com.kingdee.bos.jcache.CacheRef;
import com.kingdee.bos.jcache.Event;
import com.kingdee.bos.jcache.ObjectRef;
import com.kingdee.bos.jcache.Path;
import com.kingdee.bos.jcache.Region;
import com.kingdee.bos.jcache.impl.CacheEngineImpl;
import com.kingdee.bos.jcache.impl.CacheRefImpl;
import com.kingdee.bos.jcache.impl.ObjectRefImpl;
import com.kingdee.bos.jcache.impl.SmartWeakMap;
import com.kingdee.bos.jcache.impl.WeakRegion;
import java.util.ArrayList;

class RegionImpl
extends CacheRefImpl
implements Region {
    final SmartWeakMap refs = new SmartWeakMap();
    private volatile boolean firstUsed = false;

    static RegionImpl create(Object name, RegionImpl parent, Attributes initAttrs) {
        if (initAttrs != null && initAttrs.getBoolean("weakReference", false)) {
            return new WeakRegion(name, parent, initAttrs);
        }
        return new RegionImpl(name, parent, initAttrs);
    }

    protected RegionImpl(Object name, RegionImpl parent, Attributes initAttrs) {
        super(name, true, parent, initAttrs);
    }

    @Override
    public boolean isWeak() {
        return false;
    }

    @Override
    public CacheRef getRefByPath(Path path) {
        return this.getRefByPath(path, false, null);
    }

    @Override
    public CacheRef getRefByPath(Path path, boolean autoCreate, Attributes initAttrs) {
        if (path == null) {
            return this;
        }
        Region region = (Region)this.getRefByPath(path.getParent(), autoCreate, initAttrs);
        if (region == null) {
            return null;
        }
        if (path.isRegion()) {
            return region.getRegion(path.getName(), autoCreate, initAttrs);
        }
        return region.getObjectRef(path.getName(), autoCreate, initAttrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheRef getRef(Object name) {
        Object object = this.monitor;
        synchronized (object) {
            return (CacheRefImpl)this.refs.get(name);
        }
    }

    @Override
    public boolean isRegion(Object name) {
        CacheRef ref = this.getRef(name);
        return ref != null && ref.isRegion();
    }

    public boolean isObject(Object name) {
        CacheRef ref = this.getRef(name);
        return ref != null && !ref.isRegion();
    }

    @Override
    public Region getRegion(Object name) {
        CacheRef ref = this.getRef(name);
        if (ref != null && !ref.isRegion()) {
            throw new CacheException(101, "'" + name + "' is not a region.");
        }
        return (Region)ref;
    }

    @Override
    public void notifyChange(Object name) {
        CacheRef ref = this.getRef(name);
        if (ref != null) {
            ref.notifyChange();
        } else {
            Path path = new Path(this.path(), name, false);
            if (this.isValid() && this.attrs.getBoolean("distributed", false)) {
                this.fireEvent(new Event(301, this, path));
                CacheEngineImpl.distributeNotifyChange(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getRegion(Object name, boolean autoCreate, Attributes initAttrs) {
        Region region = null;
        Object object = this.monitor;
        synchronized (object) {
            region = this.getRegion(name);
            if (region == null && autoCreate) {
                this.validate();
                region = RegionImpl.create(name, this, initAttrs);
                this.refs.put(name, region, region.isWeak());
                this.firstUsed = true;
                this.fireEvent(new Event(101, region, null));
            }
        }
        return region;
    }

    @Override
    protected final void finalDestroy() {
        CacheRefImpl[] rs = (CacheRefImpl[])this.getRefs();
        for (int i = 0; i < rs.length; ++i) {
            rs[i].destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheRef[] getRefs() {
        Object object = this.monitor;
        synchronized (object) {
            return (CacheRefImpl[])this.refs.listValues(CacheRefImpl.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectRef getObjectRef(Object name, boolean autoLoad, Attributes initAttrs) {
        ObjectRefImpl ref = null;
        Object object = this.monitor;
        synchronized (object) {
            Object x = this.refs.get(name);
            if (x != null && !(x instanceof ObjectRefImpl)) {
                throw new CacheException(112, x + " is not a object.");
            }
            ref = (ObjectRefImpl)x;
            if (ref == null && autoLoad) {
                this.validate();
                ref = new ObjectRefImpl(name, this, initAttrs);
                this.refs.put(name, ref, false);
                this.firstUsed = true;
                this.fireEvent(new Event(101, ref, null));
            }
        }
        return ref;
    }

    @Override
    public Object get(Object name, boolean autoLoad, Attributes initAttrs) {
        ObjectRef ref = this.getObjectRef(name, autoLoad, initAttrs);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public Object get(Object name) {
        return this.get(name, this.attrs.getBoolean("autoLoad", true), null);
    }

    @Override
    public void put(Object name, Object value, Attributes initAttrs) {
        ObjectRef ref = this.getObjectRef(name, true, this.attrs);
        ref.put(value);
    }

    @Override
    public void put(Object name, Object value) {
        this.put(name, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object name) {
        CacheRefImpl ref;
        Object object = this.monitor;
        synchronized (object) {
            ref = (CacheRefImpl)this.refs.remove(name);
        }
        if (ref != null) {
            ref.destroy();
        }
        return ref != null;
    }

    @Override
    public void discard(Object name, boolean notifyChange) {
        CacheRef ref = this.getRef(name);
        if (ref != null) {
            ref.discard(notifyChange);
        }
    }

    public void discard(Object name) {
        this.discard(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object object = this.monitor;
        synchronized (object) {
            Object[] names = this.getNames();
            for (int i = 0; i < names.length; ++i) {
                this.remove(names[i]);
            }
        }
    }

    public void discard() {
        this.discard(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard(boolean notifyChange) {
        Object object = this.monitor;
        synchronized (object) {
            CacheRef[] refs = this.getRefs();
            for (int i = 0; i < refs.length; ++i) {
                refs[i].discard(false);
            }
        }
        if (notifyChange) {
            this.notifyChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Object name) {
        Object object = this.monitor;
        synchronized (object) {
            return this.refs.exists(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getNames() {
        Object object = this.monitor;
        synchronized (object) {
            return this.refs.listKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.monitor;
        synchronized (object) {
            return this.refs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.monitor;
        synchronized (object) {
            return this.refs.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAutoDelete(boolean delete) {
        Object object = this.monitor;
        synchronized (object) {
            boolean b;
            boolean bl = b = this.parent != null && this.firstUsed && this.isEmpty() && this.attrs.getBoolean("autoDeleteRegion", false);
            if (b && delete) {
                this.parent.remove(this.name());
            }
            return b;
        }
    }

    @Override
    boolean checkLive() {
        int i;
        if (!this.isValid()) {
            return false;
        }
        ArrayList<CacheRefImpl> q = new ArrayList<CacheRefImpl>();
        CacheRefImpl[] refs = (CacheRefImpl[])this.getRefs();
        for (i = 0; i < refs.length; ++i) {
            if (refs[i].checkLive()) continue;
            q.add(refs[i]);
        }
        Thread.yield();
        if (q.size() > 0) {
            for (i = 0; i < q.size(); ++i) {
                CacheRefImpl ref = (CacheRefImpl)q.get(i);
                if (ref.checkLive()) continue;
                this.remove(ref.name());
            }
        }
        return !this.checkAutoDelete(false);
    }
}

