/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.mdCache.memcached;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class MemcacheStatsSlab {
    private static final Logger logger = Logger.getLogger(MemcacheStatsSlab.class);
    private String serverHost;
    private Map slabs = new TreeMap();

    public MemcacheStatsSlab() {
        Slab node = new Slab();
        node.setSlabNum("0");
        this.slabs.put("0", node);
    }

    public void addSlab(String slabNum, String slabInfo) {
        if (slabNum.indexOf(":") < 0) {
            ((Slab)this.slabs.get("0")).getSlabInfo().put(slabNum, slabInfo);
            return;
        }
        String num = slabNum.substring(0, slabNum.indexOf(":"));
        Slab node = (Slab)this.slabs.get(num);
        if (node == null) {
            node = new Slab();
            node.setSlabNum(num);
        }
        node.getSlabInfo().put(slabNum.substring(slabNum.indexOf(":") + 1), slabInfo);
        this.slabs.put(num, node);
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public Map getSlabs() {
        return this.slabs;
    }

    public void setSlabs(Map slabs) {
        this.slabs = slabs;
    }

    static class SlabKeyComparator
    implements Comparator {
        SlabKeyComparator() {
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            try {
                int i1 = Integer.parseInt(o1.toString());
                int i2 = Integer.parseInt(o2.toString());
                result = i1 - i2;
            }
            catch (Exception ex) {
                logger.warn((Object)ex);
            }
            return result;
        }
    }

    static class Slab {
        private String slabNum;
        private Map slabInfo = new TreeMap();

        public String getSlabNum() {
            return this.slabNum;
        }

        public void setSlabNum(String slabNum) {
            this.slabNum = slabNum;
        }

        public Map getSlabInfo() {
            return this.slabInfo;
        }

        public void setSlabInfo(Map slabInfo) {
            this.slabInfo = slabInfo;
        }

        public String toString() {
            if (this.slabNum.equals("0")) {
                return new StringBuffer().append("Total Slab Info : ").append(this.slabInfo.toString()).toString();
            }
            return new StringBuffer().append("slabNum:  ").append(this.slabNum).append(",slabInfo:  ").append(this.slabInfo.toString()).toString();
        }
    }
}

