/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.mdCache.memcached.client;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;

public class SockIOPool {
    private static Logger log = Logger.getLogger((String)SockIOPool.class.getName());
    private static ConcurrentMap<String, SockIOPool> pools = new ConcurrentHashMap<String, SockIOPool>();
    private static ThreadLocal<MessageDigest> MD5 = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"++++ no md5 algorithm found");
                throw new IllegalStateException("++++ no md5 algorythm found");
            }
        }
    };
    private static final int SOCKET_STATUS_BUSY = 1;
    private static final int SOCKET_STATUS_DEAD = 2;
    private static final int SOCKET_STATUS_ACTIVE = 3;
    public static final int NATIVE_HASH = 0;
    public static final int OLD_COMPAT_HASH = 1;
    public static final int NEW_COMPAT_HASH = 2;
    public static final int CONSISTENT_HASH = 3;
    public static final long MAX_RETRY_DELAY = 60000L;
    public static final Random random = new Random();
    private MaintThread maintThread;
    private boolean initialized = false;
    private int maxCreate = 1;
    private int poolMultiplier = 3;
    private int initConn = 1;
    private int minConn = 1;
    private int maxConn = 10;
    private long maxIdle = 300000L;
    private long maxBusyTime = 30000L;
    private long maintSleep = 30000L;
    private int socketTO = 30000;
    private int socketConnectTO = 3000;
    private static int recBufferSize = 128;
    private boolean aliveCheck = true;
    private boolean failover = true;
    private boolean failback = true;
    private boolean nagle = true;
    private int hashingAlg = 0;
    private final ReentrantLock hostDeadLock = new ReentrantLock();
    private final ReentrantLock initDeadLock = new ReentrantLock();
    private String[] servers;
    public HashSet<String> serverLiveSet;
    private Integer[] weights;
    private Integer totalWeight = 0;
    private List<String> buckets;
    private TreeMap<Long, String> consistentBuckets;
    private ConcurrentMap<String, Date> hostDead;
    private ConcurrentMap<String, Long> hostDeadDur;
    private ConcurrentMap<String, ConcurrentMap<SockIO, Integer>> socketPool;
    private Map<String, SockIO> fastPool;
    private static final byte[] B_VERSION = "version\r\n".getBytes();

    protected SockIOPool() {
    }

    public static SockIOPool getInstance(String poolName) {
        if (!pools.containsKey(poolName)) {
            SockIOPool pool = new SockIOPool();
            pools.putIfAbsent(poolName, pool);
        }
        return (SockIOPool)pools.get(poolName);
    }

    public static String getPoolUsage(String poolName) {
        StringBuffer result = new StringBuffer();
        if (pools.containsKey(poolName)) {
            SockIOPool sockIOPool = (SockIOPool)pools.get(poolName);
            int total = 0;
            int busy = 0;
            int dead = 0;
            for (ConcurrentMap status : sockIOPool.socketPool.values()) {
                total += status.size();
                Iterator iter = status.values().iterator();
                while (iter.hasNext()) {
                    int value = Integer.parseInt(iter.next() + "");
                    if (value == 1) {
                        ++busy;
                    }
                    if (value != 2) continue;
                    ++dead;
                }
            }
            result.append("SockIOPool ").append(poolName).append(" : ").append(" total socket: ").append(total).append(" , busy socket: ").append(busy).append(" , dead socket: ").append(dead);
        }
        return result.toString();
    }

    public static SockIOPool getNewInstance(String poolName) {
        if (!pools.containsKey(poolName)) {
            SockIOPool pool = new SockIOPool();
            pools.putIfAbsent(poolName, pool);
        } else {
            SockIOPool newpool = new SockIOPool();
            SockIOPool pool = (SockIOPool)pools.get(poolName);
            pools.put(poolName, newpool);
            try {
                pool.shutDown();
            }
            catch (Exception ex) {
                log.error((Object)"shutdown old pool error!", (Throwable)ex);
            }
        }
        return (SockIOPool)pools.get(poolName);
    }

    public static void removeInstance(String poolName) {
        if (pools.containsKey(poolName)) {
            SockIOPool pool = (SockIOPool)pools.get(poolName);
            try {
                pool.shutDown();
            }
            catch (Exception ex) {
                log.error((Object)"shutdown old pool error!", (Throwable)ex);
            }
            pools.remove(poolName);
        }
    }

    public static SockIOPool getInstance() {
        return SockIOPool.getInstance("default");
    }

    public void initialize() {
        if (this.initialized && (this.buckets != null || this.consistentBuckets != null) && this.socketPool != null) {
            log.error((Object)"++++ trying to initialize an already initialized pool");
            return;
        }
        this.initDeadLock.lock();
        try {
            if (this.initialized && (this.buckets != null || this.consistentBuckets != null) && this.socketPool != null) {
                log.error((Object)"++++ trying to initialize an already initialized pool");
                return;
            }
            this.socketPool = new ConcurrentHashMap<String, ConcurrentMap<SockIO, Integer>>(this.servers.length * this.initConn);
            this.fastPool = new HashMap<String, SockIO>();
            this.hostDeadDur = new ConcurrentHashMap<String, Long>();
            this.hostDead = new ConcurrentHashMap<String, Date>();
            int n = this.maxCreate = this.poolMultiplier > this.minConn ? this.minConn : this.minConn / this.poolMultiplier;
            if (log.isDebugEnabled()) {
                log.debug((Object)"++++ initializing pool with following settings:");
                log.debug((Object)("++++ initial size: " + this.initConn));
                log.debug((Object)("++++ min spare   : " + this.minConn));
                log.debug((Object)("++++ max spare   : " + this.maxConn));
            }
            if (this.servers.length <= 0) {
                log.error((Object)"++++ trying to initialize with no servers");
                throw new IllegalStateException("++++ trying to initialize with no servers");
            }
            if (this.hashingAlg == 3) {
                this.populateConsistentBuckets();
            } else {
                this.populateBuckets();
            }
            this.initialized = true;
            if (this.maintSleep > 0L) {
                this.startMaintThread();
            }
        }
        finally {
            this.initDeadLock.unlock();
        }
    }

    private void populateBuckets() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"++++ initializing internal hashing structure for consistent hashing");
        }
        this.buckets = new ArrayList<String>();
        block0: for (int i = 0; i < this.servers.length; ++i) {
            if (this.weights != null && this.weights.length > i) {
                for (int k = 0; k < this.weights[i]; ++k) {
                    this.buckets.add(this.servers[i]);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("++++ added " + this.servers[i] + " to server bucket"));
                }
            } else {
                this.buckets.add(this.servers[i]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("++++ added " + this.servers[i] + " to server bucket"));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("+++ creating initial connections (" + this.initConn + ") for host: " + this.servers[i]));
            }
            for (int j = 0; j < this.initConn; ++j) {
                SockIO socket = this.createSocket(this.servers[i]);
                if (socket == null) {
                    log.error((Object)("++++ failed to create connection to: " + this.servers[i] + " -- only " + j + " created."));
                    continue block0;
                }
                this.addSocketToPool(this.socketPool, this.servers[i], socket, 3, 3, true);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("++++ created and added socket: " + socket.toString() + " for host " + this.servers[i]));
            }
        }
    }

    private void populateConsistentBuckets() {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)"++++ initializing internal hashing structure for consistent hashing");
        }
        this.consistentBuckets = new TreeMap();
        MessageDigest md5 = MD5.get();
        if (this.totalWeight <= 0 && this.weights != null) {
            for (i = 0; i < this.weights.length; ++i) {
                SockIOPool sockIOPool = this;
                Integer.valueOf(sockIOPool.totalWeight + (!"".equals(this.weights[i] + "") ? 1 : this.weights[i]));
                sockIOPool.totalWeight = sockIOPool.totalWeight;
            }
        } else if (this.weights == null) {
            this.totalWeight = this.servers.length;
        }
        block1: for (i = 0; i < this.servers.length; ++i) {
            int thisWeight = 1;
            if (this.weights != null && !"".equals(this.weights[i] + "")) {
                thisWeight = this.weights[i];
            }
            double factor = Math.floor((double)(40 * this.servers.length * thisWeight) / (double)this.totalWeight.intValue());
            long j = 0L;
            while ((double)j < factor) {
                byte[] d = md5.digest((this.servers[i] + "-" + j).getBytes());
                for (int h = 0; h < 4; ++h) {
                    long k = (long)(d[3 + h * 4] & 0xFF) << 24 | (long)(d[2 + h * 4] & 0xFF) << 16 | (long)(d[1 + h * 4] & 0xFF) << 8 | (long)(d[0 + h * 4] & 0xFF);
                    this.consistentBuckets.put(k, this.servers[i]);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("++++ added " + this.servers[i] + " to server bucket"));
                }
                ++j;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("+++ creating initial connections (" + this.initConn + ") for host: " + this.servers[i]));
            }
            for (int j2 = 0; j2 < this.initConn; ++j2) {
                SockIO socket = this.createSocket(this.servers[i]);
                if (socket == null) {
                    log.error((Object)("++++ failed to create connection to: " + this.servers[i] + " -- only " + j2 + " created."));
                    continue block1;
                }
                this.addSocketToPool(this.socketPool, this.servers[i], socket, 3, 3, true);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("++++ created and added socket: " + socket.toString() + " for host " + this.servers[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SockIO createSocket(String host) {
        long expire;
        SockIO socket = null;
        this.hostDeadLock.lock();
        try {
            if (this.failover && this.failback && this.hostDead.containsKey(host) && this.hostDeadDur.containsKey(host)) {
                Date store = (Date)this.hostDead.get(host);
                expire = Long.valueOf(this.hostDeadDur.get(host) + "");
                if (store.getTime() + expire > System.currentTimeMillis()) {
                    SockIO sockIO = null;
                    return sockIO;
                }
            }
        }
        finally {
            this.hostDeadLock.unlock();
        }
        try {
            socket = new SockIO(this, host, this.socketTO, this.socketConnectTO, this.nagle);
            if (!socket.isConnected()) {
                log.error((Object)("++++ failed to get SockIO obj for: " + host + " -- new socket is not connected"));
                this.addSocketToPool(this.socketPool, host, socket, 2, 2, true);
            }
        }
        catch (Exception ex) {
            socket = null;
        }
        this.hostDeadLock.lock();
        try {
            if (socket == null) {
                Date now = new Date();
                this.hostDead.put(host, now);
                long l = expire = this.hostDeadDur.containsKey(host) ? (Long)this.hostDeadDur.get(host) * 2L : 1000L;
                if (expire > 60000L) {
                    expire = 60000L;
                }
                this.hostDeadDur.put(host, expire);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("++++ ignoring dead host: " + host + " for " + expire + " ms"));
                }
                this.clearHostFromPool(host);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("++++ created socket (" + socket.toString() + ") for host: " + host));
                }
                if (this.hostDead.containsKey(host) || this.hostDeadDur.containsKey(host)) {
                    this.hostDead.remove(host);
                    this.hostDeadDur.remove(host);
                }
            }
        }
        finally {
            this.hostDeadLock.unlock();
        }
        return socket;
    }

    public String getHost(String key) {
        return this.getHost(key, null);
    }

    public String getHost(String key, Integer hashcode) {
        SockIO socket = this.getSock(key, hashcode);
        String host = socket.getHost();
        socket.close();
        return host;
    }

    public SockIO getSock(String key) {
        return this.getSock(key, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SockIO getSock(String key, Integer hashCode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cache socket pick " + key + " " + hashCode));
        }
        if (!this.initialized) {
            log.error((Object)"attempting to get SockIO from uninitialized pool!");
            return null;
        }
        if (this.hashingAlg == 3) {
            if (this.consistentBuckets.size() == 0) return null;
        }
        if (this.buckets != null && this.buckets.size() == 0) {
            return null;
        }
        if (this.hashingAlg == 3 && this.consistentBuckets.size() == 0 || this.buckets != null && this.buckets.size() == 1) {
            SockIO sock;
            SockIO sockIO = sock = this.hashingAlg == 3 ? this.getConnection(this.consistentBuckets.get(this.consistentBuckets.firstKey()) + "") : this.getConnection(this.buckets.get(0) + "");
            if (sock != null && sock.isConnected()) {
                if (!this.aliveCheck) return sock;
                if (sock.isAlive()) return sock;
                sock.close();
                try {
                    if (this.socketPool.get(sock.getHost()) != null) {
                        ((ConcurrentMap)this.socketPool.get(sock.getHost())).remove(sock);
                    }
                    sock.trueClose();
                    return null;
                }
                catch (IOException ioe) {
                    log.error((Object)"failed to close dead socket");
                }
                return null;
            }
            if (sock == null) return sock;
            this.addSocketToPool(this.socketPool, sock.host, sock, 2, 2, true);
            return sock;
        }
        HashSet<String> tryServers = new HashSet<String>(Arrays.asList(this.servers));
        long bucket = this.getBucket(key, hashCode);
        String server = this.hashingAlg == 3 ? this.consistentBuckets.get(bucket) : this.buckets.get((int)bucket);
        block4: while (!tryServers.isEmpty()) {
            SockIO sock = this.getConnection(server);
            if (log.isDebugEnabled()) {
                log.debug((Object)("cache choose " + server + " for " + key));
            }
            if (sock != null && sock.isConnected()) {
                if (!this.aliveCheck) return sock;
                if (sock.isAlive()) {
                    return sock;
                }
                sock.close();
                try {
                    ConcurrentMap socks = (ConcurrentMap)this.socketPool.get(sock.getHost());
                    if (socks != null) {
                        socks.remove(sock);
                    }
                    sock.trueClose();
                }
                catch (IOException ioe) {
                    log.error((Object)"failed to close dead socket");
                }
                sock = null;
            } else if (sock != null) {
                this.addSocketToPool(this.socketPool, sock.host, sock, 2, 2, true);
            }
            if (!this.failover) {
                return null;
            }
            tryServers.remove(server);
            this.serverLiveSet.remove(server);
            if (tryServers.isEmpty()) return null;
            int rehashTries = 0;
            while (true) {
                if (tryServers.contains(server)) continue block4;
                String newKey = new StringBuffer().append(rehashTries).append(key).toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("rehashing with: " + newKey));
                }
                bucket = this.getBucket(newKey, null);
                server = this.hashingAlg == 3 ? this.consistentBuckets.get(bucket) : this.buckets.get((int)bucket);
                ++rehashTries;
            }
            break;
        }
        return null;
    }

    public SockIO getConnection(String host) {
        SockIO socket;
        if (!this.initialized) {
            log.error((Object)"attempting to get SockIO from uninitialized pool!");
            return null;
        }
        if (host == null) {
            return null;
        }
        if (this.socketPool != null && !this.socketPool.isEmpty()) {
            Map aSockets = (Map)this.socketPool.get(host);
            SockIO socket2 = this.fastPool.get(host);
            if (socket2 != null && this.isFreeSocket(socket2, aSockets)) {
                return socket2;
            }
            if (aSockets != null && !aSockets.isEmpty()) {
                int start = random.nextInt() % aSockets.size();
                if (start < 0) {
                    start *= -1;
                }
                int count = 0;
                Iterator i = aSockets.keySet().iterator();
                while (i.hasNext()) {
                    if (count < start) {
                        i.next();
                        ++count;
                        continue;
                    }
                    socket2 = (SockIO)i.next();
                    if (!this.isFreeSocket(socket2, aSockets)) continue;
                    return socket2;
                }
                i = aSockets.keySet().iterator();
                while (i.hasNext() && count > 0) {
                    socket2 = (SockIO)i.next();
                    if (this.isFreeSocket(socket2, aSockets)) {
                        return socket2;
                    }
                    --count;
                }
            }
        }
        if ((socket = this.createSocket(host)) != null) {
            this.addSocketToPool(this.socketPool, host, socket, 1, 1, true);
        }
        return socket;
    }

    private boolean isFreeSocket(SockIO socket, Map<SockIO, Integer> socketMap) {
        if (socket.isConnected()) {
            if (socketMap.get(socket) == 3) {
                if (!this.addSocketToPool(this.socketPool, socket.getHost(), socket, 3, 1, false)) {
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("++++ moving socket for host (" + socket.getHost() + ") to busy pool ... socket: " + socket));
                }
                return true;
            }
        } else {
            this.addSocketToPool(this.socketPool, socket.getHost(), socket, 2, 2, true);
        }
        return false;
    }

    protected boolean addSocketToPool(ConcurrentMap pool, String host, SockIO socket, Object oldValue, Object newValue, boolean needReplace) {
        ConcurrentMap<SockIO, Object> sockets;
        boolean result = false;
        if (!pool.containsKey(host)) {
            sockets = new ConcurrentHashMap();
            pool.putIfAbsent(host, sockets);
        }
        if ((sockets = (ConcurrentMap)pool.get(host)) != null) {
            if (needReplace) {
                sockets.put(socket, newValue);
                result = true;
            } else {
                return sockets.replace(socket, oldValue, newValue);
            }
        }
        return result;
    }

    protected void updateStatusPool(String host, SockIO socket, int newStatus) {
        if (this.socketPool.containsKey(host)) {
            ((ConcurrentMap)this.socketPool.get(host)).replace(socket, newStatus + "");
        }
    }

    protected void clearHostFromPool(String host) {
        Map sockets = (Map)this.socketPool.remove(host);
        if (sockets != null && sockets.size() > 0) {
            for (SockIO socket : sockets.keySet()) {
                sockets.remove(socket);
                try {
                    socket.trueClose();
                }
                catch (IOException ioe) {
                    log.error((Object)("++++ failed to close socket: " + ioe.getMessage()));
                }
                socket = null;
            }
        }
    }

    private void checkIn(SockIO socket, boolean addToAvail) {
        String host = socket.getHost();
        if (log.isDebugEnabled()) {
            log.debug((Object)("++++ calling check-in on socket: " + socket.toString() + " for host: " + host));
            log.debug((Object)("++++ removing socket (" + socket.toString() + ") from busy pool for host: " + host));
        }
        if (this.socketPool.containsKey(host) && ((Map)this.socketPool.get(host)).containsKey(socket) && (Integer)((Map)this.socketPool.get(host)).get(socket) == 1) {
            this.addSocketToPool(this.socketPool, host, socket, 3, 3, true);
            this.fastPool.put(host, socket);
        }
        if (socket.isConnected() && addToAvail) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("++++ returning socket (" + socket.toString() + " to avail pool for host: " + host));
            }
        } else {
            this.addSocketToPool(this.socketPool, host, socket, 2, 2, true);
        }
    }

    private void checkIn(SockIO socket) {
        this.checkIn(socket, true);
    }

    protected void closeSocketPool() {
        for (String host : this.socketPool.keySet()) {
            Map sockets = (Map)this.socketPool.get(host);
            for (SockIO socket : sockets.keySet()) {
                sockets.remove(socket);
                try {
                    socket.trueClose(false);
                }
                catch (IOException ioe) {
                    log.error((Object)("++++ failed to trueClose socket: " + socket.toString() + " for host: " + host));
                }
                socket = null;
            }
        }
    }

    public void shutDown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"++++ SockIOPool shutting down...");
        }
        if (this.maintThread != null && this.maintThread.isRunning()) {
            this.stopMaintThread();
            while (this.maintThread.isRunning()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"++++ waiting for main thread to finish run +++");
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"++++ closing all internal pools.");
        }
        this.closeSocketPool();
        this.socketPool.clear();
        this.fastPool.clear();
        this.socketPool = null;
        this.fastPool = null;
        this.buckets = null;
        this.consistentBuckets = null;
        this.hostDeadDur = null;
        this.hostDead = null;
        this.maintThread = null;
        this.initialized = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"++++ SockIOPool finished shutting down.");
        }
    }

    protected void startMaintThread() {
        if (this.maintThread != null) {
            if (this.maintThread.isRunning()) {
                log.error((Object)"main thread already running");
            } else {
                this.maintThread.start();
            }
        } else {
            this.maintThread = new MaintThread(this);
            this.maintThread.setInterval(this.maintSleep);
            this.maintThread.start();
        }
    }

    protected void stopMaintThread() {
        if (this.maintThread != null && this.maintThread.isRunning()) {
            this.maintThread.stopThread();
        }
    }

    private void removeDeadSock(String host) {
        ConcurrentMap sockets = (ConcurrentMap)this.socketPool.get(host);
        if (sockets == null || sockets.size() == 0) {
            return;
        }
        for (SockIO sock : sockets.keySet()) {
            if (sock.isAlive()) continue;
            sock.close();
            try {
                if (this.socketPool.get(sock.getHost()) != null) {
                    ((ConcurrentMap)this.socketPool.get(sock.getHost())).remove(sock);
                }
                sock.trueClose();
            }
            catch (IOException ioe) {
                log.error((Object)"failed to close dead socket");
            }
            sock = null;
        }
    }

    protected void selfMaint() {
        ConcurrentMap sockets;
        if (log.isDebugEnabled()) {
            log.debug((Object)"++++ Starting self maintenance....");
        }
        HashMap<String, Integer> needSockets = new HashMap<String, Integer>();
        for (int i = 0; i < this.servers.length; ++i) {
            String string = this.servers[i];
            this.removeDeadSock(string);
            if (!this.verifyHost(string) || (sockets = (ConcurrentHashMap)this.socketPool.get(string)) != null) continue;
            needSockets.put(string, this.minConn);
        }
        for (String string : this.socketPool.keySet()) {
            sockets = (ConcurrentMap)this.socketPool.get(string);
            if (sockets == null) {
                sockets = new ConcurrentHashMap();
                this.socketPool.putIfAbsent(string, sockets);
                sockets = (ConcurrentMap)this.socketPool.get(string);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("++++ Size of avail pool for host (" + string + ") = " + sockets.size()));
            }
            if (sockets == null || sockets.size() >= this.minConn) continue;
            int need = this.minConn - sockets.size();
            needSockets.put(string, need);
        }
        for (Map.Entry entry : needSockets.entrySet()) {
            SockIO socket;
            String host = (String)entry.getKey();
            Integer need = new Integer(entry.getValue() + "");
            if (log.isDebugEnabled()) {
                log.debug((Object)("++++ Need to create " + need + " new sockets for pool for host: " + host));
            }
            for (int j = 0; j < need && (socket = this.createSocket(host)) != null; ++j) {
                this.serverLiveSet.add(host);
                this.addSocketToPool(this.socketPool, host, socket, 3, 3, true);
            }
        }
        for (String string : this.socketPool.keySet()) {
            int needToClose;
            sockets = (ConcurrentMap)this.socketPool.get(string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("++++ Size of avail pool for host (" + string + ") = " + sockets.size()));
            }
            int active = 0;
            if (sockets == null) {
                sockets = new ConcurrentHashMap();
                this.socketPool.putIfAbsent(string, sockets);
                sockets = (ConcurrentMap)this.socketPool.get(string);
            }
            Iterator iter = sockets.values().iterator();
            while (iter.hasNext()) {
                if ((Integer)iter.next() != 3) continue;
                ++active;
            }
            if (active <= this.maxConn) continue;
            int diff = active - this.maxConn;
            int n = needToClose = diff <= this.poolMultiplier ? diff : diff / this.poolMultiplier;
            if (log.isDebugEnabled()) {
                log.debug((Object)("++++ need to remove " + needToClose + " spare sockets for pool for host: " + string));
            }
            Iterator j = sockets.entrySet().iterator();
            while (j.hasNext() && needToClose > 0) {
                Map.Entry entry = j.next();
                SockIO socket = (SockIO)entry.getKey();
                if ((Integer)entry.getValue() != 3 || !this.addSocketToPool(this.socketPool, string, socket, 3, 2, false)) continue;
                --needToClose;
            }
        }
        for (String string : this.socketPool.keySet()) {
            sockets = (ConcurrentMap)this.socketPool.get(string);
            if (sockets == null) continue;
            for (Map.Entry entry : sockets.entrySet()) {
                SockIO socket = (SockIO)entry.getKey();
                try {
                    Integer status = null;
                    if (socket != null) {
                        status = (Integer)entry.getValue();
                    }
                    if (status == null || status != 2) continue;
                    if (this.socketPool.containsKey(string)) {
                        ((ConcurrentMap)this.socketPool.get(string)).remove(socket);
                    }
                    socket.trueClose(false);
                    socket = null;
                }
                catch (Exception ex) {
                    log.error((Object)"++++ failed to close SockIO obj from deadPool");
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"+++ ending self maintenance.");
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setServers(String[] servers) {
        this.servers = servers;
        this.serverLiveSet = servers != null && servers.length > 0 ? new HashSet<String>(Arrays.asList(servers)) : new HashSet();
    }

    public String[] getServers() {
        return this.servers;
    }

    public Integer[] getWeights() {
        return (Integer[])this.weights.clone();
    }

    public void setWeights(Integer[] weights) {
        if (weights != null) {
            this.weights = (Integer[])weights.clone();
        }
    }

    public void setInitConn(int initConn) {
        this.initConn = initConn;
    }

    public int getInitConn() {
        return this.initConn;
    }

    public void setMinConn(int minConn) {
        this.minConn = minConn;
    }

    public int getMinConn() {
        return this.minConn;
    }

    public void setMaxConn(int maxConn) {
        this.maxConn = maxConn;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxBusyTime(long maxBusyTime) {
        this.maxBusyTime = maxBusyTime;
    }

    public long getMaxBusy() {
        return this.maxBusyTime;
    }

    public void setMaintSleep(long maintSleep) {
        this.maintSleep = maintSleep;
    }

    public long getMaintSleep() {
        return this.maintSleep;
    }

    public void setSocketTO(int socketTO) {
        this.socketTO = socketTO;
    }

    public int getSocketTO() {
        return this.socketTO;
    }

    public void setSocketConnectTO(int socketConnectTO) {
        this.socketConnectTO = socketConnectTO;
    }

    public int getSocketConnectTO() {
        return this.socketConnectTO;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public boolean getFailover() {
        return this.failover;
    }

    public void setFailback(boolean failback) {
        this.failback = failback;
    }

    public boolean getFailback() {
        return this.failback;
    }

    public void setAliveCheck(boolean aliveCheck) {
        this.aliveCheck = aliveCheck;
    }

    public boolean getAliveCheck() {
        return this.aliveCheck;
    }

    public void setNagle(boolean nagle) {
        this.nagle = nagle;
    }

    public boolean getNagle() {
        return this.nagle;
    }

    public void setHashingAlg(int alg) {
        this.hashingAlg = alg;
    }

    public int getHashingAlg() {
        return this.hashingAlg;
    }

    private static long origCompatHashingAlg(String key) {
        long hash = 0L;
        char[] cArr = key.toCharArray();
        for (int i = 0; i < cArr.length; ++i) {
            hash = hash * 33L + (long)cArr[i];
        }
        return hash;
    }

    private static long newCompatHashingAlg(String key) {
        CRC32 checksum = new CRC32();
        checksum.update(key.getBytes());
        long crc = checksum.getValue();
        return crc >> 16 & 0x7FFFL;
    }

    private static long md5HashingAlg(String key) {
        MessageDigest md5 = MD5.get();
        md5.reset();
        md5.update(key.getBytes());
        byte[] bKey = md5.digest();
        long res = (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
        return res;
    }

    private long getHash(String key, Integer hashCode) {
        if (hashCode != null) {
            if (this.hashingAlg == 3) {
                return hashCode.longValue() & 0xFFFFFFFFL;
            }
            return hashCode.longValue();
        }
        switch (this.hashingAlg) {
            case 0: {
                return key.hashCode();
            }
            case 1: {
                return SockIOPool.origCompatHashingAlg(key);
            }
            case 2: {
                return SockIOPool.newCompatHashingAlg(key);
            }
            case 3: {
                return SockIOPool.md5HashingAlg(key);
            }
        }
        this.hashingAlg = 0;
        return key.hashCode();
    }

    private long getBucket(String key, Integer hashCode) {
        long hc = this.getHash(key, hashCode);
        if (this.hashingAlg == 3) {
            return this.findPointFor(hc);
        }
        long bucket = hc % (long)this.buckets.size();
        if (bucket < 0L) {
            bucket *= -1L;
        }
        return bucket;
    }

    public HashSet<String> getServerLiveSet() {
        return this.serverLiveSet;
    }

    public void setServerLiveSet(HashSet<String> serverSet) {
        this.serverLiveSet = serverSet;
    }

    private Long findPointFor(Long hv) {
        SortedMap<Long, String> tmap = this.consistentBuckets.tailMap(hv);
        return tmap.isEmpty() ? this.consistentBuckets.firstKey() : tmap.firstKey();
    }

    private boolean verifyHost(String host) {
        if (host == null || "".equals(host)) {
            return false;
        }
        int i = host.indexOf(":");
        return i != -1 && i != 0 && i != host.length() - 1;
    }

    public static class SockIO {
        private static Logger log = Logger.getLogger((String)SockIO.class.getName());
        private SockIOPool pool;
        private String host;
        private Socket sock;
        private DataInputStream in;
        private BufferedOutputStream out;
        private byte[] recBuf;
        private int recBufSize = 1028;
        private int recIndex = 0;
        private long aliveTimeStamp = 0L;

        public SockIO(SockIOPool pool, String host, int port, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
            this.pool = pool;
            this.recBuf = new byte[this.recBufSize];
            this.sock = SockIO.getSocket(host, port, connectTimeout);
            if (timeout >= 0) {
                this.sock.setSoTimeout(timeout);
            }
            this.sock.setTcpNoDelay(noDelay);
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.host = host + ":" + port;
        }

        public SockIO(SockIOPool pool, String host, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
            this.pool = pool;
            this.recBuf = new byte[this.recBufSize];
            int index = host.indexOf(":");
            if (index <= 0) {
                throw new RuntimeException(new StringBuffer().append("host :").append(host).append(" is error,check config file!").toString());
            }
            this.sock = SockIO.getSocket(host.substring(0, index), Integer.parseInt(host.substring(index + 1)), connectTimeout);
            if (timeout >= 0) {
                this.sock.setSoTimeout(timeout);
            }
            this.sock.setTcpNoDelay(noDelay);
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.host = host;
        }

        protected static Socket getSocket(String host, int port, int timeout) throws IOException {
            SocketChannel sock = SocketChannel.open();
            sock.socket().connect(new InetSocketAddress(host, port), timeout);
            return sock.socket();
        }

        public SocketChannel getChannel() {
            return this.sock.getChannel();
        }

        public String getHost() {
            return this.host;
        }

        public void trueClose() throws IOException {
            this.trueClose(true);
        }

        public void trueClose(boolean addToDeadPool) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("++++ Closing socket for real: " + this.toString()));
            }
            this.aliveTimeStamp = 0L;
            this.recBuf = new byte[this.recBufSize];
            this.recIndex = 0;
            boolean err = false;
            StringBuffer errMsg = new StringBuffer();
            if (this.in == null || this.out == null || this.sock == null) {
                err = true;
                errMsg.append("++++ socket or its streams already null in trueClose call");
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    log.error((Object)("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost()));
                    log.error((Object)ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {
                    log.error((Object)("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost()));
                    log.error((Object)ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException ioe) {
                    log.error((Object)("++++ error closing socket: " + this.toString() + " for host: " + this.getHost()));
                    log.error((Object)ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (addToDeadPool && this.sock != null) {
                this.pool.checkIn(this, false);
            }
            this.in = null;
            this.out = null;
            this.sock = null;
            if (err) {
                throw new IOException(errMsg.toString());
            }
        }

        void close() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("++++ marking socket (" + this.toString() + ") as closed and available to return to avail pool"));
            }
            this.recBuf = new byte[this.recBufSize];
            this.recIndex = 0;
            this.pool.checkIn(this);
        }

        boolean isConnected() {
            return this.sock != null && this.sock.isConnected() && !this.sock.isClosed();
        }

        boolean isAlive() {
            long interval;
            if (!this.isConnected()) {
                this.aliveTimeStamp = 0L;
                return false;
            }
            boolean needcheck = true;
            if (this.aliveTimeStamp > 0L && (interval = System.currentTimeMillis() - this.aliveTimeStamp) < 100L) {
                needcheck = false;
            }
            if (needcheck) {
                try {
                    this.write(B_VERSION);
                    this.flush();
                    this.readLine();
                    this.aliveTimeStamp = System.currentTimeMillis();
                }
                catch (IOException ex) {
                    return false;
                }
            }
            return true;
        }

        public byte[] readBytes(int length) throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error((Object)"++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] result = null;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (this.recIndex >= length) {
                bos.write(this.recBuf, 0, length);
                byte[] newBuf = new byte[this.recBufSize];
                if (this.recIndex > length) {
                    System.arraycopy(this.recBuf, length, newBuf, 0, this.recIndex - length);
                }
                this.recBuf = newBuf;
                this.recIndex -= length;
            } else {
                int totalread = length;
                if (this.recIndex > 0) {
                    totalread -= this.recIndex;
                    bos.write(this.recBuf, 0, this.recIndex);
                    this.recBuf = new byte[this.recBufSize];
                    this.recIndex = 0;
                }
                int readCount = 0;
                while (totalread > 0) {
                    readCount = this.in.read(this.recBuf);
                    if (readCount <= 0) continue;
                    if (totalread > readCount) {
                        bos.write(this.recBuf, 0, readCount);
                        this.recBuf = new byte[this.recBufSize];
                        this.recIndex = 0;
                    } else {
                        bos.write(this.recBuf, 0, totalread);
                        byte[] newBuf = new byte[this.recBufSize];
                        System.arraycopy(this.recBuf, totalread, newBuf, 0, readCount - totalread);
                        this.recBuf = newBuf;
                        this.recIndex = readCount - totalread;
                    }
                    totalread -= readCount;
                }
            }
            result = bos.toByteArray();
            if (result == null || result != null && result.length <= 0 && this.recIndex <= 0) {
                throw new IOException("++++ Stream appears to be dead, so closing it down");
            }
            this.aliveTimeStamp = System.currentTimeMillis();
            return result;
        }

        public String readLine() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error((Object)"++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            String result = null;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readCount = 0;
            if (this.recIndex > 0 && this.read(bos)) {
                return bos.toString();
            }
            while ((readCount = this.in.read(this.recBuf, this.recIndex, this.recBuf.length - this.recIndex)) > 0) {
                this.recIndex += readCount;
                if (!this.read(bos)) continue;
            }
            if ((result = bos.toString()) == null || result != null && result.length() <= 0 && this.recIndex <= 0) {
                throw new IOException("++++ Stream appears to be dead, so closing it down");
            }
            this.aliveTimeStamp = System.currentTimeMillis();
            return result;
        }

        private boolean read(ByteArrayOutputStream bos) {
            boolean result = false;
            int index = -1;
            for (int i = 0; i < this.recIndex - 1; ++i) {
                if (this.recBuf[i] != 13 || this.recBuf[i + 1] != 10) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                bos.write(this.recBuf, 0, index);
                byte[] newBuf = new byte[this.recBufSize];
                if (this.recIndex > index + 2) {
                    System.arraycopy(this.recBuf, index + 2, newBuf, 0, this.recIndex - index - 2);
                }
                this.recBuf = newBuf;
                this.recIndex = this.recIndex - index - 2;
                result = true;
            } else if (this.recBuf[this.recIndex - 1] == 13) {
                bos.write(this.recBuf, 0, this.recIndex - 1);
                this.recBuf = new byte[this.recBufSize];
                this.recBuf[0] = 13;
                this.recIndex = 1;
            } else {
                bos.write(this.recBuf, 0, this.recIndex);
                this.recBuf = new byte[this.recBufSize];
                this.recIndex = 0;
            }
            return result;
        }

        void flush() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error((Object)"++++ attempting to write to closed socket");
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.out.flush();
        }

        void write(byte[] b) throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error((Object)"++++ attempting to write to closed socket");
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.out.write(b);
        }

        public int hashCode() {
            return this.sock == null ? 0 : this.sock.hashCode();
        }

        public String toString() {
            return this.sock == null ? "" : this.sock.toString();
        }

        protected void finalize() throws Throwable {
            try {
                if (this.sock != null) {
                    log.error((Object)"++++ closing potentially leaked socket in finalize");
                    this.sock.close();
                }
            }
            catch (Throwable t) {
                log.error((Object)t.getMessage(), t);
            }
            finally {
                super.finalize();
            }
        }
    }

    protected static class MaintThread
    extends Thread {
        private static Logger log = Logger.getLogger((String)MaintThread.class.getName());
        private SockIOPool pool;
        private long interval = 3000L;
        private boolean stopThread = false;
        private boolean running;

        protected MaintThread(SockIOPool pool) {
            this.pool = pool;
            this.setDaemon(true);
            this.setName("MaintThread");
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void stopThread() {
            this.stopThread = true;
            this.interrupt();
        }

        @Override
        public void run() {
            this.running = true;
            while (!this.stopThread) {
                try {
                    Thread.sleep(this.interval);
                    if (!this.pool.isInitialized()) continue;
                    this.pool.selfMaint();
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        log.info((Object)"MaintThread stop !");
                        break;
                    }
                    log.error((Object)"MaintThread error !", (Throwable)e);
                    break;
                }
            }
            this.running = false;
        }
    }
}

