/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.CodeException;
import com.tool.classfile.opc;
import com.tool.classfile.pcodes.Instruction;
import com.tool.classfile.pcodes.InstructionWriter;
import com.tool.classfile.pcodes.LocalVariable;

public class Instruction_var
extends Instruction {
    public final LocalVariable var;
    public final int index;
    public final int inc_value;

    protected Instruction_var(int _op_code, LocalVariable _var, int _index, int _inc_value) {
        super(_op_code);
        this.var = _var;
        this.index = _index;
        this.inc_value = _inc_value;
    }

    protected Instruction_var(int _op_code, LocalVariable _var, int _index) {
        this(_op_code, _var, _index, 0);
    }

    public int length() {
        if (this.op_code == 132) {
            if (this.index < 256 && this.inc_value >= -128 && this.inc_value <= 127) {
                return 3;
            }
            return 6;
        }
        if (this.op_code == 169) {
            if (this.index < 256) {
                return 2;
            }
            return 4;
        }
        if (this.index < 4) {
            return 1;
        }
        if (this.index < 256) {
            return 2;
        }
        return 4;
    }

    protected void finalWrite(InstructionWriter out) {
        CodeException.assertThat(this.index >= 0);
        if (this.op_code == 132) {
            if (this.index < 256 && this.inc_value >= -128 && this.inc_value <= 127) {
                out.writeu1(132);
                out.writeu1(this.index);
                out.writeu1(this.inc_value);
            } else {
                out.writeu1(196);
                out.writeu1(132);
                out.writeu2(this.index);
                out.writeu2(this.inc_value);
            }
        } else if (this.op_code == 169) {
            if (this.index < 256) {
                out.writeu1(169);
                out.writeu1(this.index);
            } else {
                out.writeu1(196);
                out.writeu1(169);
                out.writeu2(this.index);
            }
        } else if (this.index < 4) {
            int im_op = 0;
            switch (this.op_code) {
                case 21: {
                    im_op = 26;
                    break;
                }
                case 22: {
                    im_op = 30;
                    break;
                }
                case 23: {
                    im_op = 34;
                    break;
                }
                case 24: {
                    im_op = 38;
                    break;
                }
                case 25: {
                    im_op = 42;
                    break;
                }
                case 54: {
                    im_op = 59;
                    break;
                }
                case 55: {
                    im_op = 63;
                    break;
                }
                case 56: {
                    im_op = 67;
                    break;
                }
                case 57: {
                    im_op = 71;
                    break;
                }
                case 58: {
                    im_op = 75;
                    break;
                }
                default: {
                    CodeException.assertThat(false);
                }
            }
            out.writeu1(im_op + this.index);
        } else if (this.index < 256) {
            out.writeu1(this.op_code);
            out.writeu1(this.index);
        } else {
            out.writeu1(196);
            out.writeu1(this.op_code);
            out.writeu2(this.index);
        }
    }

    public String toString() {
        String s = opc.opc_names[this.op_code] + " #" + this.index;
        if (this.var.name != null) {
            s = s + " (" + this.var + ")";
        }
        if (this.op_code == 132) {
            s = s + " " + this.inc_value;
        }
        return s;
    }
}

