/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.monitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class Monitor
extends Thread {
    private static final Logger logger = Logger.getLogger(Monitor.class);
    private List<MonitorWorker> workers = Collections.synchronizedList(new ArrayList(4));
    private final Setting setting;

    public Monitor(Setting setting) {
        super(setting.getName());
        this.setDaemon(true);
        this.setting = setting;
    }

    @Override
    public void run() {
        while (true) {
            try {
                block5: while (true) {
                    Thread.sleep(this.setting.getIntervalTime());
                    MonitorWorker[] ar = this.workers.toArray(new MonitorWorker[0]);
                    int i = 0;
                    while (true) {
                        if (i >= ar.length) continue block5;
                        try {
                            ar[i].checkWork(System.currentTimeMillis());
                        }
                        catch (Throwable e) {
                            logger.error((Object)"Metadata Monitor Error.", e);
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
                continue;
            }
            break;
        }
    }

    public void addMonitor(Runnable worker) {
        this.addMonitor(worker, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(Runnable worker, long intervalTime) {
        if (!this.isAlive()) {
            Monitor monitor = this;
            synchronized (monitor) {
                if (!this.isAlive()) {
                    this.start();
                }
            }
        }
        this.workers.add(new MonitorWorker(worker, intervalTime));
    }

    public static interface Setting {
        public String getName();

        public long getIntervalTime();
    }

    private static class MonitorWorker {
        Runnable worker;
        long intervalTime;
        long lastTime = System.currentTimeMillis();

        MonitorWorker(Runnable worker, long intervalTime) {
            this.worker = worker;
            this.intervalTime = intervalTime;
        }

        Runnable getWorker() {
            return this.worker;
        }

        void checkWork(long currentTime) {
            if (currentTime - this.lastTime >= this.intervalTime) {
                this.lastTime = currentTime;
                Runnable worker = this.getWorker();
                if (worker != null) {
                    worker.run();
                }
            }
        }
    }
}

