/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import com.kingdee.bos.util.Identity;
import com.kingdee.util.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class MultiParamKeyString {
    private static final Logger logger = Logger.getLogger(MultiParamKeyString.class);

    public static String zip(String s) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(bOut);
        zipOut.write(s.getBytes("UTF-8"));
        return new String(bOut.toByteArray(), "UTF-8");
    }

    public static String uzip(String s) throws IOException {
        int bSize;
        byte[] tempBuf;
        ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(s.getBytes("UTF-8")));
        int length = zipIn.read(tempBuf = new byte[bSize = 16]);
        if (length < 0) {
            throw new EOFException();
        }
        byte[] buffer = new byte[length];
        System.arraycopy(tempBuf, 0, buffer, 0, length);
        while (length == bSize) {
            tempBuf = new byte[bSize];
            length = zipIn.read(tempBuf);
            if (length < 0) {
                throw new EOFException();
            }
            byte[] buffer1 = new byte[buffer.length + length];
            System.arraycopy(buffer, 0, buffer1, 0, buffer.length);
            System.arraycopy(tempBuf, 0, buffer1, buffer.length, length);
            buffer = buffer1;
            buffer1 = null;
            tempBuf = null;
        }
        return new String(buffer, "UTF-8");
    }

    public static String toStringAndZip(String name, Object[] objs) {
        String s = MultiParamKeyString.toString(name, objs);
        try {
            return MultiParamKeyString.zip(s);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception when zip", e);
        }
    }

    public static String toString(String name, Object[] objs) {
        Object out;
        StringBuffer sbuf = new StringBuffer();
        assert (name != null && name.length() > 0);
        sbuf.append(name);
        if (objs != null && objs.length > 0) {
            sbuf.append("!");
            for (int i = 0; i < objs.length; ++i) {
                sbuf.append("arg").append(i).append(":");
                MultiParamKeyString.dealObject(sbuf, objs[i]);
                sbuf.append(";");
            }
        }
        if ("false".equalsIgnoreCase(System.getProperty("bos.mpks.digest"))) {
            return sbuf.toString();
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            out = new InnerOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream((OutputStream)out);
            objOut.writeObject(sbuf.toString());
            int length = 0;
            for (int offset = 0; offset < ((ByteArrayOutputStream)out).size(); offset += 256) {
                length = Math.min(((ByteArrayOutputStream)out).size() - offset, 256);
                md.update(((InnerOutputStream)out).getBuffer(), offset, length);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MessageDigest error", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException when generate md5", e);
        }
        out = md.digest();
        return Base64Encoder.byteArrayToBase64((byte[])out);
    }

    private static void dealMap(StringBuffer sbuf, Object object) {
        Map map = (Map)object;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Object key : map.keySet()) {
            StringBuffer sbuf1 = new StringBuffer();
            MultiParamKeyString.dealObject(sbuf1, map.get(key));
            String sKey = "";
            sKey = key == null || sKey.toString() == null ? "null" : key.toString();
            treeMap.put(sKey, sbuf1.toString());
        }
        sbuf.append(treeMap.toString());
    }

    private static void dealObject(StringBuffer sbuf, Object object) {
        if (object == null) {
            sbuf.append("null");
        } else if (object instanceof Identity) {
            sbuf.append(((Identity)object).getIdentity());
        } else {
            Class<?> paramClass = object.getClass();
            if (paramClass.isArray()) {
                try {
                    MultiParamKeyString.dealArray(sbuf, object);
                }
                catch (Exception e) {
                    logger.warn((Object)e, (Throwable)e);
                }
            } else if (Map.class.isAssignableFrom(paramClass)) {
                MultiParamKeyString.dealMap(sbuf, object);
            } else {
                sbuf.append("[").append(paramClass).append("]");
                sbuf.append(object);
            }
        }
    }

    private static void dealArray(StringBuffer sb, Object array) throws Exception {
        sb.append("{");
        int size = Array.getLength(array);
        for (int i = 0; i < size; ++i) {
            Object element = Array.get(array, i);
            MultiParamKeyString.dealObject(sb, element);
            if (i >= size - 1) continue;
            sb.append(",");
        }
        sb.append("}");
    }

    static class InnerOutputStream
    extends ByteArrayOutputStream {
        InnerOutputStream() {
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

