/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.impl.AbstractRowSet;
import com.kingdee.jdbc.rowset.impl.Row;
import com.kingdee.jdbc.rowset.impl.RowSetMetaDataImpl;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.sql.RowSetMetaData;
import org.apache.log4j.Logger;

public class JdbcRowSet
extends AbstractRowSet {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.jdbc.rowset.impl.JdbcRowSet");
    public static int UPPER_CELLNUMBER_FOR_LOG = Integer.MAX_VALUE;
    public static int UPPER_CELLNUMBER_FOR_EXCEPTION = Integer.MAX_VALUE;
    public static int CriticalIDList = Integer.MAX_VALUE;
    public static int CriticalCollection = Integer.MAX_VALUE;

    public void populate(ResultSet rs) throws SQLException {
        this.populate(rs, 0, -1, true);
    }

    public void populate(ResultSet rs, int rows) throws SQLException {
        this.populate(rs, 0, rows, true);
    }

    public int populate(ResultSet rs, int start, int rows, boolean refreshMetaData) throws SQLException {
        ResultSetMetaData RSMD = rs.getMetaData();
        int colCount = RSMD.getColumnCount();
        int fetched = 0;
        int currentRowIndex = -1;
        int logNumber = Integer.MAX_VALUE;
        int exceptionNumber = Integer.MAX_VALUE;
        assert (colCount > 0);
        if (UPPER_CELLNUMBER_FOR_LOG > 0) {
            logNumber = UPPER_CELLNUMBER_FOR_LOG;
        }
        if (UPPER_CELLNUMBER_FOR_EXCEPTION > 0) {
            exceptionNumber = UPPER_CELLNUMBER_FOR_EXCEPTION;
        }
        while (rs.next()) {
            if (start == -1 || ++currentRowIndex < start) continue;
            if (currentRowIndex >= start && (fetched < rows || rows == -1)) {
                Row row = new Row(colCount);
                for (int k = 1; k <= colCount; ++k) {
                    row.initColumnObject(k, rs.getObject(k));
                }
                this.cachedRows.add(row);
                int fetchedCell = (this.numRows + ++fetched) * colCount;
                if (fetchedCell >= exceptionNumber) {
                    try {
                        StringBuffer msgBuf = new StringBuffer("fetched too much rows, cell number exceeding limit ");
                        msgBuf.append(exceptionNumber).append(". fetched column count:").append(colCount).append(". fected row count:").append(this.numRows + fetched).append(". fected cell count:").append(fetchedCell);
                        throw new FetchedTooMuchRowsException(msgBuf.toString());
                    }
                    catch (SQLException sqle) {
                        logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                        throw sqle;
                    }
                }
            }
            if (fetched != rows) continue;
        }
        this.numRows += fetched;
        int fetchedCell = this.numRows * colCount;
        StringBuffer msgBuf = new StringBuffer("fetched too much rows, cell number exceeding log limit ");
        msgBuf.append(logNumber).append(". fetched column count:").append(colCount).append(". fected row count:").append(this.numRows + fetched).append(". fected cell count:").append(fetchedCell);
        if (fetchedCell >= logNumber) {
            try {
                throw new FetchedTooMuchRowsException(msgBuf.toString());
            }
            catch (SQLException sqle) {
                logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
            }
        }
        if (refreshMetaData) {
            this.rowSetMD = new RowSetMetaDataImpl();
            this.initMetaData(this.rowSetMD, RSMD);
        }
        RSMD = null;
        return fetched;
    }

    protected void initMetaData(RowSetMetaData rowSetMeta, ResultSetMetaData resultSetMeta) throws SQLException {
        int i = resultSetMeta.getColumnCount();
        rowSetMeta.setColumnCount(i);
        for (int j = 1; j <= i; ++j) {
            try {
                rowSetMeta.setAutoIncrement(j, resultSetMeta.isAutoIncrement(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("autoIncrement");
            }
            try {
                rowSetMeta.setCaseSensitive(j, resultSetMeta.isCaseSensitive(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("caseSensitive");
            }
            try {
                rowSetMeta.setCurrency(j, resultSetMeta.isCurrency(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("currency");
            }
            try {
                rowSetMeta.setNullable(j, resultSetMeta.isNullable(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("nullable");
            }
            try {
                rowSetMeta.setSigned(j, resultSetMeta.isSigned(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("signed");
            }
            try {
                rowSetMeta.setSearchable(j, resultSetMeta.isSearchable(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("searchable");
            }
            try {
                rowSetMeta.setColumnDisplaySize(j, resultSetMeta.getColumnDisplaySize(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("columnDisplaySize");
            }
            try {
                rowSetMeta.setColumnLabel(j, resultSetMeta.getColumnLabel(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("columnLabel");
            }
            try {
                rowSetMeta.setColumnName(j, resultSetMeta.getColumnName(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("columnName");
            }
            try {
                rowSetMeta.setSchemaName(j, resultSetMeta.getSchemaName(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("schemaName");
            }
            try {
                rowSetMeta.setPrecision(j, resultSetMeta.getPrecision(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("precision");
            }
            try {
                rowSetMeta.setScale(j, resultSetMeta.getScale(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("scale");
            }
            try {
                rowSetMeta.setTableName(j, resultSetMeta.getTableName(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("tableName");
            }
            try {
                rowSetMeta.setCatalogName(j, resultSetMeta.getCatalogName(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("catalogName");
            }
            try {
                rowSetMeta.setColumnType(j, resultSetMeta.getColumnType(j));
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("columnType");
            }
            try {
                rowSetMeta.setColumnTypeName(j, resultSetMeta.getColumnTypeName(j));
                continue;
            }
            catch (Exception ex) {
                ((RowSetMetaDataImpl)rowSetMeta).addUnsupportedMethod("columnTypeName");
            }
        }
    }

    @Override
    public void execute() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCommand() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCommand(String s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object[] getParams() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearParameters() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setArray(int i, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBigDecimal(int i, BigDecimal bigdecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int i, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(int i, boolean flag) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setByte(int i, byte byte0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBytes(int i, byte[] abyte) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int i, Reader reader, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int i, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(int i, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(int i, Date date, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(int i, double d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFloat(int i, float f) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(int i, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLong(int i, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int i, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int i, int j, String s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int i, Object obj) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int i, Object obj, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int i, Object obj, int j, int k) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRef(int i, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShort(int i, short word0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(int i, String s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(int i, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(int i, Time time, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setUnicodeStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int i, InputStream inputstream, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String s, InputStream inputstream, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int i, BigDecimal bigdecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(String s, BigDecimal bigdecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String s, InputStream inputstream, int i) throws SQLException {
        this.updateBinaryStream(this.getColIdxByName(s), inputstream, i);
    }

    @Override
    public void updateBoolean(int i, boolean flag) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(String s, boolean flag) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(int i, byte byte0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(String s, byte byte0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(int i, byte[] abyte0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(String s, byte[] abyte0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int i, Reader reader, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String s, Reader reader, int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(int i, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(String s, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(int i, double d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(String s, double d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(int i, float f) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(String s, float f) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(int i, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(String s, int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(int i, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(String s, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(String s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int i, Object obj) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int i, Object obj, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String s, Object obj) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String s, Object obj, int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(int i, short word0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(String s, short word0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(int i, String s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(String s, String s1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(int i, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(String s, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(int i, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(String s, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(int paramInt, Class<T> paramClass) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String paramString, Class<T> paramClass) throws SQLException {
        return null;
    }
}

