/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.jdbc.rowset.impl.SQLOutputImpl;
import com.kingdee.jdbc.rowset.impl.SerialArray;
import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.jdbc.rowset.impl.SerialClob;
import com.kingdee.jdbc.rowset.impl.SerialRef;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class SerialStruct
implements Struct,
IMarshalObject,
Cloneable {
    private static Logger logger = Logger.getLogger(SerialStruct.class);
    private String SQLTypeName;
    private Object[] attribs;

    SerialStruct(SQLData sqldata, Map map) throws SQLException {
        this.SQLTypeName = sqldata.getSQLTypeName();
        ArrayList vector = new ArrayList();
        sqldata.writeSQL(new SQLOutputImpl(vector, map));
        this.attribs = vector.toArray(new Object[vector.size()]);
    }

    SerialStruct(Struct struct, Map map) throws SQLException {
        this.SQLTypeName = struct.getSQLTypeName();
        this.attribs = struct.getAttributes(map);
        this.mapToSerial(map);
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.attribs;
    }

    public Object[] getAttributes(Map map) throws SQLException {
        return this.attribs;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.SQLTypeName;
    }

    private void mapToSerial(Map map) throws SQLException {
        for (int i = 0; i < this.attribs.length; ++i) {
            if (this.attribs[i] instanceof Struct) {
                this.attribs[i] = new SerialStruct((Struct)this.attribs[i], map);
                continue;
            }
            if (this.attribs[i] instanceof SQLData) {
                this.attribs[i] = new SerialStruct((SQLData)this.attribs[i], map);
                continue;
            }
            if (this.attribs[i] instanceof Blob) {
                this.attribs[i] = new SerialBlob((Blob)this.attribs[i]);
                continue;
            }
            if (this.attribs[i] instanceof Clob) {
                this.attribs[i] = new SerialClob((Clob)this.attribs[i]);
                continue;
            }
            if (this.attribs[i] instanceof Ref) {
                this.attribs[i] = new SerialRef((Ref)this.attribs[i]);
                continue;
            }
            if (!(this.attribs[i] instanceof Array)) continue;
            this.attribs[i] = new SerialArray((Array)this.attribs[i], map);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SerialStruct stru = (SerialStruct)super.clone();
        stru.SQLTypeName = this.SQLTypeName.intern();
        stru.attribs = (Object[])this.attribs.clone();
        return stru;
    }

    public SerialStruct() {
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject(this.SQLTypeName);
        if (this.attribs == null) {
            marshaller.writeInt(0);
        } else {
            marshaller.writeInt(this.attribs.length);
            for (int i = 0; i < this.attribs.length; ++i) {
                marshaller.writeObject(this.attribs[i]);
            }
        }
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.SQLTypeName = (String)unmarshaller.readObject();
        int len = unmarshaller.readInt();
        this.attribs = new Object[len];
        for (int i = 0; i < len; ++i) {
            this.attribs[i] = unmarshaller.readObject();
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate(this).readExternal(in);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate(this).writeExternal(out);
    }
}

