/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class BaseException
extends Exception {
    protected transient Throwable cause = null;
    private String causeClassName = null;
    private boolean hasCause = false;
    private boolean hasSer = false;
    private String causeMessage = null;
    private String causeStack = null;
    private static final ClassLoader BOOT_CL = Object.class.getClassLoader();

    private synchronized void dumpToString() {
        if (this.needSerialize()) {
            if (this.hasCause) {
                this.causeMessage = this.cause.getMessage() + " [Client -- String Serialize]";
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    MyPrintStream ps = new MyPrintStream(os);
                    ps.println(this.cause.getClass().getName());
                    this.cause.printStackTrace(ps);
                    this.causeStack = ps.toString() + " [Client -- String Serialize]";
                }
                catch (UnsupportedEncodingException e) {
                    this.causeStack = " [Client -- String Serialize]";
                }
            }
            this.hasSer = true;
        }
    }

    private boolean needSerialize() {
        if (this.hasSer || this.cause == null) {
            return false;
        }
        return this.isThirdException(this.cause);
    }

    private boolean isThirdException(Throwable t) {
        if (t instanceof BaseException) {
            return false;
        }
        return !this.pureSystemClass(t);
    }

    private boolean pureSystemClass(Throwable t) {
        if (t == null) {
            return true;
        }
        if (this.matchSystemName(t) && t.getClass().getClassLoader() == BOOT_CL) {
            Throwable c = t.getCause();
            if (t instanceof BaseException || this.pureSystemClass(c)) {
                return true;
            }
        }
        return false;
    }

    private boolean matchSystemName(Throwable t) {
        String name = t.getClass().getName();
        return name.startsWith("java.") || name.startsWith("javax.");
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        this.dumpToString();
        os.defaultWriteObject();
        if (!this.hasSer) {
            os.writeObject(this.cause);
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        if (!this.hasSer) {
            this.cause = (Throwable)is.readObject();
        }
    }

    public BaseException() {
        this.initCause(null);
    }

    public BaseException(String message) {
        super(message);
        this.initCause(null);
    }

    public BaseException(String message, Throwable cause) {
        super(message);
        if (!this.isThirdException(cause) && cause != this) {
            this.initCause(cause);
        } else {
            this.initCause(null);
        }
        if (cause != this) {
            this.cause = this.replaceCause(cause);
            if (cause != null) {
                this.hasCause = true;
                this.causeClassName = cause.getClass().getName();
            }
        }
    }

    public BaseException(Throwable cause) {
        if (!this.isThirdException(cause) && cause != this) {
            this.initCause(cause);
        } else {
            this.initCause(null);
        }
        if (cause != null) {
            this.cause = this.replaceCause(cause);
            if (cause != null) {
                this.hasCause = true;
                this.causeClassName = cause.getClass().getName();
            }
        }
    }

    private Throwable replaceCause(Throwable oldEX) {
        SQLException oldEX1;
        SQLException newEX;
        if (oldEX == null) {
            return null;
        }
        if (oldEX instanceof SQLException && (newEX = (oldEX1 = (SQLException)oldEX).getNextException()) != null) {
            return newEX;
        }
        return oldEX;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public String getCauseClassName() {
        return this.causeClassName;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (!this.hasCause) {
            return message;
        }
        if (message == null) {
            return "Caused exception message is: \n" + (this.hasSer ? this.causeMessage : this.cause.getMessage());
        }
        return message + "\nCaused exception message is: \n" + (this.hasSer ? this.causeMessage : this.cause.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            if (this.hasCause) {
                if (this.hasSer) {
                    s.println("Caused By: " + this.causeStack);
                } else {
                    s.println("Caused by: " + this.cause.getClass().getName());
                    this.cause.printStackTrace(s);
                }
            }
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            if (this.hasCause) {
                if (this.hasSer) {
                    pw.println("Caused By: " + this.causeStack);
                } else {
                    pw.println("Caused by: " + this.cause.getClass().getName());
                    this.cause.printStackTrace(pw);
                }
            }
        }
    }

    private static class MyPrintStream
    extends PrintStream {
        private ByteArrayOutputStream os = null;

        public MyPrintStream(ByteArrayOutputStream os) throws UnsupportedEncodingException {
            super((OutputStream)os, false, "UTF8");
            os.reset();
            this.os = os;
        }

        private MyPrintStream() {
            super((OutputStream)null);
        }

        public String toString() {
            try {
                return this.os.toString("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
    }
}

