/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.InvalidDataException;
import com.kingdee.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BeanWrapper {
    private static final Logger logger = Logger.getLogger(BeanWrapper.class);
    private final Object bean;
    private final BeanInfo beanInfo;

    public BeanWrapper(Object bean) {
        this.bean = bean;
        try {
            this.beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException ie) {
            logger.error((Object)ie.getMessage(), (Throwable)ie);
            throw new InvalidDataException(ie.getMessage());
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public Class getPropertyType(String propertyName) {
        assert (!StringUtils.isEmpty(propertyName));
        PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
        if (pds != null && pds.length > 0) {
            for (int i = 0; i < pds.length; ++i) {
                if (!propertyName.equals(pds[i].getName())) continue;
                return pds[i].getPropertyType();
            }
        }
        return null;
    }

    public Object getPropertyValue(String propertyName) {
        assert (!StringUtils.isEmpty(propertyName));
        PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
        if (pds != null && pds.length > 0) {
            for (int i = 0; i < pds.length; ++i) {
                if (!propertyName.equals(pds[i].getName()) || pds[i].getReadMethod() == null) continue;
                try {
                    return pds[i].getReadMethod().invoke(this.bean, null);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new InvalidDataException(e.getMessage());
                }
            }
        }
        return null;
    }

    public void setPropertyValue(String propertyName, Object val) {
        assert (!StringUtils.isEmpty(propertyName));
        PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
        if (pds != null && pds.length > 0) {
            for (int i = 0; i < pds.length; ++i) {
                if (!propertyName.equals(pds[i].getName()) || pds[i].getWriteMethod() == null) continue;
                try {
                    pds[i].getWriteMethod().invoke(this.bean, val);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new InvalidDataException(e.getMessage());
                }
            }
        }
    }

    public Map toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
        if (pds != null && pds.length > 0) {
            for (int i = 0; i < pds.length; ++i) {
                String propName = pds[i].getName();
                if (pds[i].getReadMethod() == null) continue;
                try {
                    map.put(propName, pds[i].getReadMethod().invoke(this.bean, null));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new InvalidDataException(e.getMessage());
                }
            }
        }
        return map;
    }
}

