/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class DbSequenceImpl {
    public static final long SEQ_BLOCK_SIZE = 1000L;
    public static final long SEQ_BLOCK_SIZE1 = 999L;
    private static final Map<String, DbSequenceImpl> instances = new HashMap<String, DbSequenceImpl>(4);
    private long systemId = 0L;
    private long start = -1L;
    private long end = -1L;
    private long nextValue = this.start;

    private DbSequenceImpl() {
    }

    private long next() {
        return this.nextValue++;
    }

    private boolean isValid() {
        return this.nextValue <= this.end && this.start >= 0L && this.end >= this.start;
    }

    private void reset(long start, long end) {
        this.start = start;
        this.end = end;
        this.nextValue = start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long getSequenceValue(String ais, Connection conn) {
        String instanceKey = ais;
        DbSequenceImpl instance = instances.get(instanceKey);
        if (instance == null) {
            instance = new DbSequenceImpl();
            instances.put(instanceKey, instance);
        }
        if (!instance.isValid()) {
            Statement stmt = null;
            long start = 0L;
            try {
                SecureRandom random = new SecureRandom();
                stmt = conn.createStatement();
                boolean invalid = true;
                while (invalid) {
                    try (ResultSet rs = null;){
                        rs = stmt.executeQuery("select SYSTEM_ID,NEXT_VALUE from T_SEQ_NEXT");
                        if (rs.next()) {
                            instance.systemId = rs.getLong(1) << 48;
                            long tmp = start;
                            start = rs.getLong(2);
                            if (start < tmp) {
                                start = tmp;
                            }
                            boolean isDuplicate = false;
                            while (rs.next()) {
                                isDuplicate = true;
                                tmp = rs.getLong(2);
                                if (start >= tmp) continue;
                                start = tmp;
                            }
                            if (isDuplicate) {
                                stmt.executeUpdate("delete from T_SEQ_NEXT where NEXT_VALUE <> " + start);
                                conn.commit();
                            }
                        } else {
                            long randomSystemId = (long)(random.nextDouble() * 65534.0 + 1.0);
                            stmt.executeUpdate("insert into T_SEQ_NEXT (SYSTEM_ID,NEXT_VALUE) values(" + randomSystemId + "," + start + ")");
                            conn.commit();
                            instance.systemId = randomSystemId << 48;
                        }
                    }
                    int result = stmt.executeUpdate("update T_SEQ_NEXT set NEXT_VALUE=NEXT_VALUE+1000 where NEXT_VALUE = " + start);
                    conn.commit();
                    if (result != 1) continue;
                    invalid = false;
                }
            }
            catch (SQLException e) {
                long l = 0L;
                return l;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            instance.reset(start, start + 999L);
        }
        long id = instance.next() ^ instance.systemId;
        return id;
    }

    public static void main(String[] args) {
        SecureRandom random = new SecureRandom();
        int n = 1000;
        for (int i = 0; i < n; ++i) {
            long a = (long)(random.nextDouble() * 65534.0 + 1.0);
            System.out.println(a);
        }
    }
}

